/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.api.client.util.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;

public class GenericDataTest
extends TestCase {
    public void testEquals_Symmetric() {
        GenericData1 actual = new GenericData1();
        actual.set("fieldA", "bar");
        GenericData2 expected = new GenericData2();
        expected.set("fieldA", "bar");
        GenericDataTest.assertNotSame((Object)((Object)expected), (Object)((Object)actual));
        GenericDataTest.assertTrue((expected.equals((Object)expected) && actual.equals((Object)actual) ? 1 : 0) != 0);
        expected.set("fieldA", "far");
        GenericDataTest.assertFalse((expected.equals((Object)actual) || actual.equals((Object)expected) ? 1 : 0) != 0);
        GenericDataTest.assertFalse((expected.hashCode() == actual.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals_SymmetricWithSameClass() {
        MyData actual = new MyData();
        actual.set("fieldA", "bar");
        MyData expected = new MyData();
        expected.set("fieldA", "bar");
        GenericDataTest.assertNotSame((Object)((Object)expected), (Object)((Object)actual));
        GenericDataTest.assertTrue((expected.equals((Object)expected) && actual.equals((Object)actual) ? 1 : 0) != 0);
        GenericDataTest.assertTrue((expected.hashCode() == expected.hashCode() ? 1 : 0) != 0);
    }

    public void testNotEquals_SymmetricWithSameClass() {
        MyData actual = new MyData();
        actual.set("fieldA", "bar");
        MyData expected = new MyData();
        expected.set("fieldA", "far");
        GenericDataTest.assertNotSame((Object)((Object)expected), (Object)((Object)actual));
        GenericDataTest.assertFalse((expected.equals((Object)actual) || actual.equals((Object)expected) ? 1 : 0) != 0);
        GenericDataTest.assertFalse((expected.hashCode() == actual.hashCode() ? 1 : 0) != 0);
    }

    public void testClone_changingEntrySet() {
        GenericData data = new GenericData();
        GenericDataTest.assertEquals((String)"GenericData{classInfo=[], {}}", (String)data.toString());
        GenericData clone = data.clone();
        clone.set("foo", (Object)"bar");
        GenericDataTest.assertEquals((String)"GenericData{classInfo=[], {foo=bar}}", (String)clone.toString());
    }

    public void testSetIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        data.set("Foobar", (Object)"oldValue");
        GenericDataTest.assertEquals((Object)"oldValue", (Object)data.get((Object)"Foobar"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
        data.set("fooBAR", (Object)"newValue");
        GenericDataTest.assertEquals((Object)"newValue", (Object)data.get((Object)"Foobar"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
    }

    public void testSetIgnoreCase_class() {
        MyData data = new MyData();
        data.set("FIELDA", "someValue");
        GenericDataTest.assertEquals((String)"someValue", (String)data.fieldA);
        GenericDataTest.assertEquals((int)0, (int)data.getUnknownKeys().size());
    }

    public void testPutIgnoreCase_class() {
        MyData data = new MyData();
        data.fieldA = "123";
        GenericDataTest.assertEquals((Object)"123", (Object)data.put("FIELDA", "someValue"));
        GenericDataTest.assertEquals((String)"someValue", (String)data.fieldA);
        GenericDataTest.assertEquals((int)0, (int)data.getUnknownKeys().size());
    }

    public void testGetIgnoreCase_class() {
        MyData data = new MyData();
        data.fieldA = "someValue";
        GenericDataTest.assertEquals((Object)"someValue", (Object)data.get("FIELDA"));
    }

    public void testRemoveIgnoreCase_class() {
        MyData data = new MyData();
        data.fieldA = "someValue";
        try {
            data.remove("FIELDA");
            Assert.fail((String)"Tried to remove known field from class");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testPutIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        GenericDataTest.assertEquals(null, (Object)data.put("fooBAR", (Object)"oldValue"));
        GenericDataTest.assertEquals((Object)"oldValue", (Object)data.get((Object)"fooBAR"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
        GenericDataTest.assertEquals((Object)"oldValue", (Object)data.put("fOObar", (Object)"newValue"));
        GenericDataTest.assertEquals((Object)"newValue", (Object)data.get((Object)"fooBAR"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
    }

    public void testGetIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        data.set("One", (Object)1);
        GenericDataTest.assertEquals((Object)1, (Object)data.get((Object)"ONE"));
        data.set("one", (Object)2);
        GenericDataTest.assertEquals((Object)2, (Object)data.get((Object)"ONE"));
        GenericDataTest.assertEquals(null, (Object)data.get((Object)"unknownKey"));
    }

    public void testRemoveIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        data.set("One", (Object)1);
        GenericDataTest.assertEquals((Object)1, (Object)data.remove((Object)"OnE"));
        GenericDataTest.assertEquals((int)0, (int)data.getUnknownKeys().size());
        data.set("testA", (Object)1).set("testa", (Object)2);
        GenericDataTest.assertEquals((Object)2, (Object)data.remove((Object)"TESTA"));
        GenericDataTest.assertEquals(null, (Object)data.remove((Object)"TESTA"));
    }

    public void testPutShouldUseSetter() {
        MyData data = new MyData();
        data.put("fieldB", "value1");
        GenericDataTest.assertEquals((String)"value1", (String)data.fieldB.get(0));
        ArrayList<String> list = new ArrayList<String>();
        list.add("value2");
        data.put("fieldB", list);
        GenericDataTest.assertEquals(list, data.fieldB);
    }

    private class GenericData2
    extends GenericData {
        @Key(value="FieldA")
        public String fieldA;

        public GenericData2() {
            super(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        }
    }

    private class GenericData1
    extends GenericData {
        @Key(value="FieldA")
        public String fieldA;

        public GenericData1() {
            super(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        }
    }

    private class MyData
    extends GenericData {
        @Key(value="FieldA")
        public String fieldA;
        @Key(value="FieldB")
        public List<String> fieldB;

        public MyData() {
            super(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        }

        public void setFieldB(String fieldB) {
            this.fieldB = Lists.newArrayList();
            this.fieldB.add(fieldB);
        }

        public void setFieldB(List<String> fieldB) {
            this.fieldB = fieldB;
        }
    }
}

