/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.json;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class JsonHttpClient {
    private final HttpRequestFactory requestFactory;
    private final JsonHttpRequestInitializer jsonHttpRequestInitializer;
    private final String baseUrl;
    private final String applicationName;
    private final JsonFactory jsonFactory;
    private JsonHttpParser jsonHttpParser;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public final JsonHttpRequestInitializer getJsonHttpRequestInitializer() {
        return this.jsonHttpRequestInitializer;
    }

    public final JsonHttpParser getJsonHttpParser() {
        if (this.jsonHttpParser == null) {
            this.jsonHttpParser = this.createParser();
        }
        return this.jsonHttpParser;
    }

    protected JsonHttpParser createParser() {
        return new JsonHttpParser(this.jsonFactory);
    }

    protected JsonHttpContent createSerializer(Object body) {
        return new JsonHttpContent(this.getJsonFactory(), body);
    }

    protected void initialize(JsonHttpRequest jsonHttpRequest) throws IOException {
        if (this.getJsonHttpRequestInitializer() != null) {
            this.getJsonHttpRequestInitializer().initialize(jsonHttpRequest);
        }
    }

    public JsonHttpClient(HttpTransport transport, JsonFactory jsonFactory, String baseUrl) {
        this(transport, null, null, jsonFactory, baseUrl, null);
    }

    protected JsonHttpClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String baseUrl, String applicationName) {
        this.jsonHttpRequestInitializer = jsonHttpRequestInitializer;
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
        this.applicationName = applicationName;
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        Preconditions.checkNotNull((Object)transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    protected HttpRequest buildHttpRequest(HttpMethod method, String uriTemplate, JsonHttpRequest jsonHttpRequest) throws IOException {
        GenericUrl url = new GenericUrl(UriTemplate.expand(this.getBaseUrl() + uriTemplate, jsonHttpRequest, true));
        HttpRequest httpRequest = this.requestFactory.buildRequest(method, url, null);
        httpRequest.addParser(this.getJsonHttpParser());
        if (this.getApplicationName() != null) {
            httpRequest.getHeaders().setUserAgent(this.getApplicationName());
        }
        return httpRequest;
    }

    protected HttpResponse execute(HttpMethod method, String uriTemplate, Object body, JsonHttpRequest jsonHttpRequest) throws IOException {
        HttpRequest request = this.buildHttpRequest(method, uriTemplate, jsonHttpRequest);
        if (body != null) {
            request.setContent(this.createSerializer(body));
            request.setEnableGZipContent(true);
        } else if (method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            request.setContent(ByteArrayContent.fromString("application/json", " "));
        }
        return request.execute();
    }

    public static Builder builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
        return new Builder(transport, jsonFactory, baseUrl);
    }

    public static class Builder {
        private final HttpTransport transport;
        private JsonHttpRequestInitializer jsonHttpRequestInitializer;
        private HttpRequestInitializer httpRequestInitializer;
        private final JsonFactory jsonFactory;
        private final GenericUrl baseUrl;
        private String applicationName;

        protected Builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
            this.transport = transport;
            this.jsonFactory = jsonFactory;
            this.baseUrl = baseUrl;
        }

        public JsonHttpClient build() {
            return new JsonHttpClient(this.transport, this.jsonHttpRequestInitializer, this.httpRequestInitializer, this.jsonFactory, this.baseUrl.build(), this.applicationName);
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public final GenericUrl getBaseUrl() {
            return this.baseUrl;
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            this.jsonHttpRequestInitializer = jsonHttpRequestInitializer;
            return this;
        }

        public JsonHttpRequestInitializer getJsonHttpRequestInitializer() {
            return this.jsonHttpRequestInitializer;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            this.httpRequestInitializer = httpRequestInitializer;
            return this;
        }

        public final HttpRequestInitializer getHttpRequestInitializer() {
            return this.httpRequestInitializer;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }
    }
}

