/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.json;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class JsonHttpClient {
    static final Logger LOGGER = Logger.getLogger(JsonHttpClient.class.getName());
    private final HttpRequestFactory requestFactory;
    private final JsonHttpRequestInitializer jsonHttpRequestInitializer;
    private final String baseUrl;
    private final String applicationName;
    private final JsonFactory jsonFactory;
    private JsonHttpParser jsonHttpParser;

    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public final JsonHttpRequestInitializer getJsonHttpRequestInitializer() {
        return this.jsonHttpRequestInitializer;
    }

    public final JsonHttpParser getJsonHttpParser() {
        if (this.jsonHttpParser == null) {
            this.jsonHttpParser = this.createParser();
        }
        return this.jsonHttpParser;
    }

    protected JsonHttpParser createParser() {
        return new JsonHttpParser(this.jsonFactory);
    }

    protected JsonHttpContent createSerializer(Object body) {
        return new JsonHttpContent(this.getJsonFactory(), body);
    }

    protected void initialize(JsonHttpRequest jsonHttpRequest) throws IOException {
        if (this.getJsonHttpRequestInitializer() != null) {
            this.getJsonHttpRequestInitializer().initialize(jsonHttpRequest);
        }
    }

    public JsonHttpClient(HttpTransport transport, JsonFactory jsonFactory, String baseUrl) {
        this(transport, null, null, jsonFactory, baseUrl, null);
    }

    protected JsonHttpClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String baseUrl, String applicationName) {
        this.jsonHttpRequestInitializer = jsonHttpRequestInitializer;
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
        Preconditions.checkArgument((boolean)baseUrl.endsWith("/"));
        this.applicationName = applicationName;
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        Preconditions.checkNotNull((Object)transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    protected HttpRequest buildHttpRequest(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest httpRequest = this.requestFactory.buildRequest(method, url, null);
        httpRequest.addParser(this.getJsonHttpParser());
        if (this.getApplicationName() != null) {
            httpRequest.getHeaders().setUserAgent(this.getApplicationName());
        }
        if (body != null) {
            httpRequest.setContent(this.createSerializer(body));
        }
        return httpRequest;
    }

    protected HttpResponse executeUnparsed(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest request = this.buildHttpRequest(method, url, body);
        return request.execute();
    }

    protected InputStream executeAsInputStream(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpResponse response = this.executeUnparsed(method, url, body);
        return response.getContent();
    }

    public static Builder builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
        return new Builder(transport, jsonFactory, baseUrl);
    }

    public static class Builder {
        private final HttpTransport transport;
        private JsonHttpRequestInitializer jsonHttpRequestInitializer;
        private HttpRequestInitializer httpRequestInitializer;
        private final JsonFactory jsonFactory;
        private GenericUrl baseUrl;
        private String applicationName;

        protected Builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
            this.transport = transport;
            this.jsonFactory = jsonFactory;
            this.setBaseUrl(baseUrl);
        }

        public JsonHttpClient build() {
            if (Strings.isNullOrEmpty((String)this.applicationName)) {
                LOGGER.warning("Application name is not set. Call setApplicationName.");
            }
            return new JsonHttpClient(this.transport, this.jsonHttpRequestInitializer, this.httpRequestInitializer, this.jsonFactory, this.baseUrl.build(), this.applicationName);
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public final GenericUrl getBaseUrl() {
            return this.baseUrl;
        }

        public Builder setBaseUrl(GenericUrl baseUrl) {
            this.baseUrl = (GenericUrl)Preconditions.checkNotNull((Object)baseUrl);
            Preconditions.checkArgument((boolean)baseUrl.build().endsWith("/"));
            return this;
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            this.jsonHttpRequestInitializer = jsonHttpRequestInitializer;
            return this;
        }

        public JsonHttpRequestInitializer getJsonHttpRequestInitializer() {
            return this.jsonHttpRequestInitializer;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            this.httpRequestInitializer = httpRequestInitializer;
            return this;
        }

        public final HttpRequestInitializer getHttpRequestInitializer() {
            return this.httpRequestInitializer;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }
    }
}

