/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.json;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonEncoding;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonString;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.StringUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;

public abstract class AbstractJsonFactoryTest
extends TestCase {
    private static final String EMPTY = "";
    private static final String EMPTY_OBJECT = "{}";
    private static final String JSON_ENTRY = "{\"title\":\"foo\"}";
    private static final String JSON_FEED = "{\"entries\":[{\"title\":\"foo\"},{\"title\":\"bar\"}]}";
    static final String CONTAINED_MAP = "{\"map\":{\"title\":\"foo\"}}";
    static final String NUMBER_TYPES = "{\"bigDecimalValue\":1.0,\"bigIntegerValue\":1,\"byteObjValue\":1,\"byteValue\":1,\"doubleObjValue\":1.0,\"doubleValue\":1.0,\"floatObjValue\":1.0,\"floatValue\":1.0,\"intObjValue\":1,\"intValue\":1,\"longObjValue\":1,\"longValue\":1,\"shortObjValue\":1,\"shortValue\":1,\"yetAnotherBigDecimalValue\":1}";
    static final String NUMBER_TYPES_AS_STRING = "{\"bigDecimalValue\":\"1.0\",\"bigIntegerValue\":\"1\",\"byteObjValue\":\"1\",\"byteValue\":\"1\",\"doubleObjValue\":\"1.0\",\"doubleValue\":\"1.0\",\"floatObjValue\":\"1.0\",\"floatValue\":\"1.0\",\"intObjValue\":\"1\",\"intValue\":\"1\",\"longObjValue\":\"1\",\"longValue\":\"1\",\"shortObjValue\":\"1\",\"shortValue\":\"1\",\"yetAnotherBigDecimalValue\":\"1\"}";
    private static final String UTF8_VALUE = "123\u05d9\u05e0\u05d9\u05d1";
    private static final String UTF8_JSON = "{\"value\":\"123\u05d9\u05e0\u05d9\u05d1\"}";
    static final String ANY_TYPE = "{\"arr\":[1],\"bool\":true,\"nul\":null,\"num\":5,\"obj\":{\"key\":\"value\"},\"str\":\"value\"}";
    static final String ARRAY_TYPE = "{\"arr\":[4,5],\"arr2\":[[1,2],[3]],\"integerArr\":[6,7]}";
    static final String COLLECTION_TYPE = "{\"arr\":[[\"a\",\"b\"],[\"c\"]]}";
    static final String MAP_TYPE = "{\"value\":[{\"map1\":{\"k1\":1,\"k2\":2},\"map2\":{\"kk1\":3,\"kk2\":4}}]}";
    static final String WILDCARD_TYPE = "{\"lower\":[[1,2,3]],\"map\":{\"v\":1},\"mapInWild\":[{\"v\":1}],\"mapUpper\":{\"v\":1},\"simple\":[[1,2,3]],\"upper\":[[1,2,3]]}";
    static final String INTEGER_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,1]],\"list\":[null,[null,1]],\"nullValue\":null,\"value\":1}";
    static final String INT_ARRAY_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,[1]]],\"list\":[null,[null,[1]]],\"nullValue\":null,\"value\":[1]}";
    static final String DOUBLE_LIST_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,[1.0]]],\"list\":[null,[null,[1.0]]],\"nullValue\":null,\"value\":[1.0]}";
    static final String FLOAT_MAP_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,{\"a\":1.0}]],\"list\":[null,[null,{\"a\":1.0}]],\"nullValue\":null,\"value\":{\"a\":1.0}}";
    static final String NULL_VALUE = "{\"arr\":[null],\"arr2\":[null,[null]],\"value\":null}";
    static final String ENUM_VALUE = "{\"nullValue\":null,\"otherValue\":\"other\",\"value\":\"VALUE\"}";
    static final String TYPE_VARS = "{\"y\":{\"z\":{\"f\":[\"abc\"]}}}";
    static final String STRING_ARRAY = "[\"a\",\"b\",\"c\"]";
    static final String INT_ARRAY = "[1,2,3]";
    private static final String EMPTY_ARRAY = "[]";
    private static final String NUMBER_TOP_VALUE = "1";
    private static final String STRING_TOP_VALUE = "\"a\"";
    private static final String NULL_TOP_VALUE = "null";
    private static final String BOOL_TOP_VALUE = "true";

    public AbstractJsonFactoryTest(String name) {
        super(name);
    }

    protected abstract JsonFactory newFactory();

    public void testParse_empty() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(EMPTY);
        parser.nextToken();
        try {
            parser.parseAndClose(HashMap.class, null);
            AbstractJsonFactoryTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_emptyMap() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(EMPTY_OBJECT);
        parser.nextToken();
        HashMap map = parser.parseAndClose(HashMap.class, null);
        AbstractJsonFactoryTest.assertTrue((boolean)map.isEmpty());
    }

    public void testParse_emptyGenericJson() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(EMPTY_OBJECT);
        parser.nextToken();
        GenericJson json = parser.parseAndClose(GenericJson.class, null);
        AbstractJsonFactoryTest.assertTrue((boolean)json.isEmpty());
    }

    public void testParser_partialEmpty() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(EMPTY_OBJECT);
        parser.nextToken();
        parser.nextToken();
        HashMap result = parser.parseAndClose(HashMap.class, null);
        AbstractJsonFactoryTest.assertEquals((String)EMPTY_OBJECT, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertTrue((boolean)result.isEmpty());
    }

    public void testParseEntry() throws Exception {
        Entry entry = this.newFactory().createJsonParser(JSON_ENTRY).parseAndClose(Entry.class, null);
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)entry.title);
    }

    public void testParser_partialEntry() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.nextToken();
        Entry result = parser.parseAndClose(Entry.class, null);
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)result.title);
    }

    public void testParseFeed() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        parser.nextToken();
        Feed feed = parser.parseAndClose(Feed.class, null);
        Iterator<Entry> iterator = feed.entries.iterator();
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)iterator.next().title);
        AbstractJsonFactoryTest.assertEquals((String)"bar", (String)iterator.next().title);
        AbstractJsonFactoryTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testParseEntryAsMap() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        HashMap map = parser.parseAndClose(HashMap.class, null);
        AbstractJsonFactoryTest.assertEquals((Object)"foo", map.remove("title"));
        AbstractJsonFactoryTest.assertTrue((boolean)map.isEmpty());
    }

    public void testSkipToKey_missingEmpty() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(EMPTY_OBJECT);
        parser.nextToken();
        parser.skipToKey("missing");
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.getCurrentToken()));
    }

    public void testSkipToKey_missing() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipToKey("missing");
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.getCurrentToken()));
    }

    public void testSkipToKey_found() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipToKey("title");
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.VALUE_STRING), (Object)((Object)parser.getCurrentToken()));
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)parser.getText());
    }

    public void testSkipToKey_startWithFieldName() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.nextToken();
        parser.skipToKey("title");
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.VALUE_STRING), (Object)((Object)parser.getCurrentToken()));
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)parser.getText());
    }

    public void testSkipChildren_string() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipToKey("title");
        parser.skipChildren();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.VALUE_STRING), (Object)((Object)parser.getCurrentToken()));
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)parser.getText());
    }

    public void testSkipChildren_object() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipChildren();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.getCurrentToken()));
    }

    public void testSkipChildren_array() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        parser.nextToken();
        parser.skipToKey("entries");
        parser.skipChildren();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_ARRAY), (Object)((Object)parser.getCurrentToken()));
    }

    public void testNextToken() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_OBJECT), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.FIELD_NAME), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_ARRAY), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_OBJECT), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.FIELD_NAME), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.VALUE_STRING), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_OBJECT), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.FIELD_NAME), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.VALUE_STRING), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_ARRAY), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.nextToken()));
        AbstractJsonFactoryTest.assertNull((Object)((Object)parser.nextToken()));
    }

    public void testCurrentToken() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        AbstractJsonFactoryTest.assertNull((Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_OBJECT), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.FIELD_NAME), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_ARRAY), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_OBJECT), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.FIELD_NAME), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.VALUE_STRING), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.START_OBJECT), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.FIELD_NAME), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.VALUE_STRING), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_ARRAY), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)((Object)JsonToken.END_OBJECT), (Object)((Object)parser.getCurrentToken()));
        parser.nextToken();
        AbstractJsonFactoryTest.assertNull((Object)((Object)parser.getCurrentToken()));
    }

    public void testParse() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser(CONTAINED_MAP);
        parser.nextToken();
        A a = parser.parse(A.class, null);
        AbstractJsonFactoryTest.assertEquals((Object)ImmutableMap.of((Object)"title", (Object)"foo"), a.map);
    }

    public void testParser_numberTypes() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(NUMBER_TYPES);
        parser.nextToken();
        NumberTypes result = parser.parse(NumberTypes.class, null);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TYPES, (String)factory.toString(result));
        parser = factory.createJsonParser(NUMBER_TYPES_AS_STRING);
        parser.nextToken();
        NumberTypesAsString resultAsString = parser.parse(NumberTypesAsString.class, null);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TYPES_AS_STRING, (String)factory.toString(resultAsString));
        try {
            parser = factory.createJsonParser(NUMBER_TYPES_AS_STRING);
            parser.nextToken();
            parser.parse(NumberTypes.class, null);
            AbstractJsonFactoryTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            parser = factory.createJsonParser(NUMBER_TYPES);
            parser.nextToken();
            parser.parse(NumberTypesAsString.class, null);
            AbstractJsonFactoryTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testToFromString() throws IOException {
        JsonFactory factory = this.newFactory();
        NumberTypes result = factory.fromString(NUMBER_TYPES, NumberTypes.class);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TYPES, (String)factory.toString(result));
    }

    public void testToFromString_UTF8() throws IOException {
        JsonFactory factory = this.newFactory();
        GenericJson result = factory.fromString(UTF8_JSON, GenericJson.class);
        AbstractJsonFactoryTest.assertEquals((Object)UTF8_VALUE, (Object)result.get("value"));
        AbstractJsonFactoryTest.assertEquals((String)UTF8_JSON, (String)factory.toString(result));
    }

    public void testParser_anyType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(ANY_TYPE);
        parser.nextToken();
        AnyType result = parser.parse(AnyType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)ANY_TYPE, (String)factory.toString(result));
    }

    public void testParser_arrayType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(ARRAY_TYPE);
        parser.nextToken();
        ArrayType result = parser.parse(ArrayType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)ARRAY_TYPE, (String)factory.toString(result));
        int[] arr = result.arr;
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{4, 5}, arr));
        int[][] arr2 = result.arr2;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr2.length);
        int[] arr20 = arr2[0];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr20.length);
        int arr200 = arr20[0];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arr200);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr20[1]);
        int[] arr21 = arr2[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arr21.length);
        AbstractJsonFactoryTest.assertEquals((int)3, (int)arr21[0]);
        Integer[] integerArr = result.integerArr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)integerArr.length);
        AbstractJsonFactoryTest.assertEquals((int)6, (int)integerArr[0]);
    }

    public void testParser_collectionType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(COLLECTION_TYPE);
        parser.nextToken();
        CollectionOfCollectionType result = parser.parse(CollectionOfCollectionType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)COLLECTION_TYPE, (String)factory.toString(result));
        LinkedList<LinkedList<String>> arr = result.arr;
        LinkedList<String> linkedlist = arr.get(0);
        AbstractJsonFactoryTest.assertEquals((String)"a", (String)linkedlist.get(0));
    }

    public void testParser_mapType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(MAP_TYPE);
        parser.nextToken();
        MapOfMapType result = parser.parse(MapOfMapType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)MAP_TYPE, (String)factory.toString(result));
        Map<String, Map<String, Integer>>[] value = result.value;
        Map<String, Map<String, Integer>> firstMap = value[0];
        Map<String, Integer> map1 = firstMap.get("map1");
        Integer integer = map1.get("k1");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)integer);
        Map<String, Integer> map2 = firstMap.get("map2");
        AbstractJsonFactoryTest.assertEquals((int)3, (int)map2.get("kk1"));
        AbstractJsonFactoryTest.assertEquals((int)4, (int)map2.get("kk2"));
    }

    public void testParser_hashmapForMapType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(MAP_TYPE);
        parser.nextToken();
        HashMap result = parser.parse(HashMap.class, null);
        AbstractJsonFactoryTest.assertEquals((String)MAP_TYPE, (String)factory.toString(result));
        ArrayList value = (ArrayList)result.get("value");
        ArrayMap firstMap = (ArrayMap)value.get(0);
        ArrayMap map1 = (ArrayMap)firstMap.get("map1");
        BigDecimal integer = (BigDecimal)map1.get("k1");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)integer.intValue());
    }

    public void testParser_wildCardType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(WILDCARD_TYPE);
        parser.nextToken();
        WildCardTypes result = parser.parse(WildCardTypes.class, null);
        AbstractJsonFactoryTest.assertEquals((String)WILDCARD_TYPE, (String)factory.toString(result));
        Collection<?>[] simple = result.simple;
        ArrayList wildcard = (ArrayList)simple[0];
        BigDecimal wildcardFirstValue = (BigDecimal)wildcard.get(0);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)wildcardFirstValue.intValue());
        Collection<? extends Integer>[] upper = result.upper;
        ArrayList wildcardUpper = (ArrayList)upper[0];
        Integer wildcardFirstValueUpper = (Integer)wildcardUpper.get(0);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)wildcardFirstValueUpper);
        Collection<? super Integer>[] lower = result.lower;
        ArrayList wildcardLower = (ArrayList)lower[0];
        Integer wildcardFirstValueLower = (Integer)wildcardLower.get(0);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)wildcardFirstValueLower);
        Map<String, ?> map = result.map;
        BigDecimal mapValue = (BigDecimal)map.get("v");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)mapValue.intValue());
        Map<String, ? extends Integer> mapUpper = result.mapUpper;
        Integer mapUpperValue = mapUpper.get("v");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)mapUpperValue);
        ArrayList mapInWild = (ArrayList)result.mapInWild;
        TreeMap mapInWildFirst = (TreeMap)mapInWild.get(0);
        Integer mapInWildFirstValue = (Integer)mapInWildFirst.get("v");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)mapInWildFirstValue);
    }

    public void testParser_integerTypeVariableType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INTEGER_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        IntegerTypeVariableType result = parser.parse(IntegerTypeVariableType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)INTEGER_TYPE_VARIABLE_TYPE, (String)factory.toString(result));
        Integer[][] arr = (Integer[][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(Integer[].class), (Object)arr[0]);
        Integer[] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.NULL_INTEGER, (Object)subArr[0]);
        Integer arrValue = subArr[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue);
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.NULL_INTEGER, subList.get(0));
        arrValue = (Integer)subList.get(1);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue);
        Integer nullValue = (Integer)result.nullValue;
        AbstractJsonFactoryTest.assertEquals((Object)Data.NULL_INTEGER, (Object)nullValue);
        Integer value = (Integer)result.value;
        AbstractJsonFactoryTest.assertEquals((int)1, (int)value);
    }

    public void testParser_intArrayTypeVariableType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INT_ARRAY_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        IntArrayTypeVariableType result = parser.parse(IntArrayTypeVariableType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)INT_ARRAY_TYPE_VARIABLE_TYPE, (String)factory.toString(result));
        int[][][] arr = (int[][][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(int[][].class), (Object)arr[0]);
        int[][] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(int[].class), (Object)subArr[0]);
        int[] arrValue = subArr[1];
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1}, arrValue));
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(int[].class), subList.get(0));
        arrValue = (int[])subList.get(1);
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1}, arrValue));
        int[] nullValue = (int[])result.nullValue;
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(int[].class), (Object)nullValue);
        int[] value = (int[])result.value;
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1}, value));
    }

    public void testParser_doubleListTypeVariableType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(DOUBLE_LIST_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        DoubleListTypeVariableType result = parser.parse(DoubleListTypeVariableType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)DOUBLE_LIST_TYPE_VARIABLE_TYPE, (String)factory.toString(result));
        List[][] arr = (List[][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(List[].class), (Object)arr[0]);
        List[] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(ArrayList.class), (Object)subArr[0]);
        List arrValue = subArr[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.size());
        Double dValue = (Double)arrValue.get(0);
        AbstractJsonFactoryTest.assertEquals((Object)1.0, (Object)dValue);
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(ArrayList.class), subList.get(0));
        arrValue = (List)subList.get(1);
        AbstractJsonFactoryTest.assertEquals((Object)ImmutableList.of((Object)new Double(1.0)), (Object)arrValue);
        List nullValue = (List)result.nullValue;
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(ArrayList.class), (Object)nullValue);
        List value = (List)result.value;
        AbstractJsonFactoryTest.assertEquals((Object)ImmutableList.of((Object)new Double(1.0)), (Object)value);
    }

    public void testParser_floatMapTypeVariableType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(FLOAT_MAP_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        FloatMapTypeVariableType result = parser.parse(FloatMapTypeVariableType.class, null);
        AbstractJsonFactoryTest.assertEquals((String)FLOAT_MAP_TYPE_VARIABLE_TYPE, (String)factory.toString(result));
        Map[][] arr = (Map[][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(Map[].class), (Object)arr[0]);
        Map[] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(HashMap.class), (Object)subArr[0]);
        Map arrValue = subArr[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.size());
        Float fValue = (Float)arrValue.get("a");
        AbstractJsonFactoryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(fValue.floatValue()));
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(HashMap.class), subList.get(0));
        arrValue = (Map)subList.get(1);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.size());
        fValue = (Float)arrValue.get("a");
        AbstractJsonFactoryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(fValue.floatValue()));
        Map nullValue = (Map)result.nullValue;
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(HashMap.class), (Object)nullValue);
        Map value = (Map)result.value;
        AbstractJsonFactoryTest.assertEquals((int)1, (int)value.size());
        fValue = (Float)value.get("a");
        AbstractJsonFactoryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(fValue.floatValue()));
    }

    public void testParser_treemapForTypeVariableType() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INTEGER_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        TreeMap result = parser.parse(TreeMap.class, null);
        AbstractJsonFactoryTest.assertEquals((String)INTEGER_TYPE_VARIABLE_TYPE, (String)factory.toString(result));
        ArrayList arr = (ArrayList)result.get("arr");
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(Object.class), arr.get(0));
        ArrayList subArr = (ArrayList)arr.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.size());
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(Object.class), subArr.get(0));
        BigDecimal arrValue = (BigDecimal)subArr.get(1);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.intValue());
        Object nullValue = result.get("nullValue");
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(Object.class), nullValue);
        BigDecimal value = (BigDecimal)result.get("value");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)value.intValue());
    }

    public void testParser_nullValue() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(NULL_VALUE);
        parser.nextToken();
        StringNullValue result = parser.parse(StringNullValue.class, null);
        AbstractJsonFactoryTest.assertEquals((String)NULL_VALUE, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertEquals((String)Data.NULL_STRING, (String)result.value);
        String[] arr = result.arr;
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(String.class), (Object)arr[0]);
        String[][] arr2 = result.arr2;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr2.length);
        AbstractJsonFactoryTest.assertEquals(Data.nullOf(String[].class), (Object)arr2[0]);
        String[] subArr2 = arr2[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)subArr2.length);
        AbstractJsonFactoryTest.assertEquals((String)Data.NULL_STRING, (String)subArr2[0]);
    }

    public void testParser_enumValue() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(ENUM_VALUE);
        parser.nextToken();
        EnumValue result = parser.parse(EnumValue.class, null);
        AbstractJsonFactoryTest.assertEquals((String)ENUM_VALUE, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)E.VALUE), (Object)((Object)result.value));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)E.OTHER_VALUE), (Object)((Object)result.otherValue));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)E.NULL), (Object)((Object)result.nullValue));
    }

    public void testParser_typeVariablesPassAround() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(TYPE_VARS);
        parser.nextToken();
        TypeVariablesPassedAround result = parser.parse(TypeVariablesPassedAround.class, null);
        AbstractJsonFactoryTest.assertEquals((String)TYPE_VARS, (String)factory.toString(result));
        LinkedList f = (LinkedList)result.y.z.f;
        AbstractJsonFactoryTest.assertEquals((String)"abc", (String)((String)f.get(0)));
    }

    public void testParser_stringArray() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(STRING_ARRAY);
        parser.nextToken();
        Object[] result = parser.parse(String[].class, null);
        AbstractJsonFactoryTest.assertEquals((String)STRING_ARRAY, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c"}, result));
    }

    public void testParser_intArray() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INT_ARRAY);
        parser.nextToken();
        int[] result = parser.parse(int[].class, null);
        AbstractJsonFactoryTest.assertEquals((String)INT_ARRAY, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3}, result));
    }

    public void testParser_emptyArray() throws IOException {
        JsonFactory factory = this.newFactory();
        String[] result = factory.createJsonParser(EMPTY_ARRAY).parse(String[].class, null);
        AbstractJsonFactoryTest.assertEquals((String)EMPTY_ARRAY, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertEquals((int)0, (int)result.length);
    }

    public void testParser_partialEmptyArray() throws IOException {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(EMPTY_ARRAY);
        parser.nextToken();
        parser.nextToken();
        String[] result = parser.parse(String[].class, null);
        AbstractJsonFactoryTest.assertEquals((String)EMPTY_ARRAY, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertEquals((int)0, (int)result.length);
    }

    public void testParser_num() throws IOException {
        JsonFactory factory = this.newFactory();
        int result = factory.createJsonParser(NUMBER_TOP_VALUE).parse(Integer.TYPE, null);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TOP_VALUE, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertEquals((int)1, (int)result);
    }

    public void testParser_string() throws IOException {
        JsonFactory factory = this.newFactory();
        String result = factory.createJsonParser(STRING_TOP_VALUE).parse(String.class, null);
        AbstractJsonFactoryTest.assertEquals((String)STRING_TOP_VALUE, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertEquals((String)"a", (String)result);
    }

    public void testParser_null() throws IOException {
        JsonFactory factory = this.newFactory();
        String result = factory.createJsonParser(NULL_TOP_VALUE).parse(String.class, null);
        AbstractJsonFactoryTest.assertEquals((String)NULL_TOP_VALUE, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertTrue((boolean)Data.isNull(result));
    }

    public void testParser_bool() throws IOException {
        JsonFactory factory = this.newFactory();
        boolean result = factory.createJsonParser(BOOL_TOP_VALUE).parse(Boolean.TYPE, null);
        AbstractJsonFactoryTest.assertEquals((String)BOOL_TOP_VALUE, (String)factory.toString(result));
        AbstractJsonFactoryTest.assertTrue((boolean)result);
    }

    public final void testGenerateEntry() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator generator = this.newFactory().createJsonGenerator(out, JsonEncoding.UTF8);
        Entry entry = new Entry();
        entry.title = "foo";
        generator.serialize(entry);
        generator.flush();
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)new String(out.toByteArray()));
    }

    public final void testGenerateFeed() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator generator = this.newFactory().createJsonGenerator(out, JsonEncoding.UTF8);
        Feed feed = new Feed();
        Entry entryFoo = new Entry();
        entryFoo.title = "foo";
        Entry entryBar = new Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList<Entry>();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        generator.serialize(feed);
        generator.flush();
        AbstractJsonFactoryTest.assertEquals((String)JSON_FEED, (String)new String(out.toByteArray()));
    }

    public final void testToString_entry() throws Exception {
        Entry entry = new Entry();
        entry.title = "foo";
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)this.newFactory().toString(entry));
    }

    public final void testToString_Feed() throws Exception {
        Feed feed = new Feed();
        Entry entryFoo = new Entry();
        entryFoo.title = "foo";
        Entry entryBar = new Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList<Entry>();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        AbstractJsonFactoryTest.assertEquals((String)JSON_FEED, (String)this.newFactory().toString(feed));
    }

    public final void testToByteArray_entry() throws Exception {
        Entry entry = new Entry();
        entry.title = "foo";
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(StringUtils.getBytesUtf8(JSON_ENTRY), this.newFactory().toByteArray(entry)));
    }

    public final void testToPrettyString_entryApproximate() throws Exception {
        Entry entry = new Entry();
        entry.title = "foo";
        JsonFactory factory = this.newFactory();
        String prettyString = factory.toPrettyString(entry);
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)factory.toString(factory.fromString(prettyString, Entry.class)));
    }

    public final void testToPrettyString_FeedApproximate() throws Exception {
        Feed feed = new Feed();
        Entry entryFoo = new Entry();
        entryFoo.title = "foo";
        Entry entryBar = new Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList<Entry>();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        JsonFactory factory = this.newFactory();
        String prettyString = factory.toPrettyString(feed);
        AbstractJsonFactoryTest.assertEquals((String)JSON_FEED, (String)factory.toString(factory.fromString(prettyString, Feed.class)));
    }

    public void testParser_nullInputStream() throws IOException {
        try {
            this.newFactory().createJsonParser((InputStream)null);
            AbstractJsonFactoryTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParser_nullString() throws IOException {
        try {
            this.newFactory().createJsonParser((String)null);
            AbstractJsonFactoryTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParser_nullReader() throws IOException {
        try {
            this.newFactory().createJsonParser((Reader)null);
            AbstractJsonFactoryTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeVariablesPassedAround
    extends X<LinkedList<String>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Z<ZT> {
        @Key
        ZT f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Y<YT> {
        @Key
        Z<YT> z;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class X<XT> {
        @Key
        Y<XT> y;
    }

    public static class EnumValue {
        @Key
        public E value;
        @Key
        public E otherValue;
        @Key
        public E nullValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum E {
        VALUE,
        OTHER_VALUE,
        NULL,
        IGNORED_VALUE;

    }

    public static class StringNullValue {
        @Key
        public String[][] arr2;
        @Key
        public String[] arr;
        @Key
        public String value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatMapTypeVariableType
    extends TypeVariableType<Map<String, Float>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleListTypeVariableType
    extends TypeVariableType<List<Double>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntArrayTypeVariableType
    extends TypeVariableType<int[]> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerTypeVariableType
    extends TypeVariableType<Integer> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeVariableType<T> {
        @Key
        public T[][] arr;
        @Key
        public LinkedList<LinkedList<T>> list;
        @Key
        public T nullValue;
        @Key
        public T value;
    }

    public static class WildCardTypes {
        @Key
        public Collection<? super Integer>[] lower;
        @Key
        public Map<String, ?> map;
        @Key
        public Collection<? super TreeMap<String, ? extends Integer>> mapInWild;
        @Key
        public Map<String, ? extends Integer> mapUpper;
        @Key
        public Collection<?>[] simple;
        @Key
        public Collection<? extends Integer>[] upper;
    }

    public static class MapOfMapType {
        @Key
        public Map<String, Map<String, Integer>>[] value;
    }

    public static class CollectionOfCollectionType {
        @Key
        public LinkedList<LinkedList<String>> arr;
    }

    public static class ArrayType {
        @Key
        int[] arr;
        @Key
        int[][] arr2;
        @Key
        public Integer[] integerArr;
    }

    public static class AnyType {
        @Key
        public Object arr;
        @Key
        public Object bool;
        @Key
        public Object num;
        @Key
        public Object obj;
        @Key
        public Object str;
        @Key
        public Object nul;
    }

    public static class NumberTypesAsString {
        @Key
        @JsonString
        byte byteValue;
        @Key
        @JsonString
        Byte byteObjValue;
        @Key
        @JsonString
        short shortValue;
        @Key
        @JsonString
        Short shortObjValue;
        @Key
        @JsonString
        int intValue;
        @Key
        @JsonString
        Integer intObjValue;
        @Key
        @JsonString
        float floatValue;
        @Key
        @JsonString
        Float floatObjValue;
        @Key
        @JsonString
        long longValue;
        @Key
        @JsonString
        Long longObjValue;
        @Key
        @JsonString
        double doubleValue;
        @Key
        @JsonString
        Double doubleObjValue;
        @Key
        @JsonString
        BigInteger bigIntegerValue;
        @Key
        @JsonString
        BigDecimal bigDecimalValue;
        @Key(value="yetAnotherBigDecimalValue")
        @JsonString
        BigDecimal anotherBigDecimalValue;
    }

    public static class NumberTypes {
        @Key
        byte byteValue;
        @Key
        Byte byteObjValue;
        @Key
        short shortValue;
        @Key
        Short shortObjValue;
        @Key
        int intValue;
        @Key
        Integer intObjValue;
        @Key
        float floatValue;
        @Key
        Float floatObjValue;
        @Key
        long longValue;
        @Key
        Long longObjValue;
        @Key
        double doubleValue;
        @Key
        Double doubleObjValue;
        @Key
        BigInteger bigIntegerValue;
        @Key
        BigDecimal bigDecimalValue;
        @Key(value="yetAnotherBigDecimalValue")
        BigDecimal anotherBigDecimalValue;
    }

    public static class A {
        @Key
        public Map<String, String> map;
    }

    public static class Feed {
        @Key
        public Collection<Entry> entries;
    }

    public static class Entry {
        @Key
        public String title;
    }
}

