/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.grapher.Alias;
import com.google.inject.grapher.AliasCreator;
import com.google.inject.grapher.BindingEdge;
import com.google.inject.grapher.DefaultEdgeCreator;
import com.google.inject.grapher.DefaultNodeCreator;
import com.google.inject.grapher.DefaultRootKeySetCreator;
import com.google.inject.grapher.DependencyEdge;
import com.google.inject.grapher.Edge;
import com.google.inject.grapher.EdgeCreator;
import com.google.inject.grapher.ImplementationNode;
import com.google.inject.grapher.InjectorGrapher;
import com.google.inject.grapher.InstanceNode;
import com.google.inject.grapher.InterfaceNode;
import com.google.inject.grapher.Node;
import com.google.inject.grapher.NodeCreator;
import com.google.inject.grapher.NodeId;
import com.google.inject.grapher.ProviderAliasCreator;
import com.google.inject.grapher.RootKeySetCreator;
import com.google.inject.grapher.TransitiveDependencyVisitor;
import com.google.inject.internal.guava.collect.;
import com.google.inject.spi.BindingTargetVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectorGrapher
implements InjectorGrapher {
    private final RootKeySetCreator rootKeySetCreator;
    private final AliasCreator aliasCreator;
    private final NodeCreator nodeCreator;
    private final EdgeCreator edgeCreator;

    public AbstractInjectorGrapher() {
        this(new GrapherParameters());
    }

    public AbstractInjectorGrapher(GrapherParameters options) {
        this.rootKeySetCreator = options.getRootKeySetCreator();
        this.aliasCreator = options.getAliasCreator();
        this.nodeCreator = options.getNodeCreator();
        this.edgeCreator = options.getEdgeCreator();
    }

    @Override
    public final void graph(Injector injector) throws IOException {
        this.graph(injector, this.rootKeySetCreator.getRootKeys(injector));
    }

    @Override
    public final void graph(Injector injector, Set<Key<?>> root) throws IOException {
        this.reset();
        Iterable<Binding<?>> bindings = this.getBindings(injector, root);
        Map<NodeId, NodeId> aliases = this.resolveAliases(this.aliasCreator.createAliases(bindings));
        this.createNodes(this.nodeCreator.getNodes(bindings), aliases);
        this.createEdges(this.edgeCreator.getEdges(bindings), aliases);
        this.postProcess();
    }

    protected abstract void reset() throws IOException;

    protected abstract void newInterfaceNode(InterfaceNode var1) throws IOException;

    protected abstract void newImplementationNode(ImplementationNode var1) throws IOException;

    protected abstract void newInstanceNode(InstanceNode var1) throws IOException;

    protected abstract void newDependencyEdge(DependencyEdge var1) throws IOException;

    protected abstract void newBindingEdge(BindingEdge var1) throws IOException;

    protected abstract void postProcess() throws IOException;

    private void createNodes(Iterable<Node> nodes, Map<NodeId, NodeId> aliases) throws IOException {
        for (Node node : nodes) {
            NodeId originalId = node.getId();
            NodeId resolvedId = this.resolveAlias(aliases, originalId);
            node = node.copy(resolvedId);
            if (!resolvedId.equals(originalId)) continue;
            if (node instanceof InterfaceNode) {
                this.newInterfaceNode((InterfaceNode)node);
                continue;
            }
            if (node instanceof ImplementationNode) {
                this.newImplementationNode((ImplementationNode)node);
                continue;
            }
            this.newInstanceNode((InstanceNode)node);
        }
    }

    private void createEdges(Iterable<Edge> edges, Map<NodeId, NodeId> aliases) throws IOException {
        for (Edge edge : edges) {
            if ((edge = edge.copy(this.resolveAlias(aliases, edge.getFromId()), this.resolveAlias(aliases, edge.getToId()))).getFromId().equals(edge.getToId())) continue;
            if (edge instanceof BindingEdge) {
                this.newBindingEdge((BindingEdge)edge);
                continue;
            }
            this.newDependencyEdge((DependencyEdge)edge);
        }
    }

    private NodeId resolveAlias(Map<NodeId, NodeId> aliases, NodeId nodeId) {
        return aliases.containsKey(nodeId) ? aliases.get(nodeId) : nodeId;
    }

    private Map<NodeId, NodeId> resolveAliases(Iterable<Alias> aliases) {
        HashMap resolved = .Maps.newHashMap();
        HashMap inverse = .Maps.newHashMap();
        for (Alias alias : aliases) {
            NodeId from = alias.getFromId();
            NodeId to = alias.getToId();
            if (resolved.containsKey(to)) {
                to = (NodeId)resolved.get(to);
            }
            resolved.put(from, to);
            if (inverse.get(to) == null) {
                inverse.put(to, .Sets.newHashSet());
            }
            ((Set)inverse.get(to)).add(from);
            Set prev = (Set)inverse.get(from);
            if (prev == null) continue;
            for (NodeId id : prev) {
                resolved.remove(id);
                ((Set)inverse.get(from)).remove(id);
                resolved.put(id, to);
                ((Set)inverse.get(to)).add(id);
            }
        }
        return resolved;
    }

    private Iterable<Binding<?>> getBindings(Injector injector, Set<Key<?>> root) {
        HashSet keys = .Sets.newHashSet(root);
        HashSet visitedKeys = .Sets.newHashSet();
        ArrayList bindings = .Lists.newArrayList();
        TransitiveDependencyVisitor keyVisitor = new TransitiveDependencyVisitor();
        while (!keys.isEmpty()) {
            Iterator iterator = keys.iterator();
            Key key = (Key)iterator.next();
            iterator.remove();
            if (visitedKeys.contains(key)) continue;
            Binding binding = injector.getBinding(key);
            bindings.add(binding);
            visitedKeys.add(key);
            keys.addAll((Collection)binding.acceptTargetVisitor((BindingTargetVisitor)keyVisitor));
        }
        return bindings;
    }

    public static final class GrapherParameters {
        private RootKeySetCreator rootKeySetCreator = new DefaultRootKeySetCreator();
        private AliasCreator aliasCreator = new ProviderAliasCreator();
        private NodeCreator nodeCreator = new DefaultNodeCreator();
        private EdgeCreator edgeCreator = new DefaultEdgeCreator();

        public RootKeySetCreator getRootKeySetCreator() {
            return this.rootKeySetCreator;
        }

        public GrapherParameters setRootKeySetCreator(RootKeySetCreator rootKeySetCreator) {
            this.rootKeySetCreator = rootKeySetCreator;
            return this;
        }

        public AliasCreator getAliasCreator() {
            return this.aliasCreator;
        }

        public GrapherParameters setAliasCreator(AliasCreator aliasCreator) {
            this.aliasCreator = aliasCreator;
            return this;
        }

        public NodeCreator getNodeCreator() {
            return this.nodeCreator;
        }

        public GrapherParameters setNodeCreator(NodeCreator nodeCreator) {
            this.nodeCreator = nodeCreator;
            return this;
        }

        public EdgeCreator getEdgeCreator() {
            return this.edgeCreator;
        }

        public GrapherParameters setEdgeCreator(EdgeCreator edgeCreator) {
            this.edgeCreator = edgeCreator;
            return this;
        }
    }
}

