/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.inject.Binding;
import com.google.inject.grapher.ImplementationNode;
import com.google.inject.grapher.InstanceNode;
import com.google.inject.grapher.InterfaceNode;
import com.google.inject.grapher.Node;
import com.google.inject.grapher.NodeCreator;
import com.google.inject.grapher.NodeId;
import com.google.inject.internal.guava.collect.;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultNodeCreator
implements NodeCreator {
    DefaultNodeCreator() {
    }

    @Override
    public Iterable<Node> getNodes(Iterable<Binding<?>> bindings) {
        ArrayList nodes = .Lists.newArrayList();
        NodeVisitor visitor = new NodeVisitor();
        for (Binding<?> binding : bindings) {
            nodes.addAll((Collection)binding.acceptTargetVisitor((BindingTargetVisitor)visitor));
        }
        return nodes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NodeVisitor
    extends DefaultBindingTargetVisitor<Object, Collection<Node>> {
        private NodeVisitor() {
        }

        private InterfaceNode newInterfaceNode(Binding<?> binding) {
            return new InterfaceNode(NodeId.newTypeId(binding.getKey()), binding.getSource());
        }

        private ImplementationNode newImplementationNode(Binding<?> binding, Collection<Member> members) {
            return new ImplementationNode(NodeId.newTypeId(binding.getKey()), binding.getSource(), members);
        }

        private <T extends Binding<?> & HasDependencies> InstanceNode newInstanceNode(T binding, Object instance) {
            ArrayList members = .Lists.newArrayList();
            for (Dependency dependency : ((HasDependencies)binding).getDependencies()) {
                InjectionPoint injectionPoint = dependency.getInjectionPoint();
                if (injectionPoint == null) continue;
                members.add(injectionPoint.getMember());
            }
            return new InstanceNode(NodeId.newInstanceId(binding.getKey()), binding.getSource(), instance, members);
        }

        public Collection<Node> visit(ConstructorBinding<?> binding) {
            ArrayList members = .Lists.newArrayList();
            members.add(binding.getConstructor().getMember());
            for (InjectionPoint injectionPoint : binding.getInjectableMembers()) {
                members.add(injectionPoint.getMember());
            }
            return .ImmutableList.of((Object)this.newImplementationNode((Binding<?>)binding, members));
        }

        public Collection<Node> visit(InstanceBinding<?> binding) {
            return .ImmutableList.of((Object)this.newInterfaceNode((Binding<?>)binding), (Object)this.newInstanceNode((Binding<?> & HasDependencies)binding, binding.getInstance()));
        }

        public Collection<Node> visit(ProviderInstanceBinding<?> binding) {
            return .ImmutableList.of((Object)this.newInterfaceNode((Binding<?>)binding), (Object)this.newInstanceNode((Binding<?> & HasDependencies)binding, binding.getProviderInstance()));
        }

        public Collection<Node> visitOther(Binding<?> binding) {
            return .ImmutableList.of((Object)this.newInterfaceNode(binding));
        }
    }
}

