/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.internal.guava.collect.;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitiveDependencyVisitor
extends DefaultBindingTargetVisitor<Object, Collection<Key<?>>> {
    private Collection<Key<?>> visitHasDependencies(HasDependencies hasDependencies) {
        HashSet dependencies = .Sets.newHashSet();
        for (Dependency dependency : hasDependencies.getDependencies()) {
            dependencies.add(dependency.getKey());
        }
        return dependencies;
    }

    public Collection<Key<?>> visit(ConstructorBinding<?> binding) {
        return this.visitHasDependencies((HasDependencies)binding);
    }

    public Collection<Key<?>> visit(ConvertedConstantBinding<?> binding) {
        return this.visitHasDependencies((HasDependencies)binding);
    }

    public Collection<Key<?>> visit(InstanceBinding<?> binding) {
        return this.visitHasDependencies((HasDependencies)binding);
    }

    public Collection<Key<?>> visit(LinkedKeyBinding<?> binding) {
        return .ImmutableSet.of((Object)binding.getLinkedKey());
    }

    public Collection<Key<?>> visit(ProviderBinding<?> binding) {
        return .ImmutableSet.of((Object)binding.getProvidedKey());
    }

    public Collection<Key<?>> visit(ProviderInstanceBinding<?> binding) {
        return this.visitHasDependencies((HasDependencies)binding);
    }

    public Collection<Key<?>> visit(ProviderKeyBinding<?> binding) {
        return .ImmutableSet.of((Object)binding.getProviderKey());
    }

    public Collection<Key<?>> visitOther(Binding<?> binding) {
        return .ImmutableSet.of();
    }
}

