/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.grapher.AbstractInjectorGrapher;
import com.google.inject.grapher.BindingEdge;
import com.google.inject.grapher.DependencyEdge;
import com.google.inject.grapher.ImplementationNode;
import com.google.inject.grapher.InstanceNode;
import com.google.inject.grapher.InterfaceNode;
import com.google.inject.grapher.NameFactory;
import com.google.inject.grapher.NodeId;
import com.google.inject.grapher.graphviz.ArrowType;
import com.google.inject.grapher.graphviz.CompassPoint;
import com.google.inject.grapher.graphviz.EdgeStyle;
import com.google.inject.grapher.graphviz.Graphviz;
import com.google.inject.grapher.graphviz.GraphvizEdge;
import com.google.inject.grapher.graphviz.GraphvizNode;
import com.google.inject.grapher.graphviz.NodeStyle;
import com.google.inject.grapher.graphviz.PortIdFactory;
import com.google.inject.internal.guava.base.;
import com.google.inject.internal.guava.collect.;
import com.google.inject.spi.InjectionPoint;
import java.io.PrintWriter;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizGrapher
extends AbstractInjectorGrapher {
    private final Map<NodeId, GraphvizNode> nodes = .Maps.newHashMap();
    private final List<GraphvizEdge> edges = .Lists.newArrayList();
    private final NameFactory nameFactory;
    private final PortIdFactory portIdFactory;
    private PrintWriter out;
    private String rankdir = "TB";

    @Inject
    GraphvizGrapher(@Graphviz NameFactory nameFactory, @Graphviz PortIdFactory portIdFactory) {
        this.nameFactory = nameFactory;
        this.portIdFactory = portIdFactory;
    }

    @Override
    protected void reset() {
        this.nodes.clear();
        this.edges.clear();
    }

    public void setOut(PrintWriter out) {
        this.out = out;
    }

    public void setRankdir(String rankdir) {
        this.rankdir = rankdir;
    }

    @Override
    protected void postProcess() {
        this.start();
        for (GraphvizNode node : this.nodes.values()) {
            this.renderNode(node);
        }
        for (GraphvizEdge edge : this.edges) {
            this.renderEdge(edge);
        }
        this.finish();
        this.out.flush();
    }

    protected Map<String, String> getGraphAttributes() {
        HashMap attrs = .Maps.newHashMap();
        attrs.put("rankdir", this.rankdir);
        return attrs;
    }

    protected void start() {
        this.out.println("digraph injector {");
        Map<String, String> attrs = this.getGraphAttributes();
        this.out.println("graph " + this.getAttrString(attrs) + ";");
    }

    protected void finish() {
        this.out.println("}");
    }

    protected void renderNode(GraphvizNode node) {
        Map<String, String> attrs = this.getNodeAttributes(node);
        this.out.println(node.getIdentifier() + " " + this.getAttrString(attrs));
    }

    protected Map<String, String> getNodeAttributes(GraphvizNode node) {
        HashMap attrs = .Maps.newHashMap();
        attrs.put("label", this.getNodeLabel(node));
        attrs.put("margin", "0.02,0");
        attrs.put("shape", node.getShape().toString());
        attrs.put("style", node.getStyle().toString());
        return attrs;
    }

    protected String getNodeLabel(GraphvizNode node) {
        String cellborder = node.getStyle() == NodeStyle.INVISIBLE ? "1" : "0";
        StringBuilder html = new StringBuilder();
        html.append("<");
        html.append("<table cellspacing=\"0\" cellpadding=\"5\" cellborder=\"");
        html.append(cellborder).append("\" border=\"0\">");
        html.append("<tr>").append("<td align=\"left\" port=\"header\" ");
        html.append("bgcolor=\"" + node.getHeaderBackgroundColor() + "\">");
        String subtitle = .Joiner.on((String)"<br align=\"left\"/>").join(node.getSubtitles());
        if (subtitle.length() != 0) {
            html.append("<font color=\"").append(node.getHeaderTextColor());
            html.append("\" point-size=\"10\">");
            html.append(subtitle).append("<br align=\"left\"/>").append("</font>");
        }
        html.append("<font color=\"" + node.getHeaderTextColor() + "\">");
        html.append(this.htmlEscape(node.getTitle())).append("<br align=\"left\"/>");
        html.append("</font>").append("</td>").append("</tr>");
        for (Map.Entry<String, String> field : node.getFields().entrySet()) {
            html.append("<tr>");
            html.append("<td align=\"left\" port=\"").append(this.htmlEscape(field.getKey())).append("\">");
            html.append(this.htmlEscape(field.getValue()));
            html.append("</td>").append("</tr>");
        }
        html.append("</table>");
        html.append(">");
        return html.toString();
    }

    protected void renderEdge(GraphvizEdge edge) {
        Map<String, String> attrs = this.getEdgeAttributes(edge);
        String tailId = this.getEdgeEndPoint(this.nodes.get(edge.getTailNodeId()).getIdentifier(), edge.getTailPortId(), edge.getTailCompassPoint());
        String headId = this.getEdgeEndPoint(this.nodes.get(edge.getHeadNodeId()).getIdentifier(), edge.getHeadPortId(), edge.getHeadCompassPoint());
        this.out.println(tailId + " -> " + headId + " " + this.getAttrString(attrs));
    }

    protected Map<String, String> getEdgeAttributes(GraphvizEdge edge) {
        HashMap attrs = .Maps.newHashMap();
        attrs.put("arrowhead", this.getArrowString(edge.getArrowHead()));
        attrs.put("arrowtail", this.getArrowString(edge.getArrowTail()));
        attrs.put("style", edge.getStyle().toString());
        return attrs;
    }

    private String getAttrString(Map<String, String> attrs) {
        ArrayList attrList = .Lists.newArrayList();
        for (Map.Entry<String, String> attr : attrs.entrySet()) {
            String value = attr.getValue();
            if (value == null) continue;
            attrList.add(attr.getKey() + "=" + value);
        }
        return "[" + .Joiner.on((String)", ").join((Iterable)attrList) + "]";
    }

    protected String getArrowString(List<ArrowType> arrows) {
        return .Joiner.on((String)"").join(arrows);
    }

    protected String getEdgeEndPoint(String nodeId, String portId, CompassPoint compassPoint) {
        ArrayList portStrings = .Lists.newArrayList((Object[])new String[]{nodeId});
        if (portId != null) {
            portStrings.add(portId);
        }
        if (compassPoint != null) {
            portStrings.add(compassPoint.toString());
        }
        return .Joiner.on((String)":").join((Iterable)portStrings);
    }

    protected String htmlEscape(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    protected List<String> htmlEscape(List<String> elements) {
        ArrayList escaped = .Lists.newArrayList();
        for (String element : elements) {
            escaped.add(this.htmlEscape(element));
        }
        return escaped;
    }

    @Override
    protected void newInterfaceNode(InterfaceNode node) {
        NodeId nodeId = node.getId();
        GraphvizNode gnode = new GraphvizNode(nodeId);
        gnode.setStyle(NodeStyle.DASHED);
        Key<?> key = nodeId.getKey();
        gnode.setTitle(this.nameFactory.getClassName(key));
        gnode.addSubtitle(0, this.nameFactory.getAnnotationName(key));
        this.addNode(gnode);
    }

    @Override
    protected void newImplementationNode(ImplementationNode node) {
        NodeId nodeId = node.getId();
        GraphvizNode gnode = new GraphvizNode(nodeId);
        gnode.setStyle(NodeStyle.SOLID);
        gnode.setHeaderBackgroundColor("#000000");
        gnode.setHeaderTextColor("#ffffff");
        gnode.setTitle(this.nameFactory.getClassName(nodeId.getKey()));
        for (Member member : node.getMembers()) {
            gnode.addField(this.portIdFactory.getPortId(member), this.nameFactory.getMemberName(member));
        }
        this.addNode(gnode);
    }

    @Override
    protected void newInstanceNode(InstanceNode node) {
        NodeId nodeId = node.getId();
        GraphvizNode gnode = new GraphvizNode(nodeId);
        gnode.setStyle(NodeStyle.SOLID);
        gnode.setHeaderBackgroundColor("#000000");
        gnode.setHeaderTextColor("#ffffff");
        gnode.setTitle(this.nameFactory.getClassName(nodeId.getKey()));
        gnode.addSubtitle(0, this.nameFactory.getSourceName(node.getSource()));
        gnode.setHeaderBackgroundColor("#aaaaaa");
        gnode.setHeaderTextColor("#ffffff");
        gnode.setTitle(this.nameFactory.getInstanceName(node.getInstance()));
        for (Member member : node.getMembers()) {
            gnode.addField(this.portIdFactory.getPortId(member), this.nameFactory.getMemberName(member));
        }
        this.addNode(gnode);
    }

    @Override
    protected void newDependencyEdge(DependencyEdge edge) {
        GraphvizEdge gedge = new GraphvizEdge(edge.getFromId(), edge.getToId());
        InjectionPoint fromPoint = edge.getInjectionPoint();
        if (fromPoint == null) {
            gedge.setTailPortId("header");
        } else {
            gedge.setTailPortId(this.portIdFactory.getPortId(fromPoint.getMember()));
        }
        gedge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL)));
        gedge.setTailCompassPoint(CompassPoint.EAST);
        this.edges.add(gedge);
    }

    @Override
    protected void newBindingEdge(BindingEdge edge) {
        GraphvizEdge gedge = new GraphvizEdge(edge.getFromId(), edge.getToId());
        gedge.setStyle(EdgeStyle.DASHED);
        switch (edge.getType()) {
            case NORMAL: {
                gedge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL_OPEN)));
                break;
            }
            case PROVIDER: {
                gedge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL_OPEN), (Object)((Object)ArrowType.NORMAL_OPEN)));
                break;
            }
            case CONVERTED_CONSTANT: {
                gedge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL_OPEN), (Object)((Object)ArrowType.DOT_OPEN)));
            }
        }
        this.edges.add(gedge);
    }

    private void addNode(GraphvizNode node) {
        node.setIdentifier("x" + this.nodes.size());
        this.nodes.put(node.getNodeId(), node);
    }
}

