/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.tools.jmx;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.tools.jmx.ManagedBinding;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Manager {
    public static void manage(String domain, Injector injector) {
        Manager.manage(ManagementFactory.getPlatformMBeanServer(), domain, injector);
    }

    public static void manage(MBeanServer server, String domain, Injector injector) {
        for (Binding binding : injector.getBindings().values()) {
            StringBuilder name = new StringBuilder();
            name.append(domain).append(":");
            Key key = binding.getKey();
            name.append("type=").append(Manager.quote(key.getTypeLiteral().toString()));
            Annotation annotation = key.getAnnotation();
            if (annotation != null) {
                name.append(",annotation=").append(Manager.quote(annotation.toString()));
            } else {
                Class annotationType = key.getAnnotationType();
                if (annotationType != null) {
                    String string = String.valueOf(annotationType.getName());
                    name.append(",annotation=").append(Manager.quote(string.length() != 0 ? "@".concat(string) : new String("@")));
                }
            }
            try {
                server.registerMBean(new ManagedBinding(binding), new ObjectName(name.toString()));
            }
            catch (MalformedObjectNameException e) {
                String string = String.valueOf(String.valueOf(name));
                throw new RuntimeException(new StringBuilder(17 + string.length()).append("Bad object name: ").append(string).toString(), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static String quote(String value) {
        return ObjectName.quote(value).replace(',', ';');
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            String string = String.valueOf(String.valueOf(Manager.class.getName()));
            System.err.println(new StringBuilder(63 + string.length()).append("Usage: java -Dcom.sun.management.jmxremote ").append(string).append(" [module class name]").toString());
            System.err.println("Then run 'jconsole' to connect.");
            System.exit(1);
        }
        Module module = (Module)Class.forName(args[0]).newInstance();
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Manager.manage(args[0], injector);
        System.out.println("Press Ctrl+C to exit...");
        Thread.sleep(Long.MAX_VALUE);
    }
}

