/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.ClassMapKey;
import com.google.inject.multibindings.MapKey;
import com.google.inject.multibindings.MultibindingsScanner;
import com.google.inject.multibindings.ProvidesIntoMap;
import com.google.inject.multibindings.ProvidesIntoOptional;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.multibindings.StringMapKey;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class ProvidesIntoTest
extends TestCase {
    @WrappedKey(number=1)
    private static Object wrappedKey1Holder;
    @WrappedKey(number=2)
    private static Object wrappedKey2Holder;
    @ArrayWrappedKey(number={1, 2})
    private static Object arrayWrappedKeyHolder12;
    @ArrayWrappedKey(number={3, 4})
    private static Object arrayWrappedKeyHolder34;

    public void testAnnotation() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoSet
            @Named(value="foo")
            String setFoo() {
                return "foo";
            }

            @ProvidesIntoSet
            @Named(value="foo")
            String setFoo2() {
                return "foo2";
            }

            @ProvidesIntoSet
            @Named(value="bar")
            String setBar() {
                return "bar";
            }

            @ProvidesIntoSet
            @Named(value="bar")
            String setBar2() {
                return "bar2";
            }

            @ProvidesIntoSet
            String setNoAnnotation() {
                return "na";
            }

            @ProvidesIntoSet
            String setNoAnnotation2() {
                return "na2";
            }

            @ProvidesIntoMap
            @StringMapKey(value="fooKey")
            @Named(value="foo")
            String mapFoo() {
                return "foo";
            }

            @ProvidesIntoMap
            @StringMapKey(value="foo2Key")
            @Named(value="foo")
            String mapFoo2() {
                return "foo2";
            }

            @ProvidesIntoMap
            @ClassMapKey(value=String.class)
            @Named(value="bar")
            String mapBar() {
                return "bar";
            }

            @ProvidesIntoMap
            @ClassMapKey(value=Number.class)
            @Named(value="bar")
            String mapBar2() {
                return "bar2";
            }

            @ProvidesIntoMap
            @TestEnumKey(value=TestEnum.A)
            String mapNoAnnotation() {
                return "na";
            }

            @ProvidesIntoMap
            @TestEnumKey(value=TestEnum.B)
            String mapNoAnnotation2() {
                return "na2";
            }

            @ProvidesIntoMap
            @WrappedKey(number=1)
            Number wrapped1() {
                return 11;
            }

            @ProvidesIntoMap
            @WrappedKey(number=2)
            Number wrapped2() {
                return 22;
            }

            @ProvidesIntoOptional(value=ProvidesIntoOptional.Type.DEFAULT)
            @Named(value="foo")
            String optionalDefaultFoo() {
                return "foo";
            }

            @ProvidesIntoOptional(value=ProvidesIntoOptional.Type.ACTUAL)
            @Named(value="foo")
            String optionalActualFoo() {
                return "foo2";
            }

            @ProvidesIntoOptional(value=ProvidesIntoOptional.Type.DEFAULT)
            @Named(value="bar")
            String optionalDefaultBar() {
                return "bar";
            }

            @ProvidesIntoOptional(value=ProvidesIntoOptional.Type.ACTUAL)
            String optionalActualBar() {
                return "na2";
            }
        }});
        Set fooSet = (Set)injector.getInstance((Key)new Key<Set<String>>((Annotation)Names.named((String)"foo")){});
        ProvidesIntoTest.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2"), (Object)fooSet);
        Set barSet = (Set)injector.getInstance((Key)new Key<Set<String>>((Annotation)Names.named((String)"bar")){});
        ProvidesIntoTest.assertEquals((Object)ImmutableSet.of((Object)"bar", (Object)"bar2"), (Object)barSet);
        Set noAnnotationSet = (Set)injector.getInstance((Key)new Key<Set<String>>(){});
        ProvidesIntoTest.assertEquals((Object)ImmutableSet.of((Object)"na", (Object)"na2"), (Object)noAnnotationSet);
        Map fooMap = (Map)injector.getInstance((Key)new Key<Map<String, String>>((Annotation)Names.named((String)"foo")){});
        ProvidesIntoTest.assertEquals((Object)ImmutableMap.of((Object)"fooKey", (Object)"foo", (Object)"foo2Key", (Object)"foo2"), (Object)fooMap);
        Map barMap = (Map)injector.getInstance(new Key<Map<Class<?>, String>>((Annotation)Names.named((String)"bar")){});
        ProvidesIntoTest.assertEquals((Object)ImmutableMap.of(String.class, (Object)"bar", Number.class, (Object)"bar2"), (Object)barMap);
        Map noAnnotationMap = (Map)injector.getInstance((Key)new Key<Map<TestEnum, String>>(){});
        ProvidesIntoTest.assertEquals((Object)ImmutableMap.of((Object)((Object)TestEnum.A), (Object)"na", (Object)((Object)TestEnum.B), (Object)"na2"), (Object)noAnnotationMap);
        Map wrappedMap = (Map)injector.getInstance((Key)new Key<Map<WrappedKey, Number>>(){});
        ProvidesIntoTest.assertEquals((Object)ImmutableMap.of((Object)this.wrappedKeyFor(1), (Object)11, (Object)this.wrappedKeyFor(2), (Object)22), (Object)wrappedMap);
        Optional fooOptional = (Optional)injector.getInstance((Key)new Key<Optional<String>>((Annotation)Names.named((String)"foo")){});
        ProvidesIntoTest.assertEquals((String)"foo2", (String)((String)fooOptional.get()));
        Optional barOptional = (Optional)injector.getInstance((Key)new Key<Optional<String>>((Annotation)Names.named((String)"bar")){});
        ProvidesIntoTest.assertEquals((String)"bar", (String)((String)barOptional.get()));
        Optional noAnnotationOptional = (Optional)injector.getInstance((Key)new Key<Optional<String>>(){});
        ProvidesIntoTest.assertEquals((String)"na2", (String)((String)noAnnotationOptional.get()));
    }

    WrappedKey wrappedKeyFor(int number) throws Exception {
        Field field;
        switch (number) {
            case 1: {
                field = ProvidesIntoTest.class.getDeclaredField("wrappedKey1Holder");
                break;
            }
            case 2: {
                field = ProvidesIntoTest.class.getDeclaredField("wrappedKey2Holder");
                break;
            }
            default: {
                throw new IllegalArgumentException("only 1 or 2 supported");
            }
        }
        return field.getAnnotation(WrappedKey.class);
    }

    public void testDoubleScannerIsIgnored() {
        Injector injector = Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), MultibindingsScanner.asModule(), new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoSet
            String provideFoo() {
                return "foo";
            }
        }});
        ProvidesIntoTest.assertEquals((Object)ImmutableSet.of((Object)"foo"), (Object)injector.getInstance((Key)new Key<Set<String>>(){}));
    }

    public void testArrayKeys_unwrapValuesTrue() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoMap
            @ArrayUnwrappedKey(value={1, 2})
            String provideFoo() {
                return "foo";
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), m});
            ProvidesIntoTest.fail();
        }
        catch (CreationException ce) {
            ProvidesIntoTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains((String)ce.getMessage(), (String[])new String[]{"Array types are not allowed in a MapKey with unwrapValue=true: " + ArrayUnwrappedKey.class.getName(), "at " + m.getClass().getName() + ".provideFoo("});
        }
    }

    ArrayWrappedKey arrayWrappedKeyFor(int number) throws Exception {
        Field field;
        switch (number) {
            case 12: {
                field = ProvidesIntoTest.class.getDeclaredField("arrayWrappedKeyHolder12");
                break;
            }
            case 34: {
                field = ProvidesIntoTest.class.getDeclaredField("arrayWrappedKeyHolder34");
                break;
            }
            default: {
                throw new IllegalArgumentException("only 1 or 2 supported");
            }
        }
        return field.getAnnotation(ArrayWrappedKey.class);
    }

    public void testArrayKeys_unwrapValuesFalse() throws Exception {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoMap
            @ArrayWrappedKey(number={1, 2})
            String provideFoo() {
                return "foo";
            }

            @ProvidesIntoMap
            @ArrayWrappedKey(number={3, 4})
            String provideBar() {
                return "bar";
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), m});
        Map map = (Map)injector.getInstance((Key)new Key<Map<ArrayWrappedKey, String>>(){});
        ArrayWrappedKey key12 = this.arrayWrappedKeyFor(12);
        ArrayWrappedKey key34 = this.arrayWrappedKeyFor(34);
        ProvidesIntoTest.assertEquals((String)"foo", (String)((String)map.get(key12)));
        ProvidesIntoTest.assertEquals((String)"bar", (String)((String)map.get(key34)));
        ProvidesIntoTest.assertEquals((int)2, (int)map.size());
    }

    public void testProvidesIntoSetWithMapKey() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoSet
            @TestEnumKey(value=TestEnum.A)
            String provideFoo() {
                return "foo";
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), m});
            ProvidesIntoTest.fail();
        }
        catch (CreationException ce) {
            ProvidesIntoTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains((String)ce.getMessage(), (String[])new String[]{"Found a MapKey annotation on non map binding at " + m.getClass().getName() + ".provideFoo"});
        }
    }

    public void testProvidesIntoOptionalWithMapKey() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoOptional(value=ProvidesIntoOptional.Type.ACTUAL)
            @TestEnumKey(value=TestEnum.A)
            String provideFoo() {
                return "foo";
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), m});
            ProvidesIntoTest.fail();
        }
        catch (CreationException ce) {
            ProvidesIntoTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains((String)ce.getMessage(), (String[])new String[]{"Found a MapKey annotation on non map binding at " + m.getClass().getName() + ".provideFoo"});
        }
    }

    public void testProvidesIntoMapWithoutMapKey() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoMap
            String provideFoo() {
                return "foo";
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), m});
            ProvidesIntoTest.fail();
        }
        catch (CreationException ce) {
            ProvidesIntoTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains((String)ce.getMessage(), (String[])new String[]{"No MapKey found for map binding at " + m.getClass().getName() + ".provideFoo"});
        }
    }

    public void testMoreThanOneMapKeyAnnotation() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoMap
            @TestEnumKey(value=TestEnum.A)
            @TestEnumKey2(value=TestEnum.B)
            String provideFoo() {
                return "foo";
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), m});
            ProvidesIntoTest.fail();
        }
        catch (CreationException ce) {
            ProvidesIntoTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains((String)ce.getMessage(), (String[])new String[]{"Found more than one MapKey annotations on " + m.getClass().getName() + ".provideFoo"});
        }
    }

    public void testMapKeyMissingValueMethod() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
            }

            @ProvidesIntoMap
            @MissingValueMethod
            String provideFoo() {
                return "foo";
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{MultibindingsScanner.asModule(), m});
            ProvidesIntoTest.fail();
        }
        catch (CreationException ce) {
            ProvidesIntoTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains((String)ce.getMessage(), (String[])new String[]{"No 'value' method in MapKey with unwrapValue=true: " + MissingValueMethod.class.getName()});
        }
    }

    @MapKey(unwrapValue=true)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface MissingValueMethod {
    }

    @MapKey(unwrapValue=true)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestEnumKey2 {
        public TestEnum value();
    }

    @MapKey(unwrapValue=false)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ArrayWrappedKey {
        public int[] number();
    }

    @MapKey(unwrapValue=true)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ArrayUnwrappedKey {
        public int[] value();
    }

    @MapKey(unwrapValue=false)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface WrappedKey {
        public int number();
    }

    @MapKey(unwrapValue=true)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestEnumKey {
        public TestEnum value();
    }

    static enum TestEnum {
        A,
        B;

    }
}

