/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.inject.multibindings.Element;
import com.google.inject.multibindings.RealElement;
import junit.framework.TestCase;

public class RealElementTest
extends TestCase {
    private Element systemElement;
    private RealElement realElement;

    protected void setUp() throws Exception {
        this.systemElement = Holder.class.getAnnotation(Element.class);
        this.realElement = new RealElement("b", Element.Type.MULTIBINDER, "a", 1);
    }

    public void testEquals() {
        RealElementTest.assertEquals((Object)this.systemElement, (Object)this.realElement);
        RealElementTest.assertEquals((Object)this.realElement, (Object)this.systemElement);
    }

    public void testHashCode() {
        RealElementTest.assertEquals((int)this.systemElement.hashCode(), (int)this.realElement.hashCode());
    }

    public void testProperties() {
        RealElementTest.assertEquals((String)"a", (String)this.realElement.keyType());
        RealElementTest.assertEquals((String)"b", (String)this.realElement.setName());
        RealElementTest.assertEquals((Object)Element.Type.MULTIBINDER, (Object)this.realElement.type());
        RealElementTest.assertEquals((int)1, (int)this.realElement.uniqueId());
    }

    @Element(keyType="a", setName="b", type=Element.Type.MULTIBINDER, uniqueId=1)
    static class Holder {
        Holder() {
        }
    }
}

