/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Indexer;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.OptionalBinderBinding;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProviderLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

public class SpiUtils {
    private static final boolean HAS_JAVA_OPTIONAL;

    static <T> void assertMapVisitor(Key<T> mapKey, TypeLiteral<?> keyType, TypeLiteral<?> valueType, Iterable<? extends Module> modules, VisitType visitType, boolean allowDuplicates, int expectedMapBindings, MapResult ... results) {
        if (visitType == null) {
            Assert.fail((String)"must test something");
        }
        if (visitType == VisitType.BOTH || visitType == VisitType.INJECTOR) {
            SpiUtils.mapInjectorTest(mapKey, keyType, valueType, modules, allowDuplicates, expectedMapBindings, results);
        }
        if (visitType == VisitType.BOTH || visitType == VisitType.MODULE) {
            SpiUtils.mapModuleTest(mapKey, keyType, valueType, modules, allowDuplicates, expectedMapBindings, results);
        }
    }

    private static <T> void mapInjectorTest(Key<T> mapKey, TypeLiteral<?> keyType, TypeLiteral<?> valueType, Iterable<? extends Module> modules, boolean allowDuplicates, int expectedMapBindings, MapResult ... results) {
        Injector injector = Guice.createInjector(modules);
        Visitor visitor = new Visitor();
        Binding mapBinding = injector.getBinding(mapKey);
        MapBinderBinding mapbinder = (MapBinderBinding)mapBinding.acceptTargetVisitor(visitor);
        Assert.assertNotNull((Object)mapbinder);
        Assert.assertEquals(keyType, (Object)mapbinder.getKeyTypeLiteral());
        Assert.assertEquals(valueType, (Object)mapbinder.getValueTypeLiteral());
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapbinder.permitsDuplicates());
        ArrayList entries = Lists.newArrayList((Iterable)mapbinder.getEntries());
        ArrayList mapResults = Lists.newArrayList((Object[])results);
        Assert.assertEquals((String)("wrong entries, expected: " + mapResults + ", but was: " + entries), (int)mapResults.size(), (int)entries.size());
        for (MapResult result : mapResults) {
            Map.Entry found = null;
            for (Map.Entry entry : entries) {
                Object key = entry.getKey();
                Binding value = (Binding)entry.getValue();
                if (!key.equals(result.k) || !SpiUtils.matches(value, result.v)) continue;
                found = entry;
                break;
            }
            if (found == null) {
                Assert.fail((String)("Could not find entry: " + result + " in remaining entries: " + entries));
                continue;
            }
            Assert.assertTrue((String)("mapBinder doesn't contain: " + found.getValue()), (boolean)mapbinder.containsElement((Element)found.getValue()));
            entries.remove(found);
        }
        if (!entries.isEmpty()) {
            Assert.fail((String)("Found all entries of: " + mapResults + ", but more were left over: " + entries));
        }
        Key mapOfJavaxProvider = mapKey.ofType(MapBinder.mapOfJavaxProviderOf(keyType, valueType));
        Key mapOfProvider = mapKey.ofType(MapBinder.mapOfProviderOf(keyType, valueType));
        Key mapOfSetOfProvider = mapKey.ofType(MapBinder.mapOfSetOfProviderOf(keyType, valueType));
        Key mapOfSetOfJavaxProvider = mapKey.ofType(MapBinder.mapOfSetOfJavaxProviderOf(keyType, valueType));
        Key mapOfCollectionOfProvider = mapKey.ofType(MapBinder.mapOfCollectionOfProviderOf(keyType, valueType));
        Key mapOfCollectionOfJavaxProvider = mapKey.ofType(MapBinder.mapOfCollectionOfJavaxProviderOf(keyType, valueType));
        Key mapOfSet = mapKey.ofType(MapBinder.mapOf(keyType, (TypeLiteral)Multibinder.setOf(valueType)));
        Key setOfEntry = mapKey.ofType(Multibinder.setOf((TypeLiteral)MapBinder.entryOfProviderOf(keyType, valueType)));
        Key setOfJavaxEntry = mapKey.ofType(Multibinder.setOf((TypeLiteral)MapBinder.entryOfJavaxProviderOf(keyType, valueType)));
        Key collectionOfProvidersOfEntryOfProvider = mapKey.ofType(Multibinder.collectionOfProvidersOf((TypeLiteral)MapBinder.entryOfProviderOf(keyType, valueType)));
        Key collectionOfJavaxProvidersOfEntryOfProvider = mapKey.ofType(Multibinder.collectionOfJavaxProvidersOf((TypeLiteral)MapBinder.entryOfProviderOf(keyType, valueType)));
        boolean entrySetMatch = false;
        boolean javaxEntrySetMatch = false;
        boolean mapJavaxProviderMatch = false;
        boolean mapProviderMatch = false;
        boolean mapSetMatch = false;
        boolean mapSetProviderMatch = false;
        boolean mapSetJavaxProviderMatch = false;
        boolean mapCollectionProviderMatch = false;
        boolean mapCollectionJavaxProviderMatch = false;
        boolean collectionOfProvidersOfEntryOfProviderMatch = false;
        boolean collectionOfJavaxProvidersOfEntryOfProviderMatch = false;
        ArrayList otherMapBindings = Lists.newArrayList();
        ArrayList otherMatches = Lists.newArrayList();
        SetMultimap indexedEntries = MultimapBuilder.hashKeys().hashSetValues().build();
        Indexer indexer = new Indexer(injector);
        int duplicates = 0;
        for (Binding b : injector.getAllBindings().values()) {
            MapBinder.RealMapBinder.ProviderMapEntry pme;
            Binding valueBinding;
            ProviderInstanceBinding pib;
            boolean contains = mapbinder.containsElement((Element)b);
            Object visited = b.acceptTargetVisitor(visitor);
            if (visited instanceof MapBinderBinding) {
                if (visited.equals(mapbinder)) {
                    Assert.assertTrue((boolean)contains);
                    continue;
                }
                otherMapBindings.add(visited);
                continue;
            }
            if (b.getKey().equals((Object)mapOfProvider)) {
                Assert.assertTrue((boolean)contains);
                mapProviderMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)mapOfJavaxProvider)) {
                Assert.assertTrue((boolean)contains);
                mapJavaxProviderMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)mapOfSet)) {
                Assert.assertTrue((boolean)contains);
                mapSetMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)mapOfSetOfProvider)) {
                Assert.assertTrue((boolean)contains);
                mapSetProviderMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)mapOfSetOfJavaxProvider)) {
                Assert.assertTrue((boolean)contains);
                mapSetJavaxProviderMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)mapOfCollectionOfProvider)) {
                Assert.assertTrue((boolean)contains);
                mapCollectionProviderMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)mapOfCollectionOfJavaxProvider)) {
                Assert.assertTrue((boolean)contains);
                mapCollectionJavaxProviderMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)setOfEntry)) {
                Assert.assertTrue((boolean)contains);
                entrySetMatch = true;
                Assert.assertTrue((boolean)(b.acceptTargetVisitor(visitor) instanceof MultibinderBinding));
                continue;
            }
            if (b.getKey().equals((Object)setOfJavaxEntry)) {
                Assert.assertTrue((boolean)contains);
                javaxEntrySetMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)collectionOfProvidersOfEntryOfProvider)) {
                Assert.assertTrue((boolean)contains);
                collectionOfProvidersOfEntryOfProviderMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)collectionOfJavaxProvidersOfEntryOfProvider)) {
                Assert.assertTrue((boolean)contains);
                collectionOfJavaxProvidersOfEntryOfProviderMatch = true;
                continue;
            }
            if (!contains) continue;
            if (b instanceof ProviderInstanceBinding && (pib = (ProviderInstanceBinding)b).getUserSuppliedProvider() instanceof MapBinder.RealMapBinder.ProviderMapEntry && indexer.isIndexable(valueBinding = injector.getBinding((pme = (MapBinder.RealMapBinder.ProviderMapEntry)((Provider)pib.getUserSuppliedProvider())).getValueKey())) && !indexedEntries.put(pme.getKey(), valueBinding.acceptTargetVisitor((BindingTargetVisitor)indexer))) {
                ++duplicates;
            }
            otherMatches.add(b);
        }
        int sizeOfOther = otherMatches.size();
        if (allowDuplicates) {
            --sizeOfOther;
        }
        int expectedSize = 2 * (mapResults.size() + duplicates);
        Assert.assertEquals((String)("Incorrect other matches:\n\t" + Joiner.on((String)"\n\t").join((Iterable)otherMatches)), (int)expectedSize, (int)sizeOfOther);
        Assert.assertTrue((boolean)entrySetMatch);
        Assert.assertTrue((boolean)javaxEntrySetMatch);
        Assert.assertTrue((boolean)mapProviderMatch);
        Assert.assertTrue((boolean)mapJavaxProviderMatch);
        Assert.assertTrue((boolean)collectionOfProvidersOfEntryOfProviderMatch);
        Assert.assertTrue((boolean)collectionOfJavaxProvidersOfEntryOfProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapSetMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapSetProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapSetJavaxProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapCollectionJavaxProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapCollectionProviderMatch);
        Assert.assertEquals((String)("other MapBindings found: " + otherMapBindings), (int)expectedMapBindings, (int)otherMapBindings.size());
    }

    private static <T> void mapModuleTest(Key<T> mapKey, TypeLiteral<?> keyType, TypeLiteral<?> valueType, Iterable<? extends Module> modules, boolean allowDuplicates, int expectedMapBindings, MapResult ... results) {
        ImmutableSet elements = ImmutableSet.copyOf((Collection)Elements.getElements(modules));
        Visitor visitor = new Visitor();
        MapBinderBinding mapbinder = null;
        HashMap keyMap = Maps.newHashMap();
        for (Element element : elements) {
            if (!(element instanceof Binding)) continue;
            Binding binding = (Binding)element;
            keyMap.put(binding.getKey(), binding);
            if (!binding.getKey().equals(mapKey)) continue;
            mapbinder = (MapBinderBinding)binding.acceptTargetVisitor(visitor);
        }
        Assert.assertNotNull(mapbinder);
        Assert.assertEquals(keyType, (Object)mapbinder.getKeyTypeLiteral());
        Assert.assertEquals(valueType, (Object)mapbinder.getValueTypeLiteral());
        ArrayList mapResults = Lists.newArrayList((Object[])results);
        Key mapOfProvider = mapKey.ofType(MapBinder.mapOfProviderOf(keyType, valueType));
        Key mapOfJavaxProvider = mapKey.ofType(MapBinder.mapOfJavaxProviderOf(keyType, valueType));
        Key mapOfSetOfProvider = mapKey.ofType(MapBinder.mapOfSetOfProviderOf(keyType, valueType));
        Key mapOfSetOfJavaxProvider = mapKey.ofType(MapBinder.mapOfSetOfJavaxProviderOf(keyType, valueType));
        Key mapOfCollectionOfProvider = mapKey.ofType(MapBinder.mapOfCollectionOfProviderOf(keyType, valueType));
        Key mapOfCollectionOfJavaxProvider = mapKey.ofType(MapBinder.mapOfCollectionOfJavaxProviderOf(keyType, valueType));
        Key mapOfSet = mapKey.ofType(MapBinder.mapOf(keyType, (TypeLiteral)Multibinder.setOf(valueType)));
        Key setOfEntry = mapKey.ofType(Multibinder.setOf((TypeLiteral)MapBinder.entryOfProviderOf(keyType, valueType)));
        Key setOfJavaxEntry = mapKey.ofType(Multibinder.setOf((TypeLiteral)MapBinder.entryOfJavaxProviderOf(keyType, valueType)));
        Key collectionOfProvidersOfEntryOfProvider = mapKey.ofType(Multibinder.collectionOfProvidersOf((TypeLiteral)MapBinder.entryOfProviderOf(keyType, valueType)));
        Key collectionOfJavaxProvidersOfEntryOfProvider = mapKey.ofType(Multibinder.collectionOfJavaxProvidersOf((TypeLiteral)MapBinder.entryOfProviderOf(keyType, valueType)));
        boolean entrySetMatch = false;
        boolean entrySetJavaxMatch = false;
        boolean mapProviderMatch = false;
        boolean mapJavaxProviderMatch = false;
        boolean mapSetMatch = false;
        boolean mapSetProviderMatch = false;
        boolean mapSetJavaxProviderMatch = false;
        boolean mapCollectionProviderMatch = false;
        boolean mapCollectionJavaxProviderMatch = false;
        boolean collectionOfProvidersOfEntryOfProviderMatch = false;
        boolean collectionOfJavaxProvidersOfEntryOfProviderMatch = false;
        ArrayList otherMapBindings = Lists.newArrayList();
        ArrayList otherMatches = Lists.newArrayList();
        ArrayList otherElements = Lists.newArrayList();
        Indexer indexer = new Indexer(null);
        SetMultimap indexedEntries = MultimapBuilder.hashKeys().hashSetValues().build();
        int duplicates = 0;
        for (Element element : elements) {
            boolean contains = mapbinder.containsElement(element);
            if (!contains) {
                otherElements.add(element);
            }
            boolean matched = false;
            Key key = null;
            Binding b = null;
            if (element instanceof Binding) {
                MapBinder.RealMapBinder.ProviderMapEntry pme;
                Binding valueBinding;
                ProviderInstanceBinding pb;
                b = (Binding)element;
                if (b instanceof ProviderInstanceBinding && (pb = (ProviderInstanceBinding)b).getUserSuppliedProvider() instanceof MapBinder.RealMapBinder.ProviderMapEntry && indexer.isIndexable(valueBinding = (Binding)keyMap.get((pme = (MapBinder.RealMapBinder.ProviderMapEntry)((Provider)pb.getUserSuppliedProvider())).getValueKey())) && !indexedEntries.put(pme.getKey(), valueBinding.acceptTargetVisitor((BindingTargetVisitor)indexer))) {
                    ++duplicates;
                }
                key = b.getKey();
                Object visited = b.acceptTargetVisitor(visitor);
                if (visited instanceof MapBinderBinding) {
                    matched = true;
                    if (visited.equals(mapbinder)) {
                        Assert.assertTrue((boolean)contains);
                    } else {
                        otherMapBindings.add(visited);
                    }
                }
            } else if (element instanceof ProviderLookup) {
                key = ((ProviderLookup)element).getKey();
            }
            if (!matched && key != null) {
                if (key.equals((Object)mapOfProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    mapProviderMatch = true;
                } else if (key.equals((Object)mapOfJavaxProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    mapJavaxProviderMatch = true;
                } else if (key.equals((Object)mapOfSet)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    mapSetMatch = true;
                } else if (key.equals((Object)mapOfSetOfProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    mapSetProviderMatch = true;
                } else if (key.equals((Object)mapOfSetOfJavaxProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    mapSetJavaxProviderMatch = true;
                } else if (key.equals((Object)mapOfCollectionOfProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    mapCollectionProviderMatch = true;
                } else if (key.equals((Object)mapOfCollectionOfJavaxProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    mapCollectionJavaxProviderMatch = true;
                } else if (key.equals((Object)setOfEntry)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    entrySetMatch = true;
                    if (b != null) {
                        Assert.assertTrue((boolean)(b.acceptTargetVisitor(visitor) instanceof MultibinderBinding));
                    }
                } else if (key.equals((Object)setOfJavaxEntry)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    entrySetJavaxMatch = true;
                } else if (key.equals((Object)collectionOfProvidersOfEntryOfProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    collectionOfProvidersOfEntryOfProviderMatch = true;
                } else if (key.equals((Object)collectionOfJavaxProvidersOfEntryOfProvider)) {
                    matched = true;
                    Assert.assertTrue((boolean)contains);
                    collectionOfJavaxProvidersOfEntryOfProviderMatch = true;
                }
            }
            if (matched || !contains) continue;
            otherMatches.add(element);
        }
        int otherMatchesSize = otherMatches.size();
        if (allowDuplicates) {
            --otherMatchesSize;
        }
        int expectedSize = (mapResults.size() + duplicates) * 3;
        Assert.assertEquals((String)("incorrect number of contains, leftover matches:\n" + Joiner.on((String)"\n\t").join((Iterable)otherMatches)), (int)expectedSize, (int)otherMatchesSize);
        Assert.assertTrue((boolean)entrySetMatch);
        Assert.assertTrue((boolean)entrySetJavaxMatch);
        Assert.assertTrue((boolean)mapProviderMatch);
        Assert.assertTrue((boolean)mapJavaxProviderMatch);
        Assert.assertTrue((boolean)collectionOfProvidersOfEntryOfProviderMatch);
        Assert.assertTrue((boolean)collectionOfJavaxProvidersOfEntryOfProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapSetMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapSetProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapSetJavaxProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapCollectionProviderMatch);
        Assert.assertEquals((boolean)allowDuplicates, (boolean)mapCollectionJavaxProviderMatch);
        Assert.assertEquals((String)("other MapBindings found: " + otherMapBindings), (int)expectedMapBindings, (int)otherMapBindings.size());
        Guice.createInjector((Module[])new Module[]{Elements.getModule((Iterable)otherElements)});
    }

    static <T> void assertSetVisitor(Key<Set<T>> setKey, TypeLiteral<?> elementType, Iterable<? extends Module> modules, VisitType visitType, boolean allowDuplicates, int expectedMultibindings, BindResult ... results) {
        if (visitType == null) {
            Assert.fail((String)"must test something");
        }
        if (visitType == VisitType.BOTH || visitType == VisitType.INJECTOR) {
            SpiUtils.setInjectorTest(setKey, elementType, modules, allowDuplicates, expectedMultibindings, results);
        }
        if (visitType == VisitType.BOTH || visitType == VisitType.MODULE) {
            SpiUtils.setModuleTest(setKey, elementType, modules, allowDuplicates, expectedMultibindings, results);
        }
    }

    private static <T> void setInjectorTest(Key<Set<T>> setKey, TypeLiteral<?> elementType, Iterable<? extends Module> modules, boolean allowDuplicates, int otherMultibindings, BindResult ... results) {
        Key collectionOfProvidersKey = setKey.ofType(Multibinder.collectionOfProvidersOf(elementType));
        Key collectionOfJavaxProvidersKey = setKey.ofType(Multibinder.collectionOfJavaxProvidersOf(elementType));
        Injector injector = Guice.createInjector(modules);
        Visitor visitor = new Visitor();
        Binding binding = injector.getBinding(setKey);
        MultibinderBinding multibinder = (MultibinderBinding)binding.acceptTargetVisitor(visitor);
        Assert.assertNotNull((Object)multibinder);
        Assert.assertEquals(elementType, (Object)multibinder.getElementTypeLiteral());
        Assert.assertEquals((boolean)allowDuplicates, (boolean)multibinder.permitsDuplicates());
        ArrayList elements = Lists.newArrayList((Iterable)multibinder.getElements());
        ArrayList bindResults = Lists.newArrayList((Object[])results);
        Assert.assertEquals((String)("wrong bind elements, expected: " + bindResults + ", but was: " + multibinder.getElements()), (int)bindResults.size(), (int)elements.size());
        for (BindResult result : bindResults) {
            Binding found = null;
            for (Binding item : elements) {
                if (!SpiUtils.matches(item, result)) continue;
                found = item;
                break;
            }
            if (found == null) {
                Assert.fail((String)("Could not find element: " + result + " in remaining elements: " + elements));
                continue;
            }
            elements.remove(found);
        }
        if (!elements.isEmpty()) {
            Assert.fail((String)("Found all elements of: " + bindResults + ", but more were left over: " + elements));
        }
        HashSet setOfElements = new HashSet(multibinder.getElements());
        HashSet setOfIndexed = Sets.newHashSet();
        Indexer indexer = new Indexer(injector);
        for (Binding oneBinding : setOfElements) {
            setOfIndexed.add(oneBinding.acceptTargetVisitor((BindingTargetVisitor)indexer));
        }
        ArrayList otherMultibinders = Lists.newArrayList();
        ArrayList otherContains = Lists.newArrayList();
        boolean collectionOfProvidersMatch = false;
        boolean collectionOfJavaxProvidersMatch = false;
        for (Binding b : injector.getAllBindings().values()) {
            boolean contains = multibinder.containsElement((Element)b);
            Key key = b.getKey();
            Object visited = b.acceptTargetVisitor(visitor);
            if (visited != null) {
                if (visited.equals(multibinder)) {
                    Assert.assertTrue((boolean)contains);
                    continue;
                }
                otherMultibinders.add(visited);
                continue;
            }
            if (setOfElements.contains(b)) {
                Assert.assertTrue((boolean)contains);
                continue;
            }
            if (key.equals((Object)collectionOfProvidersKey)) {
                Assert.assertTrue((boolean)contains);
                collectionOfProvidersMatch = true;
                continue;
            }
            if (key.equals((Object)collectionOfJavaxProvidersKey)) {
                Assert.assertTrue((boolean)contains);
                collectionOfJavaxProvidersMatch = true;
                continue;
            }
            if (!contains || indexer.isIndexable(b) && setOfIndexed.contains(b.acceptTargetVisitor((BindingTargetVisitor)indexer))) continue;
            otherContains.add(b);
        }
        Assert.assertTrue((boolean)collectionOfProvidersMatch);
        Assert.assertTrue((boolean)collectionOfJavaxProvidersMatch);
        if (allowDuplicates) {
            Assert.assertEquals((String)("contained more than it should: " + otherContains), (int)1, (int)otherContains.size());
        } else {
            Assert.assertTrue((String)("contained more than it should: " + otherContains), (boolean)otherContains.isEmpty());
        }
        Assert.assertEquals((String)("other multibindings found: " + otherMultibinders), (int)otherMultibindings, (int)otherMultibinders.size());
    }

    private static <T> void setModuleTest(Key<Set<T>> setKey, TypeLiteral<?> elementType, Iterable<? extends Module> modules, boolean allowDuplicates, int otherMultibindings, BindResult ... results) {
        Key collectionOfProvidersKey = setKey.ofType(Multibinder.collectionOfProvidersOf(elementType));
        Key collectionOfJavaxProvidersKey = setKey.ofType(Multibinder.collectionOfJavaxProvidersOf(elementType));
        ArrayList bindResults = Lists.newArrayList((Object[])results);
        List elements = Elements.getElements(modules);
        Visitor visitor = new Visitor();
        MultibinderBinding multibinder = null;
        for (Element element : elements) {
            if (!(element instanceof Binding) || !((Binding)element).getKey().equals(setKey)) continue;
            multibinder = (MultibinderBinding)((Binding)element).acceptTargetVisitor(visitor);
            break;
        }
        Assert.assertNotNull(multibinder);
        Assert.assertEquals(elementType, (Object)multibinder.getElementTypeLiteral());
        ArrayList otherMultibinders = Lists.newArrayList();
        HashSet<Element> otherContains = new HashSet<Element>();
        ArrayList otherElements = Lists.newArrayList();
        int duplicates = 0;
        HashSet setOfIndexed = Sets.newHashSet();
        Indexer indexer = new Indexer(null);
        boolean collectionOfProvidersMatch = false;
        boolean collectionOfJavaxProvidersMatch = false;
        for (Element element : elements) {
            boolean contains = multibinder.containsElement(element);
            if (!contains) {
                otherElements.add(element);
            }
            boolean matched = false;
            Key key = null;
            if (element instanceof Binding) {
                Binding binding = (Binding)element;
                if (indexer.isIndexable(binding) && !setOfIndexed.add((Indexer.IndexedBinding)binding.acceptTargetVisitor((BindingTargetVisitor)indexer))) {
                    ++duplicates;
                }
                key = binding.getKey();
                Object visited = binding.acceptTargetVisitor(visitor);
                if (visited != null) {
                    matched = true;
                    if (visited.equals(multibinder)) {
                        Assert.assertTrue((boolean)contains);
                    } else {
                        otherMultibinders.add(visited);
                    }
                }
            }
            if (collectionOfProvidersKey.equals(key)) {
                Assert.assertTrue((boolean)contains);
                Assert.assertFalse((boolean)matched);
                collectionOfProvidersMatch = true;
                continue;
            }
            if (collectionOfJavaxProvidersKey.equals(key)) {
                Assert.assertTrue((boolean)contains);
                Assert.assertFalse((boolean)matched);
                collectionOfJavaxProvidersMatch = true;
                continue;
            }
            if (matched || !contains) continue;
            otherContains.add(element);
        }
        if (allowDuplicates) {
            Assert.assertEquals((String)("wrong contained elements: " + otherContains), (int)(bindResults.size() + 1 + duplicates), (int)otherContains.size());
        } else {
            Assert.assertEquals((String)("wrong contained elements: " + otherContains), (int)(bindResults.size() + duplicates), (int)otherContains.size());
        }
        Assert.assertEquals((String)("other multibindings found: " + otherMultibinders), (int)otherMultibindings, (int)otherMultibinders.size());
        Assert.assertTrue((boolean)collectionOfProvidersMatch);
        Assert.assertTrue((boolean)collectionOfJavaxProvidersMatch);
        Guice.createInjector((Module[])new Module[]{Elements.getModule((Iterable)otherElements)});
    }

    static <T> void assertOptionalVisitor(Key<T> keyType, Iterable<? extends Module> modules, VisitType visitType, int expectedOtherOptionalBindings, BindResult<?> expectedDefault, BindResult<?> expectedActual, BindResult<?> expectedUserLinkedActual) {
        if (visitType == null) {
            Assert.fail((String)"must test something");
        }
        if (HAS_JAVA_OPTIONAL) {
            expectedOtherOptionalBindings *= 2;
        }
        if (visitType == VisitType.BOTH || visitType == VisitType.INJECTOR) {
            SpiUtils.optionalInjectorTest(keyType, modules, expectedOtherOptionalBindings, expectedDefault, expectedActual, expectedUserLinkedActual);
        }
        if (visitType == VisitType.BOTH || visitType == VisitType.MODULE) {
            SpiUtils.optionalModuleTest(keyType, modules, expectedOtherOptionalBindings, expectedDefault, expectedActual, expectedUserLinkedActual);
        }
    }

    private static <T> void optionalInjectorTest(Key<T> keyType, Iterable<? extends Module> modules, int expectedOtherOptionalBindings, BindResult<?> expectedDefault, BindResult<?> expectedActual, BindResult<?> expectedUserLinkedActual) {
        if (expectedUserLinkedActual != null) {
            Assert.assertNull((String)"cannot have actual if expecting user binding", expectedActual);
            Assert.assertNull((String)"cannot have default if expecting user binding", expectedDefault);
        }
        Key optionalKey = keyType.ofType(OptionalBinder.optionalOf((TypeLiteral)keyType.getTypeLiteral()));
        Key javaOptionalKey = HAS_JAVA_OPTIONAL ? keyType.ofType(OptionalBinder.javaOptionalOf((TypeLiteral)keyType.getTypeLiteral())) : null;
        Injector injector = Guice.createInjector(modules);
        Binding optionalBinding = injector.getBinding(optionalKey);
        Visitor visitor = new Visitor();
        OptionalBinderBinding optionalBinder = (OptionalBinderBinding)optionalBinding.acceptTargetVisitor(visitor);
        Assert.assertNotNull((Object)optionalBinder);
        Assert.assertEquals((Object)optionalKey, (Object)optionalBinder.getKey());
        Binding javaOptionalBinding = null;
        OptionalBinderBinding javaOptionalBinder = null;
        if (HAS_JAVA_OPTIONAL) {
            javaOptionalBinding = injector.getBinding(javaOptionalKey);
            javaOptionalBinder = (OptionalBinderBinding)javaOptionalBinding.acceptTargetVisitor(visitor);
            Assert.assertNotNull((Object)javaOptionalBinder);
            Assert.assertEquals((Object)javaOptionalKey, (Object)javaOptionalBinder.getKey());
        }
        if (expectedDefault == null) {
            Assert.assertNull((String)"did not expect a default binding", (Object)optionalBinder.getDefaultBinding());
            if (HAS_JAVA_OPTIONAL) {
                Assert.assertNull((String)"did not expect a default binding", (Object)javaOptionalBinder.getDefaultBinding());
            }
        } else {
            Assert.assertTrue((String)("expectedDefault: " + expectedDefault + ", actualDefault: " + optionalBinder.getDefaultBinding()), (boolean)SpiUtils.matches(optionalBinder.getDefaultBinding(), expectedDefault));
            if (HAS_JAVA_OPTIONAL) {
                Assert.assertTrue((String)("expectedDefault: " + expectedDefault + ", actualDefault: " + javaOptionalBinder.getDefaultBinding()), (boolean)SpiUtils.matches(javaOptionalBinder.getDefaultBinding(), expectedDefault));
            }
        }
        if (expectedActual == null && expectedUserLinkedActual == null) {
            Assert.assertNull((Object)optionalBinder.getActualBinding());
            if (HAS_JAVA_OPTIONAL) {
                Assert.assertNull((Object)javaOptionalBinder.getActualBinding());
            }
        } else if (expectedActual != null) {
            Assert.assertTrue((String)("expectedActual: " + expectedActual + ", actualActual: " + optionalBinder.getActualBinding()), (boolean)SpiUtils.matches(optionalBinder.getActualBinding(), expectedActual));
            if (HAS_JAVA_OPTIONAL) {
                Assert.assertTrue((String)("expectedActual: " + expectedActual + ", actualActual: " + javaOptionalBinder.getActualBinding()), (boolean)SpiUtils.matches(javaOptionalBinder.getActualBinding(), expectedActual));
            }
        } else if (expectedUserLinkedActual != null) {
            Assert.assertTrue((String)("expectedUserLinkedActual: " + expectedUserLinkedActual + ", actualActual: " + optionalBinder.getActualBinding()), (boolean)SpiUtils.matches(optionalBinder.getActualBinding(), expectedUserLinkedActual));
            if (HAS_JAVA_OPTIONAL) {
                Assert.assertTrue((String)("expectedUserLinkedActual: " + expectedUserLinkedActual + ", actualActual: " + javaOptionalBinder.getActualBinding()), (boolean)SpiUtils.matches(javaOptionalBinder.getActualBinding(), expectedUserLinkedActual));
            }
        }
        Key optionalJavaxProviderKey = keyType.ofType(OptionalBinder.optionalOfJavaxProvider((TypeLiteral)keyType.getTypeLiteral()));
        Key javaOptionalJavaxProviderKey = HAS_JAVA_OPTIONAL ? keyType.ofType(OptionalBinder.javaOptionalOfJavaxProvider((TypeLiteral)keyType.getTypeLiteral())) : null;
        Key optionalProviderKey = keyType.ofType(OptionalBinder.optionalOfProvider((TypeLiteral)keyType.getTypeLiteral()));
        Key javaOptionalProviderKey = HAS_JAVA_OPTIONAL ? keyType.ofType(OptionalBinder.javaOptionalOfProvider((TypeLiteral)keyType.getTypeLiteral())) : null;
        boolean keyMatch = false;
        boolean optionalKeyMatch = false;
        boolean javaOptionalKeyMatch = false;
        boolean optionalJavaxProviderKeyMatch = false;
        boolean javaOptionalJavaxProviderKeyMatch = false;
        boolean optionalProviderKeyMatch = false;
        boolean javaOptionalProviderKeyMatch = false;
        boolean defaultMatch = false;
        boolean actualMatch = false;
        ArrayList otherOptionalBindings = Lists.newArrayList();
        ArrayList otherMatches = Lists.newArrayList();
        for (Binding b : injector.getAllBindings().values()) {
            Object visited;
            boolean contains = optionalBinder.containsElement((Element)b);
            if (HAS_JAVA_OPTIONAL) {
                Assert.assertEquals((boolean)contains, (boolean)javaOptionalBinder.containsElement((Element)b));
            }
            if ((visited = b.acceptTargetVisitor(visitor)) instanceof OptionalBinderBinding) {
                if (visited.equals(optionalBinder)) {
                    Assert.assertTrue((boolean)contains);
                } else if (HAS_JAVA_OPTIONAL && visited.equals(javaOptionalBinder)) {
                    Assert.assertTrue((boolean)contains);
                } else {
                    otherOptionalBindings.add(visited);
                }
            }
            if (b.getKey().equals(keyType)) {
                Assert.assertEquals((expectedDefault != null || expectedActual != null ? 1 : 0) != 0, (boolean)contains);
                if (!contains) continue;
                keyMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)optionalKey)) {
                Assert.assertTrue((boolean)contains);
                optionalKeyMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)javaOptionalKey)) {
                Assert.assertTrue((boolean)contains);
                javaOptionalKeyMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)optionalJavaxProviderKey)) {
                Assert.assertTrue((boolean)contains);
                optionalJavaxProviderKeyMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)javaOptionalJavaxProviderKey)) {
                Assert.assertTrue((boolean)contains);
                javaOptionalJavaxProviderKeyMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)optionalProviderKey)) {
                Assert.assertTrue((boolean)contains);
                optionalProviderKeyMatch = true;
                continue;
            }
            if (b.getKey().equals((Object)javaOptionalProviderKey)) {
                Assert.assertTrue((boolean)contains);
                javaOptionalProviderKeyMatch = true;
                continue;
            }
            if (expectedDefault != null && SpiUtils.matches(b, expectedDefault)) {
                Assert.assertTrue((boolean)contains);
                defaultMatch = true;
                continue;
            }
            if (expectedActual != null && SpiUtils.matches(b, expectedActual)) {
                Assert.assertTrue((boolean)contains);
                actualMatch = true;
                continue;
            }
            if (!contains) continue;
            otherMatches.add(b);
        }
        Assert.assertEquals((String)((Object)otherMatches).toString(), (int)0, (int)otherMatches.size());
        Assert.assertEquals((expectedDefault != null || expectedActual != null ? 1 : 0) != 0, (boolean)keyMatch);
        Assert.assertTrue((boolean)optionalKeyMatch);
        Assert.assertTrue((boolean)optionalJavaxProviderKeyMatch);
        Assert.assertTrue((boolean)optionalProviderKeyMatch);
        Assert.assertEquals((boolean)HAS_JAVA_OPTIONAL, (boolean)javaOptionalKeyMatch);
        Assert.assertEquals((boolean)HAS_JAVA_OPTIONAL, (boolean)javaOptionalJavaxProviderKeyMatch);
        Assert.assertEquals((boolean)HAS_JAVA_OPTIONAL, (boolean)javaOptionalProviderKeyMatch);
        Assert.assertEquals((expectedDefault != null ? 1 : 0) != 0, (boolean)defaultMatch);
        Assert.assertEquals((expectedActual != null ? 1 : 0) != 0, (boolean)actualMatch);
        Assert.assertEquals((String)("other OptionalBindings found: " + otherOptionalBindings), (int)expectedOtherOptionalBindings, (int)otherOptionalBindings.size());
    }

    private static <T> void optionalModuleTest(Key<T> keyType, Iterable<? extends Module> modules, int expectedOtherOptionalBindings, BindResult<?> expectedDefault, BindResult<?> expectedActual, BindResult<?> expectedUserLinkedActual) {
        if (expectedUserLinkedActual != null) {
            Assert.assertNull((String)"cannot have actual if expecting user binding", expectedActual);
            Assert.assertNull((String)"cannot have default if expecting user binding", expectedDefault);
        }
        ImmutableSet elements = ImmutableSet.copyOf((Collection)Elements.getElements(modules));
        Map<Key<?>, Binding<?>> indexed = SpiUtils.index((Iterable<Element>)elements);
        Key optionalKey = keyType.ofType(OptionalBinder.optionalOf((TypeLiteral)keyType.getTypeLiteral()));
        Key javaOptionalKey = HAS_JAVA_OPTIONAL ? keyType.ofType(OptionalBinder.javaOptionalOf((TypeLiteral)keyType.getTypeLiteral())) : null;
        Visitor visitor = new Visitor();
        OptionalBinderBinding optionalBinder = null;
        OptionalBinderBinding javaOptionalBinder = null;
        Key defaultKey = null;
        Key actualKey = null;
        Binding<?> optionalBinding = indexed.get(optionalKey);
        optionalBinder = (OptionalBinderBinding)optionalBinding.acceptTargetVisitor(visitor);
        if (HAS_JAVA_OPTIONAL) {
            Iterator javaOptionalBinding = indexed.get(javaOptionalKey);
            javaOptionalBinder = (OptionalBinderBinding)javaOptionalBinding.acceptTargetVisitor((BindingTargetVisitor)visitor);
        }
        for (Element element : elements) {
            if (!optionalBinder.containsElement(element) || !(element instanceof Binding)) continue;
            Binding binding = (Binding)element;
            if (SpiUtils.isSourceEntry(binding, OptionalBinder.Source.DEFAULT)) {
                defaultKey = binding.getKey();
                continue;
            }
            if (!SpiUtils.isSourceEntry(binding, OptionalBinder.Source.ACTUAL)) continue;
            actualKey = binding.getKey();
        }
        Assert.assertNotNull((Object)optionalBinder);
        if (HAS_JAVA_OPTIONAL) {
            Assert.assertNotNull((Object)javaOptionalBinder);
        }
        Assert.assertEquals((expectedDefault == null ? 1 : 0) != 0, (defaultKey == null ? 1 : 0) != 0);
        Assert.assertEquals((expectedActual == null ? 1 : 0) != 0, (actualKey == null ? 1 : 0) != 0);
        Key optionalJavaxProviderKey = keyType.ofType(OptionalBinder.optionalOfJavaxProvider((TypeLiteral)keyType.getTypeLiteral()));
        Key javaOptionalJavaxProviderKey = HAS_JAVA_OPTIONAL ? keyType.ofType(OptionalBinder.javaOptionalOfJavaxProvider((TypeLiteral)keyType.getTypeLiteral())) : null;
        Key optionalProviderKey = keyType.ofType(OptionalBinder.optionalOfProvider((TypeLiteral)keyType.getTypeLiteral()));
        Key javaOptionalProviderKey = HAS_JAVA_OPTIONAL ? keyType.ofType(OptionalBinder.javaOptionalOfProvider((TypeLiteral)keyType.getTypeLiteral())) : null;
        boolean keyMatch = false;
        boolean optionalKeyMatch = false;
        boolean javaOptionalKeyMatch = false;
        boolean optionalJavaxProviderKeyMatch = false;
        boolean javaOptionalJavaxProviderKeyMatch = false;
        boolean optionalProviderKeyMatch = false;
        boolean javaOptionalProviderKeyMatch = false;
        boolean defaultMatch = false;
        boolean actualMatch = false;
        ArrayList otherOptionalElements = Lists.newArrayList();
        ArrayList otherContains = Lists.newArrayList();
        ArrayList nonContainedElements = Lists.newArrayList();
        for (Element element : elements) {
            boolean contains = optionalBinder.containsElement(element);
            if (HAS_JAVA_OPTIONAL) {
                Assert.assertEquals((boolean)contains, (boolean)javaOptionalBinder.containsElement(element));
            }
            if (!contains) {
                nonContainedElements.add(element);
            }
            Key key = null;
            Binding b = null;
            if (element instanceof Binding) {
                b = (Binding)element;
                key = b.getKey();
                Object visited = b.acceptTargetVisitor(visitor);
                if (visited instanceof OptionalBinderBinding) {
                    if (visited.equals(optionalBinder)) {
                        Assert.assertTrue((boolean)contains);
                    } else if (HAS_JAVA_OPTIONAL && visited.equals(javaOptionalBinder)) {
                        Assert.assertTrue((boolean)contains);
                    } else {
                        otherOptionalElements.add(visited);
                    }
                }
            } else if (element instanceof ProviderLookup) {
                key = ((ProviderLookup)element).getKey();
            }
            if (key != null && key.equals(keyType)) {
                Assert.assertEquals((expectedDefault != null || expectedActual != null ? 1 : 0) != 0, (boolean)contains);
                if (!contains) continue;
                keyMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)optionalKey)) {
                Assert.assertTrue((boolean)contains);
                optionalKeyMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)javaOptionalKey)) {
                Assert.assertTrue((boolean)contains);
                javaOptionalKeyMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)optionalJavaxProviderKey)) {
                Assert.assertTrue((boolean)contains);
                optionalJavaxProviderKeyMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)javaOptionalJavaxProviderKey)) {
                Assert.assertTrue((boolean)contains);
                javaOptionalJavaxProviderKeyMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)optionalProviderKey)) {
                Assert.assertTrue((boolean)contains);
                optionalProviderKeyMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)javaOptionalProviderKey)) {
                Assert.assertTrue((boolean)contains);
                javaOptionalProviderKeyMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)defaultKey)) {
                Assert.assertTrue((boolean)contains);
                if (b == null) continue;
                Assert.assertTrue((String)("expected: " + expectedDefault + ", but was: " + b), (boolean)SpiUtils.matches(b, expectedDefault));
                defaultMatch = true;
                continue;
            }
            if (key != null && key.equals((Object)actualKey)) {
                Assert.assertTrue((boolean)contains);
                if (b == null) continue;
                Assert.assertTrue((String)("expected: " + expectedActual + ", but was: " + b), (boolean)SpiUtils.matches(b, expectedActual));
                actualMatch = true;
                continue;
            }
            if (!contains) continue;
            otherContains.add(element);
        }
        Assert.assertEquals((expectedDefault != null || expectedActual != null ? 1 : 0) != 0, (boolean)keyMatch);
        Assert.assertTrue((boolean)optionalKeyMatch);
        Assert.assertTrue((boolean)optionalJavaxProviderKeyMatch);
        Assert.assertTrue((boolean)optionalProviderKeyMatch);
        Assert.assertEquals((boolean)HAS_JAVA_OPTIONAL, (boolean)javaOptionalKeyMatch);
        Assert.assertEquals((boolean)HAS_JAVA_OPTIONAL, (boolean)javaOptionalJavaxProviderKeyMatch);
        Assert.assertEquals((boolean)HAS_JAVA_OPTIONAL, (boolean)javaOptionalProviderKeyMatch);
        Assert.assertEquals((expectedDefault != null ? 1 : 0) != 0, (boolean)defaultMatch);
        Assert.assertEquals((expectedActual != null ? 1 : 0) != 0, (boolean)actualMatch);
        Assert.assertEquals((String)((Object)otherContains).toString(), (int)0, (int)otherContains.size());
        Assert.assertEquals((String)("other OptionalBindings found: " + otherOptionalElements), (int)expectedOtherOptionalBindings, (int)otherOptionalElements.size());
        Guice.createInjector((Module[])new Module[]{Elements.getModule((Iterable)nonContainedElements)});
    }

    private static boolean isSourceEntry(Binding b, OptionalBinder.Source type) {
        switch (type) {
            case ACTUAL: {
                return b.getKey().getAnnotation() instanceof OptionalBinder.Actual;
            }
            case DEFAULT: {
                return b.getKey().getAnnotation() instanceof OptionalBinder.Default;
            }
        }
        throw new IllegalStateException("invalid type: " + type);
    }

    private static Map<Key<?>, Binding<?>> index(Iterable<Element> elements) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Element element : elements) {
            if (!(element instanceof Binding)) continue;
            builder.put((Object)((Binding)element).getKey(), (Object)((Binding)element));
        }
        return builder.build();
    }

    static <K, V> MapResult instance(K k, V v) {
        return new MapResult(k, new BindResult(BindType.INSTANCE, v, null));
    }

    static <K, V> MapResult linked(K k, Class<? extends V> clazz) {
        return new MapResult(k, new BindResult(BindType.LINKED, null, Key.get(clazz)));
    }

    static <K, V> MapResult linked(K k, Key<? extends V> key) {
        return new MapResult(k, new BindResult(BindType.LINKED, null, key));
    }

    static <K, V> MapResult providerInstance(K k, V v) {
        return new MapResult(k, new BindResult(BindType.PROVIDER_INSTANCE, v, null));
    }

    private static boolean matches(Binding<?> item, BindResult<?> result) {
        switch (((BindResult)result).type) {
            case INSTANCE: {
                if (!(item instanceof InstanceBinding) || !((InstanceBinding)item).getInstance().equals(((BindResult)result).instance)) break;
                return true;
            }
            case LINKED: {
                if (!(item instanceof LinkedKeyBinding) || !((LinkedKeyBinding)item).getLinkedKey().equals((Object)((BindResult)result).key)) break;
                return true;
            }
            case PROVIDER_INSTANCE: {
                if (!(item instanceof ProviderInstanceBinding) || !Objects.equal((Object)((ProviderInstanceBinding)item).getUserSuppliedProvider().get(), (Object)((BindResult)result).instance)) break;
                return true;
            }
            case PROVIDER_KEY: {
                if (!(item instanceof ProviderKeyBinding) || !((ProviderKeyBinding)item).getProviderKey().equals((Object)((BindResult)result).key)) break;
                return true;
            }
        }
        return false;
    }

    static <T> BindResult<T> instance(T t) {
        return new BindResult(BindType.INSTANCE, t, null);
    }

    static <T> BindResult<T> linked(Class<? extends T> clazz) {
        return new BindResult(BindType.LINKED, null, Key.get(clazz));
    }

    static <T> BindResult<T> linked(Key<? extends T> key) {
        return new BindResult(BindType.LINKED, null, key);
    }

    static <T> BindResult<T> providerInstance(T t) {
        return new BindResult(BindType.PROVIDER_INSTANCE, t, null);
    }

    static <T> BindResult<T> providerKey(Key<T> key) {
        return new BindResult(BindType.PROVIDER_KEY, null, key);
    }

    static {
        Class<?> optional = null;
        try {
            optional = Class.forName("java.util.Optional");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAS_JAVA_OPTIONAL = optional != null;
    }

    private static class Visitor<T>
    extends DefaultBindingTargetVisitor<T, Object>
    implements MultibindingsTargetVisitor<T, Object> {
        private Visitor() {
        }

        public Object visit(MultibinderBinding<? extends T> multibinding) {
            return multibinding;
        }

        public Object visit(MapBinderBinding<? extends T> mapbinding) {
            return mapbinding;
        }

        public Object visit(OptionalBinderBinding<? extends T> optionalbinding) {
            return optionalbinding;
        }
    }

    static class BindResult<T> {
        private final BindType type;
        private final Key<?> key;
        private final T instance;

        private BindResult(BindType type, T instance, Key<?> key) {
            this.type = type;
            this.instance = instance;
            this.key = key;
        }

        public String toString() {
            switch (this.type) {
                case INSTANCE: {
                    return "instance[" + this.instance + "]";
                }
                case LINKED: {
                    return "linkedKey[" + this.key + "]";
                }
                case PROVIDER_INSTANCE: {
                    return "providerInstance[" + this.instance + "]";
                }
                case PROVIDER_KEY: {
                    return "providerKey[" + this.key + "]";
                }
            }
            return null;
        }
    }

    static enum BindType {
        INSTANCE,
        LINKED,
        PROVIDER_INSTANCE,
        PROVIDER_KEY;

    }

    static class MapResult<K, V> {
        private final K k;
        private final BindResult<V> v;

        MapResult(K k, BindResult<V> v) {
            this.k = k;
            this.v = v;
        }

        public String toString() {
            return "entry[key[" + this.k + "],value[" + this.v + "]]";
        }
    }

    static enum VisitType {
        INJECTOR,
        MODULE,
        BOTH;

    }
}

