/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist;

import com.google.inject.AbstractModule;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.Transactional;
import com.google.inject.persist.UnitOfWork;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;

public abstract class PersistModule
extends AbstractModule {
    private static final Matcher<Method> NOT_OBJECT_METHOD = new AbstractMatcher<Method>(){

        public boolean matches(Method m) {
            return !Object.class.equals(m.getDeclaringClass());
        }
    };

    protected final void configure() {
        this.configurePersistence();
        this.requireBinding(PersistService.class);
        this.requireBinding(UnitOfWork.class);
        if (InternalFlags.isBytecodeGenEnabled()) {
            this.bindInterceptor(Matchers.annotatedWith(Transactional.class), NOT_OBJECT_METHOD, new MethodInterceptor[]{this.getTransactionInterceptor()});
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{this.getTransactionInterceptor()});
        }
    }

    protected abstract void configurePersistence();

    protected abstract MethodInterceptor getTransactionInterceptor();
}

