/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spring;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.internal.guava.base.;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringIntegration {
    private SpringIntegration() {
    }

    public static <T> Provider<T> fromSpring(Class<T> type, String name) {
        return new InjectableSpringProvider<T>(type, name);
    }

    public static void bindAll(Binder binder, ListableBeanFactory beanFactory) {
        binder = binder.skipSources(new Class[]{SpringIntegration.class});
        for (String name : beanFactory.getBeanDefinitionNames()) {
            Class type = beanFactory.getType(name);
            SpringIntegration.bindBean(binder, beanFactory, name, type);
        }
    }

    static <T> void bindBean(Binder binder, ListableBeanFactory beanFactory, String name, Class<T> type) {
        SpringProvider<T> provider = SpringProvider.newInstance(type, name);
        try {
            provider.initialize((BeanFactory)beanFactory);
        }
        catch (Exception e) {
            binder.addError((Throwable)e);
            return;
        }
        binder.bind(type).annotatedWith((Annotation)Names.named((String)name)).toProvider(provider);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InjectableSpringProvider<T>
    extends SpringProvider<T> {
        InjectableSpringProvider(Class<T> type, String name) {
            super(type, name);
        }

        @Override
        @Inject
        void initialize(BeanFactory beanFactory) {
            super.initialize(beanFactory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SpringProvider<T>
    implements Provider<T> {
        BeanFactory beanFactory;
        boolean singleton;
        final Class<T> type;
        final String name;
        volatile T instance;

        public SpringProvider(Class<T> type, String name) {
            this.type = (Class).Preconditions.checkNotNull(type, (Object)"type");
            this.name = (String).Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        static <T> SpringProvider<T> newInstance(Class<T> type, String name) {
            return new SpringProvider<T>(type, name);
        }

        void initialize(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
            if (!beanFactory.isTypeMatch(this.name, this.type)) {
                throw new ClassCastException("Spring bean named '" + this.name + "' does not implement " + this.type.getName() + ".");
            }
            this.singleton = beanFactory.isSingleton(this.name);
        }

        public T get() {
            return this.singleton ? this.getSingleton() : this.type.cast(this.beanFactory.getBean(this.name));
        }

        private T getSingleton() {
            if (this.instance == null) {
                this.instance = this.type.cast(this.beanFactory.getBean(this.name));
            }
            return this.instance;
        }
    }
}

