/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spring;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringIntegration {
    private SpringIntegration() {
    }

    public static <T> Provider<T> fromSpring(Class<T> type, String name) {
        return new InjectableSpringProvider<T>(type, name);
    }

    public static void bindAll(Binder binder, ListableBeanFactory beanFactory) {
        binder = binder.skipSources(new Class[]{SpringIntegration.class});
        for (String name : beanFactory.getBeanDefinitionNames()) {
            Class type = beanFactory.getType(name);
            SpringIntegration.bindBean(binder, beanFactory, name, type);
        }
    }

    static <T> void bindBean(Binder binder, ListableBeanFactory beanFactory, String name, Class<T> type) {
        SpringProvider<T> provider = SpringProvider.newInstance(type, name);
        try {
            provider.initialize((BeanFactory)beanFactory);
        }
        catch (Exception e) {
            binder.addError((Throwable)e);
            return;
        }
        binder.bind(type).annotatedWith((Annotation)Names.named((String)name)).toProvider(provider);
    }

    static class InjectableSpringProvider<T>
    extends SpringProvider<T> {
        InjectableSpringProvider(Class<T> type, String name) {
            super(type, name);
        }

        @Override
        @Inject
        void initialize(BeanFactory beanFactory) {
            super.initialize(beanFactory);
        }
    }

    static class SpringProvider<T>
    implements Provider<T> {
        BeanFactory beanFactory;
        boolean singleton;
        final Class<T> type;
        final String name;
        volatile T instance;

        public SpringProvider(Class<T> type, String name) {
            this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        static <T> SpringProvider<T> newInstance(Class<T> type, String name) {
            return new SpringProvider<T>(type, name);
        }

        void initialize(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
            if (!beanFactory.isTypeMatch(this.name, this.type)) {
                String string = String.valueOf(String.valueOf(this.name));
                String string2 = String.valueOf(String.valueOf(this.type.getName()));
                throw new ClassCastException(new StringBuilder(41 + string.length() + string2.length()).append("Spring bean named '").append(string).append("' does not implement ").append(string2).append(".").toString());
            }
            this.singleton = beanFactory.isSingleton(this.name);
        }

        public T get() {
            return this.singleton ? this.getSingleton() : this.type.cast(this.beanFactory.getBean(this.name));
        }

        private T getSingleton() {
            if (this.instance == null) {
                this.instance = this.type.cast(this.beanFactory.getBean(this.name));
            }
            return this.instance;
        }
    }
}

