/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.testing.throwingproviders;

import com.google.common.base.Strings;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.ThrowableSubject;
import com.google.common.truth.Truth;
import com.google.inject.throwingproviders.CheckedProvider;
import javax.annotation.Nullable;

public final class CheckedProviderSubject<T, P extends CheckedProvider<T>>
extends Subject<CheckedProviderSubject<T, P>, P> {
    public static <T, P extends CheckedProvider<T>> Subject.Factory<CheckedProviderSubject<T, P>, P> checkedProviders() {
        return new CheckedProviderSubjectFactory();
    }

    public static <T, P extends CheckedProvider<T>> CheckedProviderSubject<T, P> assertThat(@Nullable P provider) {
        return (CheckedProviderSubject)Truth.assertAbout(CheckedProviderSubject.checkedProviders()).that(provider);
    }

    private CheckedProviderSubject(FailureMetadata failureMetadata, @Nullable P subject) {
        super(failureMetadata, subject);
    }

    public Subject<?, Object> providedValue() {
        Object got;
        CheckedProvider provider = (CheckedProvider)this.actual();
        try {
            got = provider.get();
        }
        catch (Exception e) {
            this.failWithCauseAndMessage(e, "checked provider <%s> threw an exception", provider);
            return this.ignoreCheck().that(new Object());
        }
        return this.check().withMessage("value provided by <%s>", new Object[]{provider}).that(got);
    }

    public ThrowableSubject thrownException() {
        Object got;
        CheckedProvider provider = (CheckedProvider)this.actual();
        try {
            got = provider.get();
        }
        catch (Throwable e) {
            return this.check().withMessage("exception thrown by <%s>", new Object[]{provider}).that(e);
        }
        this.failWithBadResults("threw", "an exception", "provided", got);
        return this.ignoreCheck().that(new Throwable());
    }

    private void failWithCauseAndMessage(Throwable cause, String format, Object ... args) {
        ((UnexpectedFailureSubject)this.check().about(CheckedProviderSubject.unexpectedFailures()).that((Object)cause)).doFail(format, args);
    }

    private static Subject.Factory<UnexpectedFailureSubject, Throwable> unexpectedFailures() {
        return new Subject.Factory<UnexpectedFailureSubject, Throwable>(){

            public UnexpectedFailureSubject createSubject(FailureMetadata metadata, Throwable actual) {
                return new UnexpectedFailureSubject(metadata, actual);
            }
        };
    }

    /* synthetic */ CheckedProviderSubject(FailureMetadata x0, CheckedProvider x1, 1 x2) {
        this(x0, x1);
    }

    private static final class UnexpectedFailureSubject
    extends Subject<UnexpectedFailureSubject, Throwable> {
        UnexpectedFailureSubject(FailureMetadata metadata, @Nullable Throwable actual) {
            super(metadata, (Object)actual);
        }

        void doFail(String format, Object ... args) {
            this.failWithoutActual(Fact.simpleFact((String)Strings.lenientFormat((String)format, (Object[])args)), new Fact[0]);
        }
    }

    private static final class CheckedProviderSubjectFactory<T, P extends CheckedProvider<T>>
    implements Subject.Factory<CheckedProviderSubject<T, P>, P> {
        private CheckedProviderSubjectFactory() {
        }

        public CheckedProviderSubject<T, P> createSubject(FailureMetadata failureMetadata, @Nullable P target) {
            return new CheckedProviderSubject(failureMetadata, (CheckedProvider)target, null);
        }
    }
}

