/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.testing.fieldbinder;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.RestrictedBindingSource;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.KotlinSupport;
import com.google.inject.internal.MoreTypes;
import com.google.inject.internal.Nullability;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import com.google.inject.testing.fieldbinder.Bind;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public final class BoundFieldModule
implements Module {
    private final Object instance;
    private final ImmutableList<Message> deferredBindingErrors;
    private final ImmutableSet<BoundFieldInfo> boundFields;

    private BoundFieldModule(Object instance) {
        this.instance = instance;
        ImmutableList.Builder deferredErrors = ImmutableList.builder();
        this.boundFields = this.findBindableFields((ImmutableList.Builder<Message>)deferredErrors);
        this.deferredBindingErrors = deferredErrors.build();
    }

    public static BoundFieldModule of(Object instance) {
        return new BoundFieldModule(instance);
    }

    public Object getInstance() {
        return this.instance;
    }

    public ImmutableSet<BoundFieldInfo> getBoundFields() {
        return this.boundFields;
    }

    private ImmutableSet<BoundFieldInfo> findBindableFields(ImmutableList.Builder<Message> deferredErrors) {
        ImmutableSet.Builder fieldInfos = ImmutableSet.builder();
        TypeLiteral currentClassType = TypeLiteral.get(this.instance.getClass());
        while (currentClassType.getRawType() != Object.class) {
            for (Field field : currentClassType.getRawType().getDeclaredFields()) {
                Optional<BoundFieldInfo> fieldInfoOpt = this.getBoundFieldInfo(currentClassType, field, deferredErrors);
                if (!fieldInfoOpt.isPresent()) continue;
                fieldInfos.add((Object)((BoundFieldInfo)fieldInfoOpt.get()));
            }
            currentClassType = currentClassType.getSupertype(currentClassType.getRawType().getSuperclass());
        }
        return fieldInfos.build();
    }

    private Optional<BoundFieldInfo> getBoundFieldInfo(TypeLiteral<?> containingClassType, Field field, ImmutableList.Builder<Message> deferredErrors) {
        Bind bindAnnotation = field.getAnnotation(Bind.class);
        if (bindAnnotation == null) {
            return Optional.absent();
        }
        if (BoundFieldModule.hasInject(field)) {
            deferredErrors.add((Object)new Message((Object)field, "Fields annotated with both @Bind and @Inject are illegal."));
            return Optional.absent();
        }
        try {
            return Optional.of((Object)new BoundFieldInfo(this.instance, field, bindAnnotation, containingClassType.getFieldType(field)));
        }
        catch (ConfigurationException e) {
            deferredErrors.addAll((Iterable)e.getErrorMessages());
            return Optional.absent();
        }
        catch (BoundFieldException e) {
            deferredErrors.add((Object)e.message);
            return Optional.absent();
        }
    }

    private static boolean hasInject(Field field) {
        return field.isAnnotationPresent(javax.inject.Inject.class) || field.isAnnotationPresent(Inject.class);
    }

    private static boolean isTransparentProvider(Class<?> clazz) {
        return Provider.class == clazz || javax.inject.Provider.class == clazz;
    }

    private static void bindField(Binder binder, final BoundFieldInfo fieldInfo) {
        LinkedBindingBuilder linkedBinder = binder.withSource((Object)fieldInfo.field).bind(fieldInfo.boundKey);
        AnnotatedBindingBuilder binderUnsafe = (AnnotatedBindingBuilder)linkedBinder;
        if (BoundFieldModule.isTransparentProvider(fieldInfo.fieldType.getRawType())) {
            if (fieldInfo.bindAnnotation.lazy()) {
                binderUnsafe.toProvider((Provider)new Provider<Object>(){

                    public Object get() {
                        javax.inject.Provider provider = (javax.inject.Provider)BoundFieldModule.getFieldValue(fieldInfo);
                        return provider.get();
                    }
                });
            } else {
                javax.inject.Provider fieldValueUnsafe = (javax.inject.Provider)BoundFieldModule.getFieldValue(fieldInfo);
                binderUnsafe.toProvider(fieldValueUnsafe);
            }
        } else if (fieldInfo.bindAnnotation.lazy()) {
            binderUnsafe.toProvider((Provider)new Provider<Object>(){

                public Object get() {
                    return BoundFieldModule.getFieldValue(fieldInfo);
                }
            });
        } else {
            Object fieldValue = BoundFieldModule.getFieldValue(fieldInfo);
            if (fieldValue == null) {
                binderUnsafe.toProvider(Providers.of(null));
            } else {
                binderUnsafe.toInstance(fieldValue);
            }
        }
    }

    private static Object getFieldValue(BoundFieldInfo fieldInfo) {
        Object fieldValue = fieldInfo.getValue();
        if (fieldValue == null && !fieldInfo.allowsNull()) {
            if (BoundFieldModule.isTransparentProvider(fieldInfo.fieldType.getRawType())) {
                throw new NullBoundFieldValueException(new Message((Object)fieldInfo.field, "Binding to null is not allowed. Use Providers.of(null) if this is your intended behavior."));
            }
            throw new NullBoundFieldValueException(new Message((Object)fieldInfo.field, "Binding to null values is only allowed for fields that are annotated @Nullable."));
        }
        return fieldValue;
    }

    public void configure(Binder binder) {
        binder = binder.skipSources(new Class[]{BoundFieldModule.class});
        for (Message message : this.deferredBindingErrors) {
            binder.addError(message);
        }
        for (BoundFieldInfo fieldInfo : this.boundFields) {
            try {
                BoundFieldModule.bindField(binder, fieldInfo);
            }
            catch (NullBoundFieldValueException e) {
                binder.addError(e.message);
            }
        }
    }

    public static final class BoundFieldInfo {
        private final Object instance;
        private final Field field;
        private final TypeLiteral<?> fieldType;
        private final Bind bindAnnotation;
        private final Key<?> boundKey;

        private BoundFieldInfo(Object instance, Field field, Bind bindAnnotation, TypeLiteral<?> fieldType) throws BoundFieldException {
            this.instance = instance;
            this.field = field;
            this.fieldType = fieldType;
            this.bindAnnotation = bindAnnotation;
            field.setAccessible(true);
            Annotation bindingAnnotation = this.computeBindingAnnotation();
            Optional<TypeLiteral<?>> naturalType = this.computeNaturalFieldType();
            this.boundKey = this.computeKey(naturalType, bindingAnnotation);
            this.checkBindingIsAssignable(field, naturalType);
        }

        private void checkBindingIsAssignable(Field field, Optional<TypeLiteral<?>> naturalType) throws BoundFieldException {
            Class naturalRawType;
            Class boundRawType;
            if (naturalType.isPresent() && !(boundRawType = this.boundKey.getTypeLiteral().getRawType()).isAssignableFrom(naturalRawType = MoreTypes.canonicalizeForKey((TypeLiteral)((TypeLiteral)naturalType.get())).getRawType())) {
                throw new BoundFieldException(new Message((Object)field, String.format("Requested binding type \"%s\" is not assignable from field binding type \"%s\"", boundRawType.getName(), naturalRawType.getName())));
            }
        }

        public Field getField() {
            return this.field;
        }

        public TypeLiteral<?> getFieldType() {
            return this.fieldType;
        }

        public Bind getBindAnnotation() {
            return this.bindAnnotation;
        }

        public Key<?> getBoundKey() {
            return this.boundKey;
        }

        public Object getValue() {
            try {
                return this.field.get(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        private Annotation computeBindingAnnotation() throws BoundFieldException {
            Annotation found = null;
            for (Annotation annotation : InjectionPoint.getAnnotations((Field)this.field)) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!Annotations.isBindingAnnotation(annotationType)) continue;
                if (found != null) {
                    throw new BoundFieldException(new Message((Object)this.field, "More than one annotation is specified for this binding."));
                }
                found = annotation;
            }
            return found;
        }

        private Key<?> computeKey(Optional<TypeLiteral<?>> naturalType, Annotation bindingAnnotation) throws BoundFieldException {
            TypeLiteral<?> boundType = this.computeBoundType(naturalType);
            if (bindingAnnotation == null) {
                return Key.get(boundType);
            }
            return Key.get(boundType, (Annotation)bindingAnnotation);
        }

        private TypeLiteral<?> computeBoundType(Optional<TypeLiteral<?>> naturalType) throws BoundFieldException {
            Class<?> bindClass = this.bindAnnotation.to();
            if (bindClass == Bind.class) {
                Preconditions.checkState((naturalType != null ? 1 : 0) != 0);
                if (!naturalType.isPresent()) {
                    throw new BoundFieldException(new Message((Object)this.field, "Non parameterized Provider fields must have an explicit binding class via @Bind(to = Foo.class)"));
                }
                return (TypeLiteral)naturalType.get();
            }
            return TypeLiteral.get(bindClass);
        }

        private Optional<TypeLiteral<?>> computeNaturalFieldType() {
            if (BoundFieldModule.isTransparentProvider(this.fieldType.getRawType())) {
                Type providerType = this.fieldType.getType();
                if (providerType instanceof Class) {
                    return Optional.absent();
                }
                Preconditions.checkState((boolean)(providerType instanceof ParameterizedType));
                Type[] providerTypeArguments = ((ParameterizedType)providerType).getActualTypeArguments();
                Preconditions.checkState((providerTypeArguments.length == 1 ? 1 : 0) != 0);
                return Optional.of((Object)TypeLiteral.get((Type)providerTypeArguments[0]));
            }
            return Optional.of(this.fieldType);
        }

        private boolean allowsNull() {
            return !BoundFieldModule.isTransparentProvider(this.fieldType.getRawType()) && (Nullability.hasNullableAnnotation((Annotation[])this.field.getAnnotations()) || KotlinSupport.getInstance().isNullable(this.field));
        }
    }

    private static class NullBoundFieldValueException
    extends RuntimeException {
        private final Message message;

        NullBoundFieldValueException(Message message) {
            super(message.toString());
            this.message = message;
        }
    }

    private static class BoundFieldException
    extends Exception {
        private final Message message;

        BoundFieldException(Message message) {
            super(message.getMessage());
            this.message = message;
        }
    }

    public static class WithPermits
    extends AbstractModule {
        private final Object instance;

        protected WithPermits(Object instance) {
            this.instance = instance;
            Preconditions.checkState((((Object)((Object)this)).getClass().isAnonymousClass() && Arrays.stream(((Object)((Object)this)).getClass().getAnnotatedSuperclass().getAnnotations()).anyMatch(annotation -> annotation.annotationType().isAnnotationPresent(RestrictedBindingSource.Permit.class)) ? 1 : 0) != 0, (Object)"This class should only be used as a base class for an anonymous class with @RestrictedBindingSource.Permit annotations, for example: new @FooPermit BoundFieldModule.WithPermits(instance) {}.");
        }

        protected void configure() {
            this.install(BoundFieldModule.of(this.instance));
        }
    }
}

