/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractErrorHandler;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingBuilderImpl;
import com.google.inject.BindingImpl;
import com.google.inject.ConfigurationException;
import com.google.inject.ConstantBindingBuilderImpl;
import com.google.inject.ContextualCallable;
import com.google.inject.CreationException;
import com.google.inject.ErrorHandler;
import com.google.inject.ErrorMessages;
import com.google.inject.ExternalContext;
import com.google.inject.Injector;
import com.google.inject.InjectorImpl;
import com.google.inject.InternalContext;
import com.google.inject.InternalFactory;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProxyFactoryBuilder;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.Message;
import com.google.inject.spi.SourceProviders;
import com.google.inject.util.Annotations;
import com.google.inject.util.Objects;
import com.google.inject.util.StackTraceElements;
import com.google.inject.util.Stopwatch;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;

class BinderImpl
implements Binder {
    private static final Logger logger;
    final List<BindingBuilderImpl<?>> bindingBuilders = new ArrayList();
    final List<ConstantBindingBuilderImpl> constantBindingBuilders = new ArrayList<ConstantBindingBuilderImpl>();
    final Map<Class<? extends Annotation>, Scope> scopes = new HashMap<Class<? extends Annotation>, Scope>();
    final List<StaticInjection> staticInjections = new ArrayList<StaticInjection>();
    InjectorImpl injector;
    final Stage stage;
    final Collection<Message> errorMessages = new ArrayList<Message>();
    private static final InternalFactory<Injector> INJECTOR_FACTORY;
    private static final InternalFactory<Logger> LOGGER_FACTORY;
    final ProxyFactoryBuilder proxyFactoryBuilder;
    final List<CreationListener> creationListeners = new ArrayList<CreationListener>();
    final List<CreationListener> instanceInjectors = new ArrayList<CreationListener>();
    final Stopwatch stopwatch = new Stopwatch();
    private static Set<Class<?>> FORBIDDEN_TYPES;
    ErrorHandler configurationErrorHandler = new AbstractErrorHandler(){

        @Override
        public void handle(Object source, String message) {
            BinderImpl.this.add(new Message(source, message));
        }
    };

    public BinderImpl(Stage stage) {
        this.bindScope(Singleton.class, Scopes.SINGLETON);
        ((BindingBuilderImpl)this.bind(Injector.class)).to(INJECTOR_FACTORY);
        ((BindingBuilderImpl)this.bind(Logger.class)).to(LOGGER_FACTORY);
        ((BindingBuilderImpl)this.bind(Stage.class)).toInstance(stage);
        this.proxyFactoryBuilder = new ProxyFactoryBuilder();
        this.stage = stage;
    }

    public BinderImpl() {
        this(Stage.DEVELOPMENT);
    }

    @Override
    public Stage currentStage() {
        return this.stage;
    }

    @Override
    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        this.proxyFactoryBuilder.intercept(classMatcher, methodMatcher, interceptors);
    }

    @Override
    public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
        Scope existing;
        if (!Scopes.isScopeAnnotation(annotationType)) {
            this.addError(StackTraceElements.forType(annotationType), "Please annotate with @ScopeAnnotation.");
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.addError(StackTraceElements.forType(annotationType), "Please annotate with @Retention(RUNTIME). Bound at %s.", this.source());
        }
        if ((existing = this.scopes.get(Objects.nonNull(annotationType, "annotation type"))) != null) {
            this.addError(this.source(), "Scope %s is already bound to %s. Cannot bind %s.", existing, annotationType, scope);
        } else {
            this.scopes.put(annotationType, Objects.nonNull(scope, "scope"));
        }
    }

    public <T> BindingBuilderImpl<T> bind(Key<T> key) {
        BindingBuilderImpl<T> builder = new BindingBuilderImpl<T>(this, key, this.source());
        this.bindingBuilders.add(builder);
        return builder;
    }

    public <T> BindingBuilderImpl<T> bind(TypeLiteral<T> typeLiteral) {
        return this.bind((Key)Key.get(typeLiteral));
    }

    public <T> BindingBuilderImpl<T> bind(Class<T> clazz) {
        return this.bind((Key)Key.get(clazz));
    }

    @Override
    public ConstantBindingBuilderImpl bindConstant() {
        ConstantBindingBuilderImpl constantBuilder = new ConstantBindingBuilderImpl(this, this.source());
        this.constantBindingBuilders.add(constantBuilder);
        return constantBuilder;
    }

    @Override
    public void requestStaticInjection(Class<?> ... types) {
        this.staticInjections.add(new StaticInjection(this.source(), types));
    }

    @Override
    public void install(Module module) {
        module.configure(this);
    }

    @Override
    public void addError(String message, Object ... arguments) {
        this.configurationErrorHandler.handle(this.source(), message, arguments);
    }

    @Override
    public void addError(Throwable t) {
        Object source = this.source();
        String className = t.getClass().getSimpleName();
        String message = ErrorMessages.getRootMessage(t);
        String logMessage = String.format("An exception was caught and reported. Message: %s", message);
        logger.log(Level.INFO, logMessage, t);
        this.addError(source, "An exception was caught and reported. See log for details. Message: %s", message);
    }

    void addError(Object source, String message, Object ... arguments) {
        this.configurationErrorHandler.handle(source, message, arguments);
    }

    void addError(Object source, String message) {
        this.configurationErrorHandler.handle(source, message);
    }

    void add(Message errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    Injector createInjector() throws CreationException {
        this.stopwatch.resetAndLog(logger, "Configuration");
        HashMap bindings = new HashMap();
        this.injector = new InjectorImpl(this.proxyFactoryBuilder.create(), bindings, this.scopes);
        this.injector.setErrorHandler(this.configurationErrorHandler);
        this.createConstantBindings();
        ArrayList<ContextualCallable<Void>> preloaders = new ArrayList<ContextualCallable<Void>>();
        this.createBindings(preloaders);
        this.stopwatch.resetAndLog(logger, "Binding creation");
        this.injector.index();
        this.stopwatch.resetAndLog(logger, "Binding indexing");
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(this.injector);
        }
        this.stopwatch.resetAndLog(logger, "Validation");
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.createMemberInjectors(this.injector);
        }
        this.stopwatch.resetAndLog(logger, "Static validation");
        if (!this.errorMessages.isEmpty()) {
            throw new CreationException(this.errorMessages);
        }
        this.injector.setErrorHandler(new RuntimeErrorHandler());
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.runMemberInjectors(this.injector);
        }
        this.stopwatch.resetAndLog(logger, "Static member injection");
        for (CreationListener instanceInjector : this.instanceInjectors) {
            instanceInjector.notify(this.injector);
        }
        this.stopwatch.resetAndLog(logger, "Instance injection");
        this.runPreloaders(this.injector, preloaders);
        this.stopwatch.resetAndLog(logger, "Preloading");
        return this.injector;
    }

    private void runPreloaders(InjectorImpl injector, final List<ContextualCallable<Void>> preloaders) {
        injector.callInContext(new ContextualCallable<Void>(){

            @Override
            public Void call(InternalContext context) {
                for (ContextualCallable preloader : preloaders) {
                    preloader.call(context);
                }
                return null;
            }
        });
    }

    private void createBindings(List<ContextualCallable<Void>> preloaders) {
        for (BindingBuilderImpl<?> builder : this.bindingBuilders) {
            this.createBinding(builder, preloaders);
        }
    }

    private <T> void createBinding(BindingBuilderImpl<T> builder, List<ContextualCallable<Void>> preloaders) {
        boolean preload;
        Key<T> key = builder.getKey();
        InternalFactory<T> factory = builder.getInternalFactory(this.injector);
        BindingImpl<T> binding = BindingImpl.newInstance(this.injector, key, builder.getSource(), factory);
        this.putBinding(binding);
        boolean bl = preload = this.stage == Stage.PRODUCTION;
        if (builder.isSingletonScoped()) {
            if (preload || builder.shouldPreload()) {
                preloaders.add(new BindingPreloader(key, factory));
            }
        } else if (builder.shouldPreload()) {
            this.addError(builder.getSource(), "Preloading is only supported for singleton-scoped bindings.");
        }
    }

    private void createConstantBindings() {
        for (ConstantBindingBuilderImpl builder : this.constantBindingBuilders) {
            this.createConstantBinding(builder);
        }
    }

    private void createConstantBinding(ConstantBindingBuilderImpl builder) {
        if (builder.hasValue()) {
            this.putBinding(builder.createBinding(this.injector));
        } else {
            this.addError(builder.getSource(), "Missing constant value. Please call to(...).");
        }
    }

    private static Set<Class<?>> forbiddenTypes() {
        HashSet set = new HashSet();
        Collections.addAll(set, AbstractModule.class, Binder.class, Binding.class, Key.class, Module.class, Provider.class, Scope.class, TypeLiteral.class);
        return Collections.unmodifiableSet(set);
    }

    void putBinding(BindingImpl<?> binding) {
        Key<?> key = binding.getKey();
        Map<Key<?>, BindingImpl<?>> bindings = this.injector.internalBindings();
        Binding original = bindings.get(key);
        Class<?> rawType = key.getRawType();
        if (FORBIDDEN_TYPES.contains(rawType)) {
            this.addError(binding.getSource(), "Binding to core guice framework type is not allowed: %s.", rawType.getSimpleName());
            return;
        }
        if (bindings.containsKey(key)) {
            this.addError(binding.getSource(), "A binding to %s was already configured at %s.", key, original.getSource());
        } else {
            bindings.put(key, binding);
        }
    }

    Object source() {
        return SourceProviders.defaultSource();
    }

    static {
        SourceProviders.skip(BinderImpl.class);
        logger = Logger.getLogger(BinderImpl.class.getName());
        INJECTOR_FACTORY = new InternalFactory<Injector>(){

            @Override
            public Injector get(InternalContext context) {
                return context.getInjectorImpl();
            }

            public String toString() {
                return "Provider<Injector>";
            }
        };
        LOGGER_FACTORY = new InternalFactory<Logger>(){

            @Override
            public Logger get(InternalContext context) {
                Member member = context.getExternalContext().getMember();
                return member == null ? Logger.getAnonymousLogger() : Logger.getLogger(member.getDeclaringClass().getName());
            }

            public String toString() {
                return "Provider<Logger>";
            }
        };
        FORBIDDEN_TYPES = BinderImpl.forbiddenTypes();
    }

    static class BindingPreloader
    implements ContextualCallable<Void> {
        private final Key<?> key;
        private final InternalFactory<?> factory;

        public BindingPreloader(Key<?> key, InternalFactory<?> factory) {
            this.key = key;
            this.factory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call(InternalContext context) {
            ExternalContext<?> externalContext = ExternalContext.newInstance(null, this.key, context.getInjectorImpl());
            context.setExternalContext(externalContext);
            try {
                this.factory.get(context);
                Void void_ = null;
                return void_;
            }
            finally {
                context.setExternalContext(null);
            }
        }
    }

    class StaticInjection {
        final Object source;
        final Class<?>[] types;
        final List<InjectorImpl.SingleMemberInjector> memberInjectors = new ArrayList<InjectorImpl.SingleMemberInjector>();

        public StaticInjection(Object source, Class<?>[] types) {
            this.source = source;
            this.types = types;
        }

        void createMemberInjectors(final InjectorImpl injector) {
            injector.withDefaultSource(this.source, new Runnable(){

                @Override
                public void run() {
                    for (Class<?> clazz : StaticInjection.this.types) {
                        injector.addSingleInjectorsForFields(clazz.getDeclaredFields(), true, StaticInjection.this.memberInjectors);
                        injector.addSingleInjectorsForMethods(clazz.getDeclaredMethods(), true, StaticInjection.this.memberInjectors);
                    }
                }
            });
        }

        void runMemberInjectors(InjectorImpl injector) {
            injector.callInContext(new ContextualCallable<Void>(){

                @Override
                public Void call(InternalContext context) {
                    for (InjectorImpl.SingleMemberInjector injector : StaticInjection.this.memberInjectors) {
                        injector.inject(context, null);
                    }
                    return null;
                }
            });
        }
    }

    static class RuntimeErrorHandler
    extends AbstractErrorHandler {
        static ErrorHandler INSTANCE = new RuntimeErrorHandler();

        RuntimeErrorHandler() {
        }

        @Override
        public void handle(Object source, String message) {
            throw new ConfigurationException("Error at " + source + " " + message);
        }
    }

    static interface CreationListener {
        public void notify(InjectorImpl var1);
    }
}

