/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.Binding;
import com.google.inject.ConstantFactory;
import com.google.inject.InjectorImpl;
import com.google.inject.InternalFactory;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.util.ToStringBuilder;

class BindingImpl<T>
implements Binding<T> {
    final InjectorImpl injector;
    final Key<T> key;
    final Object source;
    final InternalFactory<? extends T> internalFactory;
    volatile Provider<T> provider;

    BindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory) {
        this.injector = injector;
        this.key = key;
        this.source = source;
        this.internalFactory = internalFactory;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Provider<T> getProvider() {
        if (this.provider == null) {
            this.provider = this.injector.getProvider(this.key);
        }
        return this.provider;
    }

    InternalFactory<? extends T> getInternalFactory() {
        return this.internalFactory;
    }

    static <T> BindingImpl<T> newInstance(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory) {
        return new BindingImpl<T>(injector, key, source, internalFactory);
    }

    boolean isConstant() {
        return this.internalFactory instanceof ConstantFactory;
    }

    public String toString() {
        return new ToStringBuilder(BindingImpl.class).add("key", this.key).add("source", this.source).add("provider", this.internalFactory).toString();
    }
}

