/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.BinderImpl;
import com.google.inject.BindingImpl;
import com.google.inject.ConstantFactory;
import com.google.inject.InjectorImpl;
import com.google.inject.Key;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.ConstantBindingBuilder;
import com.google.inject.util.Annotations;
import com.google.inject.util.Objects;
import com.google.inject.util.StackTraceElements;
import java.lang.annotation.Annotation;

class ConstantBindingBuilderImpl
implements AnnotatedConstantBindingBuilder,
ConstantBindingBuilder {
    BindingInfo<?> bindingInfo;
    Key.AnnotationStrategy annotationStrategy;
    final Object source;
    private BinderImpl binder;

    ConstantBindingBuilderImpl(BinderImpl binder, Object source) {
        this.binder = binder;
        this.source = source;
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Class<? extends Annotation> annotationType) {
        Objects.nonNull(annotationType, "annotation type");
        this.validateAnnotation(annotationType);
        this.annotationStrategy = Key.strategyFor(annotationType);
        return this;
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Annotation annotation) {
        Objects.nonNull(annotation, "annotation");
        this.validateAnnotation(annotation.annotationType());
        this.annotationStrategy = Key.strategyFor(annotation);
        return this;
    }

    void validateAnnotation(Class<? extends Annotation> annotationType) {
        if (this.annotationStrategy != null) {
            this.binder.addError(this.source, "More than one annotation is specified for this binding.");
            return;
        }
        boolean retainedAtRuntime = Annotations.isRetainedAtRuntime(annotationType);
        boolean bindingAnnotation = Key.isBindingAnnotation(annotationType);
        if (!retainedAtRuntime) {
            this.binder.addError(StackTraceElements.forType(annotationType), "Please annotate with @Retention(RUNTIME). Bound at %s.", this.source);
        }
        if (!bindingAnnotation) {
            this.binder.addError(StackTraceElements.forType(annotationType), "Please annotate with @BindingAnnotation. Bound at %s.", this.source);
        }
    }

    boolean hasValue() {
        return this.bindingInfo != null;
    }

    Object getSource() {
        return this.source;
    }

    @Override
    public void to(String value) {
        this.to(String.class, value);
    }

    @Override
    public void to(int value) {
        this.to(Integer.TYPE, value);
    }

    @Override
    public void to(long value) {
        this.to(Long.TYPE, value);
    }

    @Override
    public void to(boolean value) {
        this.to(Boolean.TYPE, value);
    }

    @Override
    public void to(double value) {
        this.to(Double.TYPE, value);
    }

    @Override
    public void to(float value) {
        this.to(Float.TYPE, Float.valueOf(value));
    }

    @Override
    public void to(short value) {
        this.to(Short.TYPE, value);
    }

    @Override
    public void to(char value) {
        this.to(Character.TYPE, Character.valueOf(value));
    }

    @Override
    public void to(Class<?> value) {
        this.to(Class.class, value);
    }

    @Override
    public <E extends Enum<E>> void to(E value) {
        this.to(value.getDeclaringClass(), value);
    }

    <T> void to(Class<T> type, T value) {
        if (this.bindingInfo != null) {
            this.binder.addError(this.source, "Constant value is set more than once.");
        } else {
            this.bindingInfo = new BindingInfo<T>(type, value, this.annotationStrategy, this.source);
        }
    }

    BindingImpl<?> createBinding(InjectorImpl injector) {
        return this.bindingInfo.createBinding(injector);
    }

    private static class BindingInfo<T> {
        final Class<T> type;
        final T value;
        final Key.AnnotationStrategy annotationStrategy;
        final Object source;

        BindingInfo(Class<T> type, T value, Key.AnnotationStrategy annotationStrategy, Object source) {
            this.type = type;
            this.value = value;
            this.annotationStrategy = annotationStrategy;
            this.source = source;
        }

        BindingImpl<T> createBinding(InjectorImpl injector) {
            Key<T> key = Key.get(this.type, this.annotationStrategy);
            ConstantFactory<T> factory = new ConstantFactory<T>(this.value);
            return BindingImpl.newInstance(injector, key, this.source, factory);
        }
    }
}

