/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.ConstructionContext;
import com.google.inject.ConstructionProxy;
import com.google.inject.Inject;
import com.google.inject.InjectorImpl;
import com.google.inject.InternalContext;
import com.google.inject.util.StackTraceElements;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

class ConstructorInjector<T> {
    final Class<T> implementation;
    final InjectorImpl.SingleMemberInjector[] memberInjectors;
    final InjectorImpl.SingleParameterInjector<?>[] parameterInjectors;
    final ConstructionProxy<T> constructionProxy;

    ConstructorInjector(InjectorImpl injector, Class<T> implementation) {
        this.implementation = implementation;
        Constructor<T> constructor = this.findConstructorIn(injector, implementation);
        this.parameterInjectors = this.createParameterInjector(injector, constructor);
        this.memberInjectors = injector.injectors.get(implementation).toArray(new InjectorImpl.SingleMemberInjector[0]);
        this.constructionProxy = injector.constructionProxyFactory.get(constructor);
    }

    private ConstructorInjector() {
        this.implementation = null;
        this.memberInjectors = null;
        this.parameterInjectors = null;
        this.constructionProxy = null;
    }

    InjectorImpl.SingleParameterInjector<?>[] createParameterInjector(InjectorImpl injector, Constructor<T> constructor) {
        try {
            return constructor.getParameterTypes().length == 0 ? null : injector.getParametersInjectors(constructor, constructor.getParameterAnnotations(), constructor.getGenericParameterTypes());
        }
        catch (InjectorImpl.MissingDependencyException e) {
            e.handle(injector.errorHandler);
            return null;
        }
    }

    private Constructor<T> findConstructorIn(InjectorImpl injector, Class<T> implementation) {
        Constructor<?>[] constructors;
        Constructor<?> found = null;
        for (Constructor<?> constructor : constructors = implementation.getDeclaredConstructors()) {
            Inject inject = constructor.getAnnotation(Inject.class);
            if (inject == null) continue;
            if (inject.optional()) {
                injector.errorHandler.handle(StackTraceElements.forMember(constructor), "@Inject(optional=true) is not allowed on constructors.");
            }
            if (found != null) {
                injector.errorHandler.handle(StackTraceElements.forMember(found), "Found more than one constructor annotated with @Inject. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor.");
                return InjectorImpl.invalidConstructor();
            }
            found = constructor;
        }
        if (found != null) {
            return found;
        }
        try {
            return implementation.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            injector.errorHandler.handle(StackTraceElements.forMember(implementation.getDeclaredConstructors()[0]), "Could not find a suitable constructor in %s. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor.", implementation);
            return InjectorImpl.invalidConstructor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(InternalContext context, Class<?> expectedType) {
        ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            return constructionContext.createProxy(expectedType);
        }
        Object t = constructionContext.getCurrentReference();
        if (t != null) {
            return t;
        }
        try {
            constructionContext.startConstruction();
            try {
                Object[] objectArray = InjectorImpl.getParameters(context, this.parameterInjectors);
                t = this.constructionProxy.newInstance(objectArray);
                constructionContext.setProxyDelegates(t);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t);
            for (InjectorImpl.SingleMemberInjector injector : this.memberInjectors) {
                injector.inject(context, t);
            }
            Object t2 = t;
            return t2;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }

    static <T> ConstructorInjector<T> invalidConstructor() {
        return new ConstructorInjector<T>(){

            @Override
            Object construct(InternalContext context, Class<?> expectedType) {
                throw new UnsupportedOperationException();
            }

            public T get() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

