/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.spi.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;

public class CreationException
extends RuntimeException {
    final List<Message> errorMessages;

    public CreationException(Collection<Message> errorMessages) {
        this.errorMessages = new ArrayList<Message>(errorMessages);
        Collections.sort(this.errorMessages, new Comparator<Message>(){

            @Override
            public int compare(Message a, Message b) {
                return a.getSourceString().compareTo(b.getSourceString());
            }
        });
    }

    @Override
    public String getMessage() {
        return CreationException.createErrorMessage(this.errorMessages);
    }

    private static String createErrorMessage(Collection<Message> errorMessages) {
        Formatter fmt = new Formatter().format("Guice configuration errors:%n%n", new Object[0]);
        int index = 1;
        for (Message errorMessage : errorMessages) {
            fmt.format("%s) Error at %s:%n", index++, errorMessage.getSourceString()).format(" %s%n%n", errorMessage.getMessage());
        }
        return fmt.format("%s error[s]", errorMessages.size()).toString();
    }

    public Collection<Message> getErrorMessages() {
        return Collections.unmodifiableCollection(this.errorMessages);
    }
}

