/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.ConstructionProxy;
import com.google.inject.ConstructionProxyFactory;
import com.google.inject.cglib.reflect.FastClass;
import com.google.inject.cglib.reflect.FastConstructor;
import com.google.inject.util.GuiceFastClass;
import com.google.inject.util.Objects;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

class DefaultConstructionProxyFactory
implements ConstructionProxyFactory {
    DefaultConstructionProxyFactory() {
    }

    @Override
    public <T> ConstructionProxy<T> get(final Constructor<T> constructor) {
        if (Modifier.isPrivate(constructor.getModifiers()) || Modifier.isProtected(constructor.getModifiers())) {
            constructor.setAccessible(true);
            return new ConstructionProxy<T>(){

                @Override
                public T newInstance(Object ... arguments) throws InvocationTargetException {
                    Objects.assertNoNulls(arguments);
                    try {
                        return constructor.newInstance(arguments);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            };
        }
        Class<T> classToConstruct = constructor.getDeclaringClass();
        FastClass fastClass = GuiceFastClass.create(classToConstruct);
        final FastConstructor fastConstructor = fastClass.getConstructor(constructor);
        return new ConstructionProxy<T>(){

            @Override
            public T newInstance(Object ... arguments) throws InvocationTargetException {
                Objects.assertNoNulls(arguments);
                return fastConstructor.newInstance(arguments);
            }
        };
    }
}

