/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.matcher.Matcher;
import com.google.inject.util.Objects;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

class MethodAspect {
    final Matcher<? super Class<?>> classMatcher;
    final Matcher<? super Method> methodMatcher;
    final List<MethodInterceptor> interceptors;

    MethodAspect(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        this.classMatcher = Objects.nonNull(classMatcher, "class matcher");
        this.methodMatcher = Objects.nonNull(methodMatcher, "method matcher");
        this.interceptors = Arrays.asList((Object[])Objects.nonNull(interceptors, "interceptors"));
    }

    boolean matches(Class<?> clazz) {
        return this.classMatcher.matches(clazz);
    }

    boolean matches(Method method) {
        return this.methodMatcher.matches(method);
    }

    List<MethodInterceptor> interceptors() {
        return this.interceptors;
    }
}

