/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.ConstructionProxy;
import com.google.inject.ConstructionProxyFactory;
import com.google.inject.DefaultConstructionProxyFactory;
import com.google.inject.InterceptorStackCallback;
import com.google.inject.MethodAspect;
import com.google.inject.Provider;
import com.google.inject.cglib.proxy.Callback;
import com.google.inject.cglib.proxy.CallbackFilter;
import com.google.inject.cglib.proxy.Enhancer;
import com.google.inject.cglib.proxy.MethodInterceptor;
import com.google.inject.cglib.proxy.NoOp;
import com.google.inject.cglib.reflect.FastClass;
import com.google.inject.cglib.reflect.FastConstructor;
import com.google.inject.util.GuiceFastClass;
import com.google.inject.util.GuiceNamingPolicy;
import com.google.inject.util.Objects;
import com.google.inject.util.ReferenceCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ProxyFactory
implements ConstructionProxyFactory {
    final List<MethodAspect> methodAspects;
    final ConstructionProxyFactory defaultFactory = new DefaultConstructionProxyFactory();
    Map<Constructor<?>, ConstructionProxy<?>> constructionProxies = new ReferenceCache<Constructor<?>, ConstructionProxy<?>>(){

        @Override
        protected ConstructionProxy<?> create(Constructor<?> constructor) {
            return ProxyFactory.this.createConstructionProxy(constructor);
        }
    };

    ProxyFactory(List<MethodAspect> methodAspects) {
        this.methodAspects = methodAspects;
    }

    public <T> Provider<T> getFactory(Class<T> type) throws NoSuchMethodException {
        final ConstructionProxy<T> constructionProxy = this.createConstructionProxy(type.getDeclaredConstructor(new Class[0]));
        return new Provider<T>(){

            @Override
            public T get() {
                try {
                    return constructionProxy.newInstance(new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    <T> ConstructionProxy<T> createConstructionProxy(Constructor<T> constructor) {
        Class<T> declaringClass = constructor.getDeclaringClass();
        ArrayList<MethodAspect> applicableAspects = new ArrayList<MethodAspect>();
        for (MethodAspect methodAspect : this.methodAspects) {
            if (!methodAspect.matches(declaringClass)) continue;
            applicableAspects.add(methodAspect);
        }
        if (applicableAspects.isEmpty()) {
            return this.defaultFactory.get(constructor);
        }
        ArrayList methods = new ArrayList();
        Enhancer.getMethods(declaringClass, null, methods);
        final HashMap<Method, Integer> indices = new HashMap<Method, Integer>();
        ArrayList<MethodInterceptorsPair> methodInterceptorsPairs = new ArrayList<MethodInterceptorsPair>();
        for (int i = 0; i < methods.size(); ++i) {
            Method method = (Method)methods.get(i);
            methodInterceptorsPairs.add(new MethodInterceptorsPair(method));
            indices.put(method, i);
        }
        boolean anyMatched = false;
        for (MethodAspect methodAspect : applicableAspects) {
            for (MethodInterceptorsPair pair : methodInterceptorsPairs) {
                if (!methodAspect.matches(pair.method)) continue;
                pair.addAll(methodAspect.interceptors());
                anyMatched = true;
            }
        }
        if (!anyMatched) {
            return this.defaultFactory.get(constructor);
        }
        Callback[] callbacks = new Callback[methods.size()];
        Class[] callbackTypes = new Class[methods.size()];
        for (int i = 0; i < methods.size(); ++i) {
            MethodInterceptorsPair pair;
            pair = (MethodInterceptorsPair)methodInterceptorsPairs.get(i);
            if (!pair.hasInterceptors()) {
                callbacks[i] = NoOp.INSTANCE;
                callbackTypes[i] = NoOp.class;
                continue;
            }
            callbacks[i] = new InterceptorStackCallback(pair.method, pair.interceptors);
            callbackTypes[i] = MethodInterceptor.class;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(declaringClass);
        enhancer.setUseCache(false);
        enhancer.setCallbackFilter(new CallbackFilter(){

            @Override
            public int accept(Method method) {
                return (Integer)indices.get(method);
            }
        });
        enhancer.setCallbackTypes(callbackTypes);
        enhancer.setUseFactory(false);
        enhancer.setNamingPolicy(new GuiceNamingPolicy());
        Class proxied = enhancer.createClass();
        Enhancer.registerStaticCallbacks(proxied, callbacks);
        return this.createConstructionProxy(proxied, constructor.getParameterTypes());
    }

    <T> ConstructionProxy<T> createConstructionProxy(Class<?> clazz, Class[] parameterTypes) {
        FastClass fastClass = GuiceFastClass.create(clazz);
        final FastConstructor fastConstructor = fastClass.getConstructor(parameterTypes);
        return new ConstructionProxy<T>(){

            @Override
            public T newInstance(Object ... arguments) throws InvocationTargetException {
                Objects.assertNoNulls(arguments);
                return fastConstructor.newInstance(arguments);
            }
        };
    }

    @Override
    public <T> ConstructionProxy<T> get(Constructor<T> constructor) {
        return this.constructionProxies.get(constructor);
    }

    static class MethodInterceptorsPair {
        final Method method;
        List<org.aopalliance.intercept.MethodInterceptor> interceptors;

        public MethodInterceptorsPair(Method method) {
            this.method = method;
        }

        void addAll(List<org.aopalliance.intercept.MethodInterceptor> interceptors) {
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<org.aopalliance.intercept.MethodInterceptor>();
            }
            this.interceptors.addAll(interceptors);
        }

        boolean hasInterceptors() {
            return this.interceptors != null;
        }
    }
}

