/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.jndi;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.naming.Context;
import javax.naming.NamingException;

public class JndiIntegration {
    private JndiIntegration() {
    }

    public static <T> Provider<T> fromJndi(Class<T> type, String name) {
        return new JndiProvider<T>(type, name);
    }

    static class JndiProvider<T>
    implements Provider<T> {
        @Inject
        Context context;
        final Class<T> type;
        final String name;

        public JndiProvider(Class<T> type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public T get() {
            try {
                return this.type.cast(this.context.lookup(this.name));
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

