/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.matcher;

import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.util.Objects;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

public class Matchers {
    static Matcher<Object> ANY = new AbstractMatcher<Object>(){

        @Override
        public boolean matches(Object o) {
            return true;
        }

        public String toString() {
            return "any()";
        }
    };

    private Matchers() {
    }

    public static Matcher<Object> any() {
        return ANY;
    }

    public static <T> Matcher<T> not(final Matcher<? super T> p) {
        Objects.nonNull(p, "p");
        return new AbstractMatcher<T>(){

            @Override
            public boolean matches(T t) {
                return !p.matches(t);
            }

            public String toString() {
                return "not(" + p + ")";
            }
        };
    }

    public static Matcher<AnnotatedElement> annotatedWith(final Class<? extends Annotation> annotationType) {
        Objects.nonNull(annotationType, "annotation type");
        return new AbstractMatcher<AnnotatedElement>(){

            @Override
            public boolean matches(AnnotatedElement element) {
                Object annotation = element.getAnnotation(annotationType);
                return annotation != null;
            }

            public String toString() {
                return "annotatedWith(" + annotationType.getSimpleName() + ".class)";
            }
        };
    }

    public static Matcher<AnnotatedElement> annotatedWith(final Annotation annotation) {
        Objects.nonNull(annotation, "annotation");
        return new AbstractMatcher<AnnotatedElement>(){

            @Override
            public boolean matches(AnnotatedElement element) {
                Annotation fromElement = element.getAnnotation(annotation.annotationType());
                return fromElement != null && ((Object)annotation).equals(fromElement);
            }

            public String toString() {
                return "annotatedWith(" + annotation + ")";
            }
        };
    }

    public static Matcher<Class> subclassesOf(final Class<?> superclass) {
        Objects.nonNull(superclass, "superclass");
        return new AbstractMatcher<Class>(){

            @Override
            public boolean matches(Class subclass) {
                return superclass.isAssignableFrom(subclass);
            }

            public String toString() {
                return "subclassesOf(" + superclass.getSimpleName() + ".class)";
            }
        };
    }

    public static Matcher<Object> only(final Object o) {
        Objects.nonNull(o, "o");
        return new AbstractMatcher<Object>(){

            @Override
            public boolean matches(Object other) {
                return o.equals(other);
            }

            public String toString() {
                return "only(" + o + ")";
            }
        };
    }

    public static Matcher<Object> identicalTo(final Object o) {
        Objects.nonNull(o, "o");
        return new AbstractMatcher<Object>(){

            @Override
            public boolean matches(Object other) {
                return o == other;
            }

            public String toString() {
                return "identicalTo(" + o + ")";
            }
        };
    }

    public static Matcher<Class> inPackage(final Package p) {
        Objects.nonNull(p, "package");
        return new AbstractMatcher<Class>(){

            @Override
            public boolean matches(Class c) {
                return c.getPackage().equals(p);
            }

            public String toString() {
                return "package(" + p.getName() + ")";
            }
        };
    }

    public static Matcher<Method> returns(final Matcher<? super Class<?>> returnType) {
        Objects.nonNull(returnType, "return type matcher");
        return new AbstractMatcher<Method>(){

            @Override
            public boolean matches(Method m) {
                return returnType.matches(m.getReturnType());
            }

            public String toString() {
                return "returns(" + returnType + ")";
            }
        };
    }
}

