/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.spi.SourceProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SourceProviders {
    public static final Object UNKNOWN_SOURCE = "[unknown source]";
    static final SourceProvider DEFAULT_INSTANCE = new StacktraceSourceProvider();
    static Set<String> skippedClassNames = Collections.emptySet();
    static ThreadLocal<SourceProvider[]> localSourceProvider;

    private SourceProviders() {
    }

    public static synchronized void skip(Class<?> clazz) {
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(skippedClassNames);
        copy.add(clazz.getName());
        skippedClassNames = Collections.unmodifiableSet(copy);
    }

    public static synchronized Set<String> getSkippedClassNames() {
        return skippedClassNames;
    }

    public static Object defaultSource() {
        return localSourceProvider.get()[0].source();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withDefault(SourceProvider sourceProvider, Runnable r) {
        SourceProvider[] holder = localSourceProvider.get();
        SourceProvider previous = holder[0];
        try {
            holder[0] = sourceProvider;
            r.run();
        }
        finally {
            holder[0] = previous;
        }
    }

    static {
        SourceProviders.skip(SourceProviders.class);
        SourceProviders.skip(StacktraceSourceProvider.class);
        localSourceProvider = new ThreadLocal<SourceProvider[]>(){

            @Override
            protected SourceProvider[] initialValue() {
                return new SourceProvider[]{DEFAULT_INSTANCE};
            }
        };
    }

    static class StacktraceSourceProvider
    implements SourceProvider {
        StacktraceSourceProvider() {
        }

        @Override
        public Object source() {
            Set<String> skippedClassNames = SourceProviders.getSkippedClassNames();
            for (StackTraceElement element : new Throwable().getStackTrace()) {
                String className = element.getClassName();
                if (skippedClassNames.contains(className)) continue;
                return element;
            }
            throw new AssertionError();
        }
    }
}

