/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.inject.util.ReferenceMap;
import com.google.inject.util.ReferenceType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractReferenceCache<K, V>
extends ReferenceMap<K, V> {
    private static final long serialVersionUID = 0L;
    transient ConcurrentMap<Object, FutureValue<V>> futures = new ConcurrentHashMap<Object, FutureValue<V>>();

    AbstractReferenceCache(ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        super(keyReferenceType, valueReferenceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V internalCreate(K key) {
        FutureValue futureValue = new FutureValue();
        Object keyReference = this.referenceKey(key);
        FutureValue previous = this.futures.putIfAbsent(keyReference, futureValue);
        if (previous == null) {
            try {
                Object value = this.internalGet(key);
                if (value != null) {
                    futureValue.setValue(value);
                    Object v = value;
                    return v;
                }
                try {
                    value = this.create(futureValue, key);
                    if (value == null) {
                        throw new NullPointerException("create() returned null for: " + key);
                    }
                    futureValue.setValue(value);
                }
                catch (Throwable t) {
                    futureValue.setThrowable(t);
                    AbstractReferenceCache.rethrow(t);
                }
                this.putStrategy().execute(this, keyReference, this.referenceValue(keyReference, value));
                Object v = value;
                return v;
            }
            finally {
                this.futures.remove(keyReference);
            }
        }
        if (previous.winningThread() == Thread.currentThread()) {
            throw new RuntimeException("Circular reference: " + key);
        }
        return previous.get();
    }

    private static void rethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    abstract V create(FutureValue<V> var1, K var2);

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        return value == null ? this.internalCreate(key) : value;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.futures = new ConcurrentHashMap<Object, FutureValue<V>>();
    }

    static class FutureValue<V> {
        private boolean set = false;
        private V value;
        private Throwable t;
        private final Thread winningThread = Thread.currentThread();

        FutureValue() {
        }

        Thread winningThread() {
            return this.winningThread;
        }

        V get() {
            boolean interrupted;
            if (!this.set && (interrupted = this.waitUntilSet())) {
                Thread.currentThread().interrupt();
            }
            if (this.t != null) {
                AbstractReferenceCache.rethrow(this.t);
            }
            return this.value;
        }

        private synchronized boolean waitUntilSet() {
            boolean interrupted = false;
            while (!this.set) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            return interrupted;
        }

        synchronized void setValue(V v) {
            this.set();
            this.value = v;
        }

        synchronized void setThrowable(Throwable t) {
            this.set();
            this.t = t;
        }

        private void set() {
            if (this.set) {
                throw new IllegalStateException("Value is already set.");
            }
            this.set = true;
            this.notifyAll();
        }
    }
}

