/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class BinderTest
extends TestCase {
    private final Logger loggerToWatch = Logger.getLogger(Guice.class.getName());
    private final List<LogRecord> logRecords = Lists.newArrayList();
    private final Handler fakeHandler = new Handler(){

        @Override
        public void publish(LogRecord logRecord) {
            BinderTest.this.logRecords.add(logRecord);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    Provider<Foo> fooProvider;

    protected void setUp() throws Exception {
        super.setUp();
        this.loggerToWatch.addHandler(this.fakeHandler);
    }

    protected void tearDown() throws Exception {
        this.loggerToWatch.removeHandler(this.fakeHandler);
        super.tearDown();
    }

    public void testProviderFromBinder() {
        Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                BinderTest.this.fooProvider = binder.getProvider(Foo.class);
                try {
                    BinderTest.this.fooProvider.get();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }});
        BinderTest.assertNotNull((Object)this.fooProvider.get());
    }

    public void testMissingBindings() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    this.getProvider(Runnable.class);
                    this.bind(Comparator.class);
                    this.requireBinding(Key.get((TypeLiteral)new TypeLiteral<Callable<String>>(){}));
                    this.bind(Date.class).annotatedWith((Annotation)Names.named((String)"date"));
                }
            }});
        }
        catch (CreationException e) {
            BinderTest.assertEquals((int)4, (int)e.getErrorMessages().size());
            String segment1 = "No implementation for " + Comparator.class.getName() + " was bound.";
            String segment2 = "No implementation for java.util.Date annotated with @" + Named.class.getName() + "(value=date) was bound.";
            String segment3 = "No implementation for java.lang.Runnable was bound.";
            String segment4 = " No implementation for java.util.concurrent.Callable<java.lang.String> was bound.";
            String atSegment = "at " + ((Object)((Object)this)).getClass().getName();
            String sourceFileName = Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass());
            if (Asserts.isIncludeStackTraceOff()) {
                Asserts.assertContains(e.getMessage(), segment1, atSegment, sourceFileName, segment2, atSegment, sourceFileName, segment3, atSegment, sourceFileName, segment4, atSegment, sourceFileName);
            }
            Asserts.assertContains(e.getMessage(), segment3, atSegment, sourceFileName, segment1, atSegment, sourceFileName, segment4, atSegment, sourceFileName, segment2, atSegment, sourceFileName);
        }
    }

    public void testMissingDependency() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    this.bind(NeedsRunnable.class);
                }
            }});
        }
        catch (CreationException e) {
            BinderTest.assertEquals((int)1, (int)e.getErrorMessages().size());
            Asserts.assertContains(e.getMessage(), "No implementation for java.lang.Runnable was bound.", "for field at " + NeedsRunnable.class.getName(), ".runnable(BinderTest.java:", "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testDanglingConstantBinding() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    this.bindConstant();
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Missing constant value. Please call to(...).", "at " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public void testRecursiveBinding() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    this.bind(Runnable.class).to(Runnable.class);
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Binding points to itself.", "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testBindingNullConstant() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    String none = null;
                    this.bindConstant().annotatedWith((Annotation)Names.named((String)"nullOne")).to(none);
                    this.bind(String.class).annotatedWith((Annotation)Names.named((String)"nullTwo")).toInstance(none);
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Binding to null instances is not allowed. Use toProvider(Providers.of(null))", "2) Binding to null instances is not allowed. Use toProvider(Providers.of(null))");
        }
    }

    public void testToStringOnBinderApi() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    TestCase.assertEquals((String)"Binder", (String)this.binder().toString());
                    TestCase.assertEquals((String)"Provider<java.lang.Integer>", (String)this.getProvider(Integer.class).toString());
                    TestCase.assertEquals((String)"Provider<java.util.List<java.lang.String>>", (String)this.getProvider(Key.get((TypeLiteral)new TypeLiteral<List<String>>(){})).toString());
                    TestCase.assertEquals((String)"BindingBuilder<java.lang.Integer>", (String)this.bind(Integer.class).toString());
                    TestCase.assertEquals((String)"BindingBuilder<java.lang.Integer>", (String)this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"a")).toString());
                    TestCase.assertEquals((String)"ConstantBindingBuilder", (String)this.bindConstant().toString());
                    TestCase.assertEquals((String)"ConstantBindingBuilder", (String)this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")).toString());
                    TestCase.assertEquals((String)"AnnotatedElementBuilder", (String)this.binder().newPrivateBinder().expose(Integer.class).toString());
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    public void testNothingIsSerializableInBinderApi() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    try {
                        Asserts.assertNotSerializable(this.binder());
                        Asserts.assertNotSerializable(this.getProvider(Integer.class));
                        Asserts.assertNotSerializable(this.getProvider(Key.get((TypeLiteral)new TypeLiteral<List<String>>(){})));
                        Asserts.assertNotSerializable(this.bind(Integer.class));
                        Asserts.assertNotSerializable(this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"a")));
                        Asserts.assertNotSerializable(this.bindConstant());
                        Asserts.assertNotSerializable(this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")));
                    }
                    catch (IOException e) {
                        TestCase.fail((String)e.getMessage());
                    }
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    public void testArrayTypeCanonicalization() {
        final String[] strings = new String[]{"A"};
        final Integer[] integers = new Integer[]{1};
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String[].class).toInstance((Object)strings);
                this.bind((TypeLiteral)new TypeLiteral<Integer[]>(){}).toInstance((Object)integers);
            }
        }});
        BinderTest.assertSame((Object)integers, (Object)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Integer[]>(){})));
        BinderTest.assertSame((Object)integers, (Object)injector.getInstance((Key)new Key<Integer[]>(){}));
        BinderTest.assertSame((Object)integers, (Object)injector.getInstance(Integer[].class));
        BinderTest.assertSame((Object)strings, (Object)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<String[]>(){})));
        BinderTest.assertSame((Object)strings, (Object)injector.getInstance((Key)new Key<String[]>(){}));
        BinderTest.assertSame((Object)strings, (Object)injector.getInstance(String[].class));
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(String[].class).toInstance((Object)new String[]{"A"});
                    this.bind((TypeLiteral)new TypeLiteral<String[]>(){}).toInstance((Object)new String[]{"B"});
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) A binding to java.lang.String[] was already configured at " + ((Object)((Object)this)).getClass().getName(), "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
            Asserts.assertContains(expected.getMessage(), "1 error");
        }
        injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String[].class).toInstance((Object)strings);
                this.bind((TypeLiteral)new TypeLiteral<String[]>(){}).toInstance((Object)strings);
            }
        }});
        BinderTest.assertSame((Object)strings, (Object)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<String[]>(){})));
        BinderTest.assertSame((Object)strings, (Object)injector.getInstance((Key)new Key<String[]>(){}));
        BinderTest.assertSame((Object)strings, (Object)injector.getInstance(String[].class));
    }

    public void testSettingBindingTwice() {
        try {
            Guice.createInjector((Module[])new Module[]{new ParentModule()});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) A binding to java.lang.String was already configured at " + ConstantModule.class.getName(), Asserts.asModuleChain(ParentModule.class, FooModule.class, ConstantModule.class), "at " + ConstantModule.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(ParentModule.class, BarModule.class, ConstantModule.class));
            Asserts.assertContains(expected.getMessage(), "1 error");
        }
    }

    public void testSettingAtImplementedByTwice() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(HasImplementedBy1.class);
                    this.bind(HasImplementedBy1.class).toInstance((Object)new HasImplementedBy1(){});
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            expected.printStackTrace();
            Asserts.assertContains(expected.getMessage(), "1) A binding to " + HasImplementedBy1.class.getName() + " was already configured at " + ((Object)((Object)this)).getClass().getName(), "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
            Asserts.assertContains(expected.getMessage(), "1 error");
        }
    }

    public void testJitDependencyDoesntBlockOtherExplicitBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(HasImplementedByThatNeedsAnotherImplementedBy.class);
                this.bind(HasImplementedBy1.class).toInstance((Object)new HasImplementedBy1(){});
            }
        }});
        injector.getAllBindings();
        BinderTest.assertFalse((boolean)(injector.getInstance(HasImplementedBy1.class) instanceof ImplementsHasImplementedBy1));
    }

    public void testJitDependencyCanUseExplicitDependencies() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(HasImplementedByThatWantsExplicit.class);
                this.bind(JustAnInterface.class).toInstance((Object)new JustAnInterface(){});
            }
        }});
    }

    public void testUntargettedBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(HasProvidedBy1.class);
                this.bind(HasImplementedBy1.class);
                this.bind(HasProvidedBy2.class);
                this.bind(HasImplementedBy2.class);
                this.bind(JustAClass.class);
            }
        }});
        BinderTest.assertNotNull((Object)injector.getInstance(HasProvidedBy1.class));
        BinderTest.assertNotNull((Object)injector.getInstance(HasImplementedBy1.class));
        BinderTest.assertNotSame(HasProvidedBy2.class, ((HasProvidedBy2)injector.getInstance(HasProvidedBy2.class)).getClass());
        BinderTest.assertSame(ExtendsHasImplementedBy2.class, ((HasImplementedBy2)injector.getInstance(HasImplementedBy2.class)).getClass());
        BinderTest.assertSame(JustAClass.class, ((JustAClass)injector.getInstance(JustAClass.class)).getClass());
    }

    public void testPartialInjectorGetInstance() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            injector.getInstance(MissingParameter.class);
            BinderTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Could not find a suitable constructor in " + NoInjectConstructor.class.getName(), "for the 1st parameter of " + MissingParameter.class.getName() + ".<init>(BinderTest.java:");
        }
    }

    public void testUserReportedError() {
        final Message message = new Message(((Object)((Object)this)).getClass(), "Whoops!");
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.addError(message);
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            BinderTest.assertSame((Object)message, (Object)Iterables.getOnlyElement((Iterable)expected.getErrorMessages()));
        }
    }

    public void testUserReportedErrorsAreAlsoLogged() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.addError(new Message("Whoops!", (Throwable)new IllegalArgumentException()));
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
        LogRecord logRecord = (LogRecord)Iterables.getOnlyElement(this.logRecords);
        Asserts.assertContains(logRecord.getMessage(), "An exception was caught and reported. Message: java.lang.IllegalArgumentException");
    }

    public void testBindingToProvider() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind((TypeLiteral)new TypeLiteral<Provider<String>>(){}).toInstance((Object)Providers.of((Object)"A"));
                }
            }});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Binding to Provider is not allowed.", "at " + BinderTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testCannotBindToGuiceTypes() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterCoreModule()});
            BinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Binding to core guice framework type is not allowed: AbstractModule.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Binder.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Binding.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Injector.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Key.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Module.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to Provider is not allowed.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Scope.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Stage.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: TypeLiteral.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class), "Binding to core guice framework type is not allowed: Key.", "at " + InnerCoreModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterCoreModule.class, InnerCoreModule.class));
        }
    }

    public void testInjectRawProvider() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(Provider.class);
            BinderTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Cannot inject a Provider that has no type parameter", "while locating " + Provider.class.getName());
        }
    }

    static enum Roshambo {
        ROCK,
        SCISSORS,
        PAPER;

    }

    static interface JustAnInterface {
    }

    static class ImplementsHasImplementedByThatWantsExplicit
    implements HasImplementedByThatWantsExplicit {
        @Inject
        ImplementsHasImplementedByThatWantsExplicit(JustAnInterface jai) {
        }
    }

    @ImplementedBy(value=ImplementsHasImplementedByThatWantsExplicit.class)
    static interface HasImplementedByThatWantsExplicit {
    }

    static class ImplementsHasImplementedByThatNeedsAnotherImplementedBy
    implements HasImplementedByThatNeedsAnotherImplementedBy {
        @Inject
        ImplementsHasImplementedByThatNeedsAnotherImplementedBy(HasImplementedBy1 h1n1) {
        }
    }

    @ImplementedBy(value=ImplementsHasImplementedByThatNeedsAnotherImplementedBy.class)
    static interface HasImplementedByThatNeedsAnotherImplementedBy {
    }

    static class JustAClass {
        JustAClass() {
        }
    }

    static class ExtendsHasImplementedBy2
    extends HasImplementedBy2 {
        ExtendsHasImplementedBy2() {
        }
    }

    @ImplementedBy(value=ExtendsHasImplementedBy2.class)
    static class HasImplementedBy2 {
        HasImplementedBy2() {
        }
    }

    static class HasProvidedBy2Provider
    implements Provider<HasProvidedBy2> {
        HasProvidedBy2Provider() {
        }

        public HasProvidedBy2 get() {
            return new HasProvidedBy2(){};
        }
    }

    @ProvidedBy(value=HasProvidedBy2Provider.class)
    static class HasProvidedBy2 {
        HasProvidedBy2() {
        }
    }

    static class ImplementsHasImplementedBy1
    implements HasImplementedBy1 {
        ImplementsHasImplementedBy1() {
        }
    }

    @ImplementedBy(value=ImplementsHasImplementedBy1.class)
    static interface HasImplementedBy1 {
    }

    static class HasProvidedBy1Provider
    implements Provider<HasProvidedBy1> {
        HasProvidedBy1Provider() {
        }

        public HasProvidedBy1 get() {
            return new HasProvidedBy1(){};
        }
    }

    @ProvidedBy(value=HasProvidedBy1Provider.class)
    static interface HasProvidedBy1 {
    }

    static class NoInjectConstructor {
        private NoInjectConstructor() {
        }
    }

    static class MissingParameter {
        @Inject
        MissingParameter(NoInjectConstructor noInjectConstructor) {
        }
    }

    static class InnerCoreModule
    extends AbstractModule {
        final Named red = Names.named((String)"red");

        InnerCoreModule() {
        }

        protected void configure() {
            this.bind(AbstractModule.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Binder.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Binding.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Injector.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Key.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Module.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Provider.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Scope.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(Stage.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind(TypeLiteral.class).annotatedWith((Annotation)this.red).toProvider(Providers.of(null));
            this.bind((TypeLiteral)new TypeLiteral<Key<String>>(){}).toProvider(Providers.of(null));
        }
    }

    static class OuterCoreModule
    extends AbstractModule {
        OuterCoreModule() {
        }

        protected void configure() {
            this.install((Module)new InnerCoreModule());
        }
    }

    static class ConstantModule
    extends AbstractModule {
        private final String constant;

        ConstantModule(String constant) {
            this.constant = constant;
        }

        protected void configure() {
            this.bind(String.class).toInstance((Object)this.constant);
        }
    }

    static class BarModule
    extends AbstractModule {
        BarModule() {
        }

        protected void configure() {
            this.install((Module)new ConstantModule("bar"));
        }
    }

    static class FooModule
    extends AbstractModule {
        FooModule() {
        }

        protected void configure() {
            this.install((Module)new ConstantModule("foo"));
        }
    }

    static class ParentModule
    extends AbstractModule {
        ParentModule() {
        }

        protected void configure() {
            this.install((Module)new FooModule());
            this.install((Module)new BarModule());
        }
    }

    static class NeedsRunnable {
        @Inject
        Runnable runnable;

        NeedsRunnable() {
        }
    }

    static class Foo {
        Foo() {
        }
    }
}

