/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import junit.framework.TestCase;

public class EagerSingletonTest
extends TestCase {
    public void setUp() {
        A.instanceCount = 0;
        B.instanceCount = 0;
        C.instanceCount = 0;
    }

    public void testJustInTimeEagerSingletons() {
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.getProvider(A.class);
                this.requestInjection(new Object(){

                    @Inject
                    void inject(Injector injector) {
                        injector.getInstance(C.class);
                    }
                });
            }
        }});
        EagerSingletonTest.assertEquals((int)1, (int)A.instanceCount);
        EagerSingletonTest.assertEquals((String)"Singletons discovered when creating singletons should not be built eagerly", (int)0, (int)B.instanceCount);
        EagerSingletonTest.assertEquals((int)1, (int)C.instanceCount);
    }

    public void testJustInTimeSingletonsAreNotEager() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[0]);
        injector.getProvider(B.class);
        EagerSingletonTest.assertEquals((int)0, (int)B.instanceCount);
    }

    public void testChildEagerSingletons() {
        Injector parent = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[0]);
        parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(D.class).to(C.class);
            }
        }});
        EagerSingletonTest.assertEquals((int)1, (int)C.instanceCount);
    }

    private static interface D {
    }

    @Singleton
    static class C
    implements D {
        static int instanceCount = 0;
        int instanceId = instanceCount++;

        C() {
        }
    }

    @Singleton
    static class B {
        static int instanceCount = 0;
        int instanceId = instanceCount++;

        B() {
        }
    }

    @Singleton
    static class A {
        static int instanceCount = 0;
        int instanceId = instanceCount++;

        @Inject
        A(Injector injector) {
            injector.getProvider(B.class);
        }
    }
}

