/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.util.Set;
import junit.framework.TestCase;

public class JitBindingsTest
extends TestCase {
    private String jitFailed(Class<?> clazz) {
        return this.jitFailed(TypeLiteral.get(clazz));
    }

    private String jitFailed(TypeLiteral<?> clazz) {
        return "Explicit bindings are required and " + clazz + " is not explicitly bound.";
    }

    private String jitInParentFailed(Class<?> clazz) {
        return this.jitInParentFailed(TypeLiteral.get(clazz));
    }

    private String jitInParentFailed(TypeLiteral<?> clazz) {
        return "Explicit bindings are required and " + clazz + " would be bound in a parent injector.";
    }

    private String inChildMessage(Class<?> clazz) {
        return "Unable to create binding for " + clazz.getName() + ". It was already configured on one or more child injectors or private modules";
    }

    public void testLinkedBindingWorks() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class).to(FooImpl.class);
            }
        }});
        this.ensureWorks(injector, Foo.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, FooImpl.class);
    }

    public void testMoreBasicsWork() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class).to(FooImpl.class);
                this.bind(Bar.class);
                this.bind(FooBar.class);
            }
        }});
        this.ensureWorks(injector, FooBar.class, Bar.class, Foo.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, FooImpl.class);
    }

    public void testLinkedEagerSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class).to(FooImpl.class).asEagerSingleton();
            }
        }});
        this.ensureWorks(injector, Foo.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, FooImpl.class);
    }

    public void testBasicsWithEagerSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class).to(FooImpl.class).asEagerSingleton();
                this.bind(Bar.class);
                this.bind(FooBar.class);
            }
        }});
        this.ensureWorks(injector, FooBar.class, Bar.class, Foo.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, FooImpl.class);
    }

    public void testLinkedToScoped() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder.requireExplicitBindings();
                this.bind(Foo.class).to(ScopedFooImpl.class);
            }
        }});
        this.ensureWorks(injector, Foo.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, ScopedFooImpl.class);
    }

    public void testBasicsWithScoped() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class).to(ScopedFooImpl.class);
                this.bind(Bar.class);
                this.bind(FooBar.class);
            }
        }});
        this.ensureWorks(injector, FooBar.class, Bar.class, Foo.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, ScopedFooImpl.class);
    }

    public void testFailsIfInjectingScopedDirectlyWhenItIsntBound() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireExplicitBindings();
                    this.bind(Foo.class).to(ScopedFooImpl.class);
                    this.bind(WantsScopedFooImpl.class);
                }
            }});
            JitBindingsTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(ScopedFooImpl.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testLinkedProviderBindingWorks() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class).toProvider(FooProvider.class);
            }
        }});
        this.ensureWorks(injector, Foo.class);
        this.ensureFails(injector, GetBindingCheck.FAIL_ALL, FooImpl.class);
    }

    public void testJitGetFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireExplicitBindings();
                }
            }}).getInstance(Bar.class);
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Bar.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testJitInjectionFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireExplicitBindings();
                    this.bind(Foo.class).to(FooImpl.class);
                    this.bind(FooBar.class);
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Bar.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testJitProviderGetFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireExplicitBindings();
                }
            }}).getProvider(Bar.class);
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Bar.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testJitProviderInjectionFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireExplicitBindings();
                    this.bind(Foo.class).to(FooImpl.class);
                    this.bind(ProviderFooBar.class);
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Bar.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testImplementedBy() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(ImplBy.class);
            }
        }});
        this.ensureWorks(injector, ImplBy.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, ImplByImpl.class);
    }

    public void testImplementedBySomethingThatIsAnnotated() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(ImplByScoped.class);
            }
        }});
        this.ensureWorks(injector, ImplByScoped.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, ImplByScopedImpl.class);
    }

    public void testProvidedBy() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(ProvBy.class);
            }
        }});
        this.ensureWorks(injector, ProvBy.class);
        this.ensureFails(injector, GetBindingCheck.ALLOW_BINDING, ProvByProvider.class);
    }

    public void testProviderMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
            }

            @Provides
            Foo foo() {
                return new FooImpl();
            }
        }});
        this.ensureWorks(injector, Foo.class);
    }

    public void testChildInjectorInheritsOption() {
        Injector parent = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Bar.class);
            }
        }});
        this.ensureWorks(parent, Bar.class);
        this.ensureFails(parent, GetBindingCheck.FAIL_ALL, FooImpl.class, FooBar.class, Foo.class);
        try {
            parent.createChildInjector(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(FooBar.class);
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Foo.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).to(FooImpl.class);
            }
        }});
        this.ensureWorks(child, Foo.class, Bar.class);
        this.ensureFails(child, GetBindingCheck.ALLOW_BINDING, FooImpl.class);
        this.ensureInChild(parent, FooImpl.class, Foo.class);
        Injector grandchild = child.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(FooBar.class);
            }
        }});
        this.ensureWorks(grandchild, FooBar.class, Foo.class, Bar.class);
        this.ensureFails(grandchild, GetBindingCheck.ALLOW_BINDING, FooImpl.class);
        this.ensureFails(child, GetBindingCheck.ALLOW_BINDING, FooImpl.class);
        this.ensureInChild(parent, FooImpl.class, FooBar.class, Foo.class);
    }

    public void testChildInjectorAddsOption() {
        Injector parent = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Bar.class);
            }
        }});
        int totalParentBindings = parent.getAllBindings().size();
        try {
            parent.createChildInjector(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireExplicitBindings();
                    this.bind(FooBar.class);
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Foo.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
        JitBindingsTest.assertEquals((int)totalParentBindings, (int)parent.getAllBindings().size());
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class).to(FooImpl.class);
                this.bind(FooImpl.class);
            }
        }});
        JitBindingsTest.assertEquals((int)totalParentBindings, (int)parent.getAllBindings().size());
        this.ensureWorks(child, Foo.class, Bar.class);
        Injector grandchild = child.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(FooBar.class);
            }
        }});
        JitBindingsTest.assertEquals((int)totalParentBindings, (int)parent.getAllBindings().size());
        this.ensureWorks(grandchild, FooBar.class, Foo.class, Bar.class);
        child = parent.createChildInjector(new Module[0]);
        this.ensureWorks(child, FooImpl.class);
    }

    public void testPrivateModulesInheritOptions() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireExplicitBindings();
                    this.bind(Foo.class).to(FooImpl.class);
                    this.install((Module)new PrivateModule(){

                        public void configure() {
                            this.bind(FooBar.class);
                            this.expose(FooBar.class);
                        }
                    });
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Bar.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.bind(Foo.class).to(FooImpl.class);
                        this.expose(Foo.class);
                    }
                });
            }
        }});
        this.ensureInChild(injector, FooImpl.class);
    }

    public void testPrivateModuleAddsOption() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(Foo.class).to(FooImpl.class);
                    this.install((Module)new PrivateModule(){

                        public void configure() {
                            this.binder().requireExplicitBindings();
                            this.bind(FooBar.class);
                            this.expose(FooBar.class);
                        }
                    });
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitFailed(Bar.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testPrivateModuleSiblingsDontShareOption() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).to(FooImpl.class);
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.binder().requireExplicitBindings();
                    }
                });
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.bind(FooBar.class);
                        this.expose(FooBar.class);
                    }
                });
            }
        }});
    }

    public void testTypeLiteralsCanBeInjected() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind((TypeLiteral)new TypeLiteral<WantsTypeLiterals<String>>(){});
                this.bind((TypeLiteral)new TypeLiteral<Set<String>>(){}).toInstance((Object)ImmutableSet.of((Object)"bar"));
            }
        }});
        WantsTypeLiterals foo = (WantsTypeLiterals)injector.getInstance((Key)new Key<WantsTypeLiterals<String>>(){});
        JitBindingsTest.assertEquals((Object)foo.literal.getRawType(), String.class);
        JitBindingsTest.assertEquals((Object)ImmutableSet.of((Object)"bar"), foo.set);
    }

    public void testMembersInjectorsCanBeInjected() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
            }

            @Provides
            String data(MembersInjector<String> mi) {
                String data = "foo";
                mi.injectMembers((Object)data);
                return data;
            }
        }});
        String data = (String)injector.getInstance(String.class);
        JitBindingsTest.assertEquals((String)"foo", (String)data);
    }

    public void testJitLinkedBindingInParentFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.install((Module)new PrivateModule(){

                        protected void configure() {
                            this.binder().requireExplicitBindings();
                            this.bind(Foo.class).to(FooImpl.class);
                        }
                    });
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitInParentFailed(FooImpl.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testJitProviderBindingInParentFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.install((Module)new PrivateModule(){

                        protected void configure() {
                            this.binder().requireExplicitBindings();
                            this.bind(Foo.class).toProvider(FooProvider.class);
                        }
                    });
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitInParentFailed(FooProvider.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testJitImplementedByBindingInParentFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.install((Module)new PrivateModule(){

                        protected void configure() {
                            this.binder().requireExplicitBindings();
                            this.bind(ImplBy.class);
                        }
                    });
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitInParentFailed(ImplByImpl.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    public void testJitProvidedByBindingInParentFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.install((Module)new PrivateModule(){

                        protected void configure() {
                            this.binder().requireExplicitBindings();
                            this.bind(ProvBy.class);
                        }
                    });
                }
            }});
            JitBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), this.jitInParentFailed(ProvByProvider.class));
            JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    private void ensureWorks(Injector injector, Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            injector.getInstance(classes[i]);
            injector.getProvider(classes[i]).get();
            injector.getBinding(classes[i]).getProvider().get();
        }
    }

    private void ensureFails(Injector injector, GetBindingCheck getBinding, Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            try {
                injector.getInstance(classes[i]);
                JitBindingsTest.fail((String)("should have failed tring to retrieve class: " + classes[i]));
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.jitFailed(classes[i]));
                JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            }
            try {
                injector.getProvider(classes[i]);
                JitBindingsTest.fail((String)("should have failed tring to retrieve class: " + classes[i]));
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.jitFailed(classes[i]));
                JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            }
            if (getBinding == GetBindingCheck.ALLOW_BINDING || getBinding == GetBindingCheck.ALLOW_BINDING_PROVIDER) {
                Binding binding = injector.getBinding(classes[i]);
                try {
                    binding.getProvider();
                    if (getBinding == GetBindingCheck.ALLOW_BINDING_PROVIDER) continue;
                    JitBindingsTest.fail((String)("should have failed trying to retrieve class: " + classes[i]));
                }
                catch (ConfigurationException expected) {
                    if (getBinding == GetBindingCheck.ALLOW_BINDING_PROVIDER) {
                        throw expected;
                    }
                    Asserts.assertContains(expected.getMessage(), this.jitFailed(classes[i]));
                    JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
                }
                continue;
            }
            try {
                injector.getBinding(classes[i]);
                JitBindingsTest.fail((String)("should have failed tring to retrieve class: " + classes[i]));
                continue;
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.jitFailed(classes[i]));
                JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            }
        }
    }

    private void ensureInChild(Injector injector, Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            try {
                injector.getInstance(classes[i]);
                JitBindingsTest.fail((String)("should have failed tring to retrieve class: " + classes[i]));
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.inChildMessage(classes[i]));
                JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            }
            try {
                injector.getProvider(classes[i]);
                JitBindingsTest.fail((String)("should have failed tring to retrieve class: " + classes[i]));
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.inChildMessage(classes[i]));
                JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            }
            try {
                injector.getBinding(classes[i]);
                JitBindingsTest.fail((String)("should have failed tring to retrieve class: " + classes[i]));
                continue;
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.inChildMessage(classes[i]));
                JitBindingsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            }
        }
    }

    private static class WantsTypeLiterals<T> {
        TypeLiteral<T> literal;
        Set<T> set;

        @Inject
        WantsTypeLiterals(TypeLiteral<T> literal, Set<T> set) {
            this.literal = literal;
            this.set = set;
        }
    }

    private static class ProvByProvider
    implements Provider<ProvBy> {
        private ProvByProvider() {
        }

        public ProvBy get() {
            return new ProvBy(){};
        }
    }

    @ProvidedBy(value=ProvByProvider.class)
    private static interface ProvBy {
    }

    @Singleton
    private static class ImplByScopedImpl
    implements ImplByScoped {
        private ImplByScopedImpl() {
        }
    }

    @ImplementedBy(value=ImplByScopedImpl.class)
    private static interface ImplByScoped {
    }

    private static class ImplByImpl
    implements ImplBy {
        private ImplByImpl() {
        }
    }

    @ImplementedBy(value=ImplByImpl.class)
    private static interface ImplBy {
    }

    private static class FooProvider
    implements Provider<Foo> {
        private FooProvider() {
        }

        public Foo get() {
            return new FooImpl();
        }
    }

    private static class ProviderFooBar {
        @Inject
        Provider<Foo> foo;
        @Inject
        Provider<Bar> bar;

        private ProviderFooBar() {
        }
    }

    private static class FooBar {
        @Inject
        Foo foo;
        @Inject
        Bar bar;

        private FooBar() {
        }
    }

    private static class Bar {
        private Bar() {
        }
    }

    private static class WantsScopedFooImpl {
        @Inject
        ScopedFooImpl scopedFoo;

        private WantsScopedFooImpl() {
        }
    }

    @Singleton
    private static class ScopedFooImpl
    implements Foo {
        private ScopedFooImpl() {
        }
    }

    private static class FooImpl
    implements Foo {
        private FooImpl() {
        }
    }

    private static interface Foo {
    }

    static enum GetBindingCheck {
        FAIL_ALL,
        ALLOW_BINDING,
        ALLOW_BINDING_PROVIDER;

    }
}

