/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class MembersInjectorTest
extends TestCase {
    private static final long DEADLOCK_TIMEOUT_SECONDS = 1L;
    private static final A<C> uninjectableA = new A<C>(){

        @Override
        void doNothing() {
            throw new AssertionFailedError();
        }
    };
    private static final B uninjectableB = new B(){

        @Override
        void doNothing() {
            throw new AssertionFailedError();
        }
    };
    private static final C myFavouriteC = new C();

    public void testMembersInjectorFromBinder() {
        final AtomicReference aMembersInjectorReference = new AtomicReference();
        final AtomicReference bMembersInjectorReference = new AtomicReference();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                MembersInjector aMembersInjector = this.getMembersInjector((TypeLiteral)new TypeLiteral<A<C>>(){});
                try {
                    aMembersInjector.injectMembers((Object)uninjectableA);
                    TestCase.fail();
                }
                catch (IllegalStateException expected) {
                    Asserts.assertContains(expected.getMessage(), "This MembersInjector cannot be used until the Injector has been created.");
                }
                MembersInjector bMembersInjector = this.getMembersInjector(B.class);
                try {
                    bMembersInjector.injectMembers((Object)uninjectableB);
                    TestCase.fail();
                }
                catch (IllegalStateException expected) {
                    Asserts.assertContains(expected.getMessage(), "This MembersInjector cannot be used until the Injector has been created.");
                }
                aMembersInjectorReference.set(aMembersInjector);
                bMembersInjectorReference.set(bMembersInjector);
                TestCase.assertEquals((String)"MembersInjector<java.lang.String>", (String)this.getMembersInjector(String.class).toString());
                this.bind(C.class).toInstance((Object)myFavouriteC);
            }
        }});
        A injectableA = new A();
        ((MembersInjector)aMembersInjectorReference.get()).injectMembers(injectableA);
        MembersInjectorTest.assertSame((Object)myFavouriteC, injectableA.t);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)injectableA.b.c);
        B injectableB = new B();
        ((MembersInjector)bMembersInjectorReference.get()).injectMembers((Object)injectableB);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)injectableB.c);
        B anotherInjectableB = new B();
        ((MembersInjector)bMembersInjectorReference.get()).injectMembers((Object)anotherInjectableB);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)anotherInjectableB.c);
    }

    public void testMembersInjectorFromInjector() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(C.class).toInstance((Object)myFavouriteC);
            }
        }});
        MembersInjector aMembersInjector = injector.getMembersInjector((TypeLiteral)new TypeLiteral<A<C>>(){});
        MembersInjector bMembersInjector = injector.getMembersInjector(B.class);
        A injectableA = new A();
        aMembersInjector.injectMembers(injectableA);
        MembersInjectorTest.assertSame((Object)myFavouriteC, injectableA.t);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)injectableA.b.c);
        B injectableB = new B();
        bMembersInjector.injectMembers((Object)injectableB);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)injectableB.c);
        B anotherInjectableB = new B();
        bMembersInjector.injectMembers((Object)anotherInjectableB);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)anotherInjectableB.c);
        MembersInjectorTest.assertEquals((String)"MembersInjector<java.lang.String>", (String)injector.getMembersInjector(String.class).toString());
    }

    public void testMembersInjectorWithNonInjectedTypes() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        MembersInjector membersInjector = injector.getMembersInjector(NoInjectedMembers.class);
        membersInjector.injectMembers((Object)new NoInjectedMembers());
        membersInjector.injectMembers((Object)new NoInjectedMembers());
    }

    public void testInjectionFailure() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        MembersInjector membersInjector = injector.getMembersInjector(InjectionFailure.class);
        try {
            membersInjector.injectMembers((Object)new InjectionFailure());
            MembersInjectorTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error injecting method, java.lang.ClassCastException: whoops, failure #1");
        }
    }

    public void testInjectionAppliesToSpecifiedType() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        MembersInjector membersInjector = injector.getMembersInjector(Object.class);
        membersInjector.injectMembers((Object)new InjectionFailure());
    }

    public void testInjectingMembersInjector() {
        InjectsMembersInjector injectsMembersInjector = (InjectsMembersInjector)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(C.class).toInstance((Object)myFavouriteC);
            }
        }}).getInstance(InjectsMembersInjector.class);
        A a = new A();
        injectsMembersInjector.aMembersInjector.injectMembers(a);
        MembersInjectorTest.assertSame((Object)myFavouriteC, a.t);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)a.b.c);
    }

    public void testCannotBindMembersInjector() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(MembersInjector.class).toProvider(Providers.of(null));
                }
            }});
            MembersInjectorTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Binding to core guice framework type is not allowed: MembersInjector.");
        }
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind((TypeLiteral)new TypeLiteral<MembersInjector<A<C>>>(){}).toProvider(Providers.of(null));
                }
            }});
            MembersInjectorTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Binding to core guice framework type is not allowed: MembersInjector.");
        }
    }

    public void testInjectingMembersInjectorWithErrorsInDependencies() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(InjectsBrokenMembersInjector.class);
            MembersInjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No implementation for " + Unimplemented.class.getName() + " was bound.", "while locating " + Unimplemented.class.getName(), "for field at " + A.class.getName() + ".t(MembersInjectorTest.java:", "while locating com.google.inject.MembersInjector<", "for field at " + InjectsBrokenMembersInjector.class.getName() + ".aMembersInjector(", "while locating " + InjectsBrokenMembersInjector.class.getName());
        }
    }

    public void testLookupMembersInjectorBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(C.class).toInstance((Object)myFavouriteC);
            }
        }});
        MembersInjector membersInjector = (MembersInjector)injector.getInstance((Key)new Key<MembersInjector<A<C>>>(){});
        A a = new A();
        membersInjector.injectMembers(a);
        MembersInjectorTest.assertSame((Object)myFavouriteC, a.t);
        MembersInjectorTest.assertSame((Object)myFavouriteC, (Object)a.b.c);
        MembersInjectorTest.assertEquals((String)"MembersInjector<java.lang.String>", (String)((MembersInjector)injector.getInstance((Key)new Key<MembersInjector<String>>(){})).toString());
    }

    public void testGettingRawMembersInjector() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            injector.getInstance(MembersInjector.class);
            MembersInjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Cannot inject a MembersInjector that has no type parameter");
        }
    }

    public void testGettingAnnotatedMembersInjector() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            injector.getInstance((Key)new Key<MembersInjector<String>>((Annotation)Names.named((String)"foo")){});
            MembersInjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No implementation for com.google.inject.MembersInjector<java.lang.String> annotated with @com.google.inject.name.Named(value=foo) was bound.");
        }
    }

    public void testMemberInjectorParallelization() throws Exception {
        final ParallelMemberInjectionCallback1 c1 = new ParallelMemberInjectionCallback1();
        final ParallelMemberInjectionCallback2 c2 = new ParallelMemberInjectionCallback2();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ParallelMemberInjectionCallback1.class).toInstance((Object)c1);
                this.bind(ParallelMemberInjectionCallback2.class).toInstance((Object)c2);
            }
        }});
        MembersInjectorTest.assertTrue((boolean)c1.called);
        MembersInjectorTest.assertTrue((boolean)c2.called);
    }

    public void testRecursiveMemberInjector() throws Exception {
        final RecursiveMemberInjection rmi = new RecursiveMemberInjection();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(RecursiveMemberInjection.class).toInstance((Object)rmi);
            }
        }});
        MembersInjectorTest.assertTrue((String)"Member injection should happen", (boolean)rmi.called);
    }

    static interface Unimplemented {
    }

    static class InjectsBrokenMembersInjector {
        @Inject
        MembersInjector<A<Unimplemented>> aMembersInjector;

        InjectsBrokenMembersInjector() {
        }
    }

    static class InjectsMembersInjector {
        @Inject
        MembersInjector<A<C>> aMembersInjector;
        @Inject
        A<B> ab;

        InjectsMembersInjector() {
        }
    }

    static class InjectionFailure {
        int failures = 0;

        InjectionFailure() {
        }

        @Inject
        void fail() {
            throw new ClassCastException("whoops, failure #" + ++this.failures);
        }
    }

    static class NoInjectedMembers {
        NoInjectedMembers() {
        }
    }

    static class C {
        C() {
        }
    }

    static class B {
        @Inject
        C c;

        B() {
        }

        @Inject
        void doNothing() {
        }
    }

    static class A<T> {
        @Inject
        B b;
        @Inject
        T t;

        A() {
        }

        @Inject
        void doNothing() {
        }
    }

    static class RecursiveMemberInjection {
        boolean called = false;

        RecursiveMemberInjection() {
        }

        @Inject
        void callback(RecursiveMemberInjection recursiveMemberInjection) {
            if (this.called) {
                TestCase.fail((String)"Should not be called twice");
            }
            this.called = true;
        }
    }

    static class ParallelMemberInjectionCallback2
    extends AbstractParallelMemberInjectionCallback {
        ParallelMemberInjectionCallback2() {
            super(ParallelMemberInjectionCallback1.class);
        }
    }

    static class ParallelMemberInjectionCallback1
    extends AbstractParallelMemberInjectionCallback {
        ParallelMemberInjectionCallback1() {
            super(ParallelMemberInjectionCallback2.class);
        }
    }

    static abstract class AbstractParallelMemberInjectionCallback {
        volatile boolean called = false;
        private final Thread mainThread = Thread.currentThread();
        private final Class<? extends AbstractParallelMemberInjectionCallback> otherCallbackClass;

        AbstractParallelMemberInjectionCallback(Class<? extends AbstractParallelMemberInjectionCallback> otherCallbackClass) {
            this.otherCallbackClass = otherCallbackClass;
        }

        @Inject
        void callback(final Injector injector) throws Exception {
            this.called = true;
            if (this.mainThread != Thread.currentThread()) {
                return;
            }
            AbstractParallelMemberInjectionCallback otherCallback = Executors.newSingleThreadExecutor().submit(new Callable<AbstractParallelMemberInjectionCallback>(){

                @Override
                public AbstractParallelMemberInjectionCallback call() throws Exception {
                    return (AbstractParallelMemberInjectionCallback)injector.getInstance(AbstractParallelMemberInjectionCallback.this.otherCallbackClass);
                }
            }).get(1L, TimeUnit.SECONDS);
            TestCase.assertTrue((boolean)otherCallback.called);
            try {
                Executors.newSingleThreadExecutor().submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return injector.getInstance(AbstractParallelMemberInjectionCallback.this.getClass());
                    }
                }).get(1L, TimeUnit.SECONDS);
                TestCase.fail();
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }
}

