/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import com.google.inject.spi.TypeConverter;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ParentInjectorTest
extends TestCase {
    private final MethodInterceptor returnNullInterceptor = new MethodInterceptor(){

        public Object invoke(MethodInvocation methodInvocation) {
            return null;
        }
    };
    private final Module bindsA = new AbstractModule(){

        protected void configure() {
            this.bind(A.class).toInstance((Object)new A());
        }
    };
    private final Module bindsB = new AbstractModule(){

        protected void configure() {
            this.bind(B.class).to(RealB.class);
        }
    };
    private final TypeConverter listConverter = new TypeConverter(){

        public Object convert(String value, TypeLiteral<?> toType) {
            return ImmutableList.of();
        }
    };
    private final Module bindListConverterModule = new AbstractModule(){

        protected void configure() {
            this.convertToTypes(Matchers.any(), ParentInjectorTest.this.listConverter);
        }
    };
    private final Module bindStringNamedB = new AbstractModule(){

        protected void configure() {
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"B")).toInstance((Object)"buzz");
        }
    };
    private final Module bindsD = new AbstractModule(){

        protected void configure() {
            this.bind(D.class);
        }
    };

    public void testParentAndChildCannotShareExplicitBindings() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindsA});
        try {
            parent.createChildInjector(new Module[]{this.bindsA});
            ParentInjectorTest.fail((String)"Created the same explicit binding on both parent and child");
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "A binding to ", A.class.getName(), " was already configured", " at ", ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), " at ", ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testParentJitBindingWontClobberChildBinding() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        parent.createChildInjector(new Module[]{this.bindsA});
        try {
            parent.getInstance(A.class);
            ParentInjectorTest.fail((String)"Created a just-in-time binding on the parent that's the same as a child's binding");
        }
        catch (ConfigurationException e) {
            Asserts.assertContains(e.getMessage(), "Unable to create binding for " + A.class.getName(), "It was already configured on one or more child injectors or private modules", "bound at " + this.bindsA.getClass().getName() + ".configure(", "If it was in a PrivateModule, did you forget to expose the binding?", "while locating " + A.class.getName());
        }
    }

    public void testChildCannotBindToAParentJitBinding() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        parent.getInstance(A.class);
        try {
            parent.createChildInjector(new Module[]{this.bindsA});
            ParentInjectorTest.fail();
        }
        catch (CreationException ce) {
            Asserts.assertContains(((Message)Iterables.getOnlyElement((Iterable)ce.getErrorMessages())).getMessage(), "A just-in-time binding to " + A.class.getName() + " was already configured on a parent injector.");
        }
    }

    public void testJustInTimeBindingsAreSharedWithParentIfPossible() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[0]);
        ParentInjectorTest.assertSame((Object)child.getInstance(A.class), (Object)parent.getInstance(A.class));
        Injector anotherChild = parent.createChildInjector(new Module[0]);
        ParentInjectorTest.assertSame((Object)anotherChild.getInstance(A.class), (Object)parent.getInstance(A.class));
        Injector grandchild = child.createChildInjector(new Module[0]);
        ParentInjectorTest.assertSame((Object)grandchild.getInstance(A.class), (Object)parent.getInstance(A.class));
    }

    public void testBindingsInherited() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindsB});
        Injector child = parent.createChildInjector(new Module[0]);
        ParentInjectorTest.assertSame(RealB.class, ((B)child.getInstance(B.class)).getClass());
    }

    public void testGetParent() {
        Injector top = Guice.createInjector((Module[])new Module[]{this.bindsA});
        Injector middle = top.createChildInjector(new Module[]{this.bindsB});
        Injector bottom = middle.createChildInjector(new Module[0]);
        ParentInjectorTest.assertSame((Object)middle, (Object)bottom.getParent());
        ParentInjectorTest.assertSame((Object)top, (Object)middle.getParent());
        ParentInjectorTest.assertNull((Object)top.getParent());
    }

    public void testChildBindingsNotVisibleToParent() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        parent.createChildInjector(new Module[]{this.bindsB});
        try {
            parent.getBinding(B.class);
            ParentInjectorTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testScopesInherited() {
        Injector parent = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(MyScope.class, Scopes.SINGLETON);
            }
        }});
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(A.class).in(MyScope.class);
            }
        }});
        ParentInjectorTest.assertSame((Object)child.getInstance(A.class), (Object)child.getInstance(A.class));
    }

    public void testInterceptorsInherited() {
        Injector parent = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                super.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.identicalTo(A.class)), new MethodInterceptor[]{ParentInjectorTest.this.returnNullInterceptor});
            }
        }});
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(C.class);
            }
        }});
        ParentInjectorTest.assertNull((Object)((C)child.getInstance(C.class)).interceptedMethod());
    }

    public void testTypeConvertersInherited() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindListConverterModule});
        Injector child = parent.createChildInjector(new Module[]{this.bindStringNamedB});
        ParentInjectorTest.assertEquals((Object)ImmutableList.of(), (Object)child.getInstance(Key.get(List.class, (Annotation)Names.named((String)"B"))));
    }

    public void testTypeConvertersConflicting() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindListConverterModule});
        Injector child = parent.createChildInjector(new Module[]{this.bindListConverterModule, this.bindStringNamedB});
        try {
            child.getInstance(Key.get(List.class, (Annotation)Names.named((String)"B")));
            ParentInjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Multiple converters can convert");
        }
    }

    public void testInjectorInjectionSpanningInjectors() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(D.class);
            }
        }});
        D d = (D)child.getInstance(D.class);
        ParentInjectorTest.assertSame((Object)d.injector, (Object)child);
        E e = (E)child.getInstance(E.class);
        ParentInjectorTest.assertSame((Object)e.injector, (Object)parent);
    }

    public void testSeveralLayersOfHierarchy() {
        Injector top = Guice.createInjector((Module[])new Module[]{this.bindsA});
        Injector left = top.createChildInjector(new Module[0]);
        Injector leftLeft = left.createChildInjector(new Module[]{this.bindsD});
        Injector right = top.createChildInjector(new Module[]{this.bindsD});
        ParentInjectorTest.assertSame((Object)leftLeft, (Object)((D)leftLeft.getInstance(D.class)).injector);
        ParentInjectorTest.assertSame((Object)right, (Object)((D)right.getInstance(D.class)).injector);
        ParentInjectorTest.assertSame((Object)top, (Object)((E)leftLeft.getInstance(E.class)).injector);
        ParentInjectorTest.assertSame((Object)top.getInstance(A.class), (Object)leftLeft.getInstance(A.class));
        Injector leftRight = left.createChildInjector(new Module[]{this.bindsD});
        ParentInjectorTest.assertSame((Object)leftRight, (Object)((D)leftRight.getInstance(D.class)).injector);
        try {
            top.getInstance(D.class);
            ParentInjectorTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            left.getInstance(D.class);
            ParentInjectorTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testScopeBoundInChildInjectorOnly() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(MyScope.class, Scopes.SINGLETON);
            }
        }});
        try {
            parent.getProvider(F.class);
            ParentInjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "No scope is bound to com.google.inject.ParentInjectorTest$MyScope.", "at " + F.class.getName() + ".class(ParentInjectorTest.java", "  while locating " + F.class.getName());
        }
        ParentInjectorTest.assertNotNull((Object)child.getProvider(F.class).get());
    }

    public void testErrorInParentButOkayInChild() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector childInjector = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(MyScope.class, Scopes.SINGLETON);
                this.bind(Object.class).to(F.class);
            }
        }});
        Object one = childInjector.getInstance(Object.class);
        Object two = childInjector.getInstance(Object.class);
        ParentInjectorTest.assertSame((Object)one, (Object)two);
    }

    public void testErrorInParentAndChild() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector childInjector = parent.createChildInjector(new Module[0]);
        try {
            childInjector.getInstance(G.class);
            ParentInjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "No scope is bound to " + MyScope.class.getName(), "at " + F.class.getName() + ".class(ParentInjectorTest.java:", "  while locating " + G.class.getName());
        }
    }

    @ImplementedBy(value=F.class)
    static interface G {
    }

    @MyScope
    static class F
    implements G {
        F() {
        }
    }

    static class E {
        @Inject
        Injector injector;

        E() {
        }
    }

    static class D {
        @Inject
        Injector injector;

        D() {
        }
    }

    public static class C {
        public A interceptedMethod() {
            return new A();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ScopeAnnotation
    public static @interface MyScope {
    }

    static class RealB
    implements B {
        RealB() {
        }
    }

    static interface B {
    }

    @Singleton
    static class A {
        A() {
        }
    }
}

