/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Exposed;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;

public class PrivateModuleTest
extends TestCase {
    public void testBasicUsage() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"a")).toInstance((Object)"public");
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"b")).toInstance((Object)"i");
                        this.bind(AB.class).annotatedWith((Annotation)Names.named((String)"one")).to(AB.class);
                        this.expose(AB.class).annotatedWith((Annotation)Names.named((String)"one"));
                    }
                });
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"b")).toInstance((Object)"ii");
                        this.bind(AB.class).annotatedWith((Annotation)Names.named((String)"two")).to(AB.class);
                        this.expose(AB.class).annotatedWith((Annotation)Names.named((String)"two"));
                    }
                });
            }
        }});
        AB ab1 = (AB)injector.getInstance(Key.get(AB.class, (Annotation)Names.named((String)"one")));
        PrivateModuleTest.assertEquals((String)"public", (String)ab1.a);
        PrivateModuleTest.assertEquals((String)"i", (String)ab1.b);
        AB ab2 = (AB)injector.getInstance(Key.get(AB.class, (Annotation)Names.named((String)"two")));
        PrivateModuleTest.assertEquals((String)"public", (String)ab2.a);
        PrivateModuleTest.assertEquals((String)"ii", (String)ab2.b);
    }

    public void testWithoutPrivateModules() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                PrivateBinder bindA = this.binder().newPrivateBinder();
                bindA.bind(String.class).annotatedWith((Annotation)Names.named((String)"a")).toInstance((Object)"i");
                bindA.expose(String.class).annotatedWith((Annotation)Names.named((String)"a"));
                bindA.bind(String.class).annotatedWith((Annotation)Names.named((String)"c")).toInstance((Object)"private to A");
                PrivateBinder bindB = this.binder().newPrivateBinder();
                bindB.bind(String.class).annotatedWith((Annotation)Names.named((String)"b")).toInstance((Object)"ii");
                bindB.expose(String.class).annotatedWith((Annotation)Names.named((String)"b"));
                bindB.bind(String.class).annotatedWith((Annotation)Names.named((String)"c")).toInstance((Object)"private to B");
            }
        }});
        PrivateModuleTest.assertEquals((String)"i", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"a")))));
        PrivateModuleTest.assertEquals((String)"ii", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"b")))));
    }

    public void testMisplacedExposedAnnotation() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                }

                @Provides
                @Exposed
                String provideString() {
                    return "i";
                }
            }});
            PrivateModuleTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Cannot expose java.lang.String on a standard binder. ", "Exposed bindings are only applicable to private binders.", " at " + PrivateModuleTest.class.getName(), "provideString(PrivateModuleTest.java:");
        }
    }

    public void testMisplacedExposeStatement() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    ((PrivateBinder)this.binder()).expose(String.class).annotatedWith((Annotation)Names.named((String)"a"));
                }
            }});
            PrivateModuleTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Cannot expose java.lang.String on a standard binder. ", "Exposed bindings are only applicable to private binders.", " at " + PrivateModuleTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testPrivateModulesAndProvidesMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.expose(String.class).annotatedWith((Annotation)Names.named((String)"a"));
                    }

                    @Provides
                    @Named(value="a")
                    String providePublicA() {
                        return "i";
                    }

                    @Provides
                    @Named(value="b")
                    String providePrivateB() {
                        return "private";
                    }
                });
                this.install((Module)new PrivateModule(){

                    public void configure() {
                    }

                    @Provides
                    @Named(value="c")
                    String providePrivateC() {
                        return "private";
                    }

                    @Provides
                    @Exposed
                    @Named(value="d")
                    String providePublicD() {
                        return "ii";
                    }
                });
            }
        }});
        PrivateModuleTest.assertEquals((String)"i", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"a")))));
        try {
            injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"b")));
            PrivateModuleTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"c")));
            PrivateModuleTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        PrivateModuleTest.assertEquals((String)"ii", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"d")))));
    }

    public void testCannotBindAKeyExportedByASibling() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.install((Module)new PrivateModule(){

                        public void configure() {
                            this.bind(String.class).toInstance((Object)"public");
                            this.expose(String.class);
                        }
                    });
                    this.install((Module)new PrivateModule(){

                        public void configure() {
                            this.bind(String.class).toInstance((Object)"private");
                        }
                    });
                }
            }});
            PrivateModuleTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "A binding to java.lang.String was already configured at ", ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), " at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testExposeButNoBind() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(String.class).annotatedWith((Annotation)Names.named((String)"a")).toInstance((Object)"a");
                    this.bind(String.class).annotatedWith((Annotation)Names.named((String)"b")).toInstance((Object)"b");
                    this.install((Module)new PrivateModule(){

                        public void configure() {
                            this.expose(AB.class);
                        }
                    });
                }
            }});
            PrivateModuleTest.fail((String)"AB was exposed but not bound");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Could not expose() " + AB.class.getName() + ", it must be explicitly bound", Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testMessagesFromPrivateModulesAreNicelyIntegrated() {
        try {
            Guice.createInjector((Module[])new Module[]{new PrivateModule(){

                public void configure() {
                    this.bind(C.class);
                }
            }, new PrivateModule(){

                public void configure() {
                    this.bind(AB.class);
                }
            }});
            PrivateModuleTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No implementation for " + C.class.getName() + " was bound.", "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), "2) No implementation for " + String.class.getName(), "Named(value=a) was bound.", "for field at " + AB.class.getName() + ".a(PrivateModuleTest.java:", "3) No implementation for " + String.class.getName(), "Named(value=b) was bound.", "for field at " + AB.class.getName() + ".b(PrivateModuleTest.java:", "3 errors");
        }
    }

    public void testNestedPrivateInjectors() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            public void configure() {
                this.expose(String.class);
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.bind(String.class).toInstance((Object)"nested");
                        this.expose(String.class);
                    }
                });
            }
        }});
        PrivateModuleTest.assertEquals((String)"nested", (String)((String)injector.getInstance(String.class)));
    }

    public void testInstallingRegularModulesFromPrivateModules() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            public void configure() {
                this.expose(String.class);
                this.install((Module)new AbstractModule(){

                    protected void configure() {
                        this.bind(String.class).toInstance((Object)"nested");
                    }
                });
            }
        }});
        PrivateModuleTest.assertEquals((String)"nested", (String)((String)injector.getInstance(String.class)));
    }

    public void testNestedPrivateModulesWithSomeKeysUnexposed() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            public void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"bound outer, exposed outer")).toInstance((Object)"boeo");
                this.expose(String.class).annotatedWith((Annotation)Names.named((String)"bound outer, exposed outer"));
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"bound outer, exposed none")).toInstance((Object)"boen");
                this.expose(String.class).annotatedWith((Annotation)Names.named((String)"bound inner, exposed both"));
                this.install((Module)new PrivateModule(){

                    public void configure() {
                        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"bound inner, exposed both")).toInstance((Object)"bieb");
                        this.expose(String.class).annotatedWith((Annotation)Names.named((String)"bound inner, exposed both"));
                        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"bound inner, exposed none")).toInstance((Object)"bien");
                    }
                });
            }
        }});
        PrivateModuleTest.assertEquals((String)"boeo", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"bound outer, exposed outer")))));
        PrivateModuleTest.assertEquals((String)"bieb", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"bound inner, exposed both")))));
        try {
            injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"bound outer, exposed none")));
            PrivateModuleTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"bound inner, exposed none")));
            PrivateModuleTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testDependenciesBetweenPrivateAndPublic() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            protected void configure() {
            }

            @Provides
            @Exposed
            @Named(value="a")
            String provideA() {
                return "A";
            }

            @Provides
            @Exposed
            @Named(value="abc")
            String provideAbc(@Named(value="ab") String ab) {
                return ab + "C";
            }
        }, new AbstractModule(){

            protected void configure() {
            }

            @Provides
            @Named(value="ab")
            String provideAb(@Named(value="a") String a) {
                return a + "B";
            }

            @Provides
            @Named(value="abcd")
            String provideAbcd(@Named(value="abc") String abc) {
                return abc + "D";
            }
        }});
        PrivateModuleTest.assertEquals((String)"ABCD", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"abcd")))));
    }

    public void testDependenciesBetweenPrivateAndPublicWithPublicEagerSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            protected void configure() {
            }

            @Provides
            @Exposed
            @Named(value="a")
            String provideA() {
                return "A";
            }

            @Provides
            @Exposed
            @Named(value="abc")
            String provideAbc(@Named(value="ab") String ab) {
                return ab + "C";
            }
        }, new AbstractModule(){

            protected void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"abcde")).toProvider((Provider)new Provider<String>(){
                    @Inject
                    @Named(value="abcd")
                    String abcd;

                    public String get() {
                        return this.abcd + "E";
                    }
                }).asEagerSingleton();
            }

            @Provides
            @Named(value="ab")
            String provideAb(@Named(value="a") String a) {
                return a + "B";
            }

            @Provides
            @Named(value="abcd")
            String provideAbcd(@Named(value="abc") String abc) {
                return abc + "D";
            }
        }});
        PrivateModuleTest.assertEquals((String)"ABCDE", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"abcde")))));
    }

    public void testDependenciesBetweenPrivateAndPublicWithPrivateEagerSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
            }

            @Provides
            @Named(value="ab")
            String provideAb(@Named(value="a") String a) {
                return a + "B";
            }

            @Provides
            @Named(value="abcd")
            String provideAbcd(@Named(value="abc") String abc) {
                return abc + "D";
            }
        }, new PrivateModule(){

            protected void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"abcde")).toProvider((Provider)new Provider<String>(){
                    @Inject
                    @Named(value="abcd")
                    String abcd;

                    public String get() {
                        return this.abcd + "E";
                    }
                }).asEagerSingleton();
                this.expose(String.class).annotatedWith((Annotation)Names.named((String)"abcde"));
            }

            @Provides
            @Exposed
            @Named(value="a")
            String provideA() {
                return "A";
            }

            @Provides
            @Exposed
            @Named(value="abc")
            String provideAbc(@Named(value="ab") String ab) {
                return ab + "C";
            }
        }});
        PrivateModuleTest.assertEquals((String)"ABCDE", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"abcde")))));
    }

    public void testSpiAccess() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            public void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"a")).toInstance((Object)"private");
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"b")).toInstance((Object)"exposed");
                this.expose(String.class).annotatedWith((Annotation)Names.named((String)"b"));
            }
        }});
        ExposedBinding binding = (ExposedBinding)injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"b")));
        PrivateModuleTest.assertEquals((Object)ImmutableSet.of((Object)Dependency.get((Key)Key.get(Injector.class))), (Object)binding.getDependencies());
        PrivateElements privateElements = binding.getPrivateElements();
        PrivateModuleTest.assertEquals((Object)ImmutableSet.of((Object)Key.get(String.class, (Annotation)Names.named((String)"b"))), (Object)privateElements.getExposedKeys());
        Asserts.assertContains(privateElements.getExposedSource(Key.get(String.class, (Annotation)Names.named((String)"b"))).toString(), PrivateModuleTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        Injector privateInjector = privateElements.getInjector();
        PrivateModuleTest.assertEquals((String)"private", (String)((String)privateInjector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"a")))));
    }

    public void testParentBindsSomethingInPrivate() {
        try {
            Guice.createInjector((Module[])new Module[]{new FailingModule()});
            PrivateModuleTest.fail();
        }
        catch (CreationException expected) {
            PrivateModuleTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            Asserts.assertContains(expected.toString(), "Unable to create binding for java.util.List.", "It was already configured on one or more child injectors or private modules", "bound at " + FailingPrivateModule.class.getName() + ".configure(", Asserts.asModuleChain(FailingModule.class, ManyPrivateModules.class, FailingPrivateModule.class), "bound at " + SecondFailingPrivateModule.class.getName() + ".configure(", Asserts.asModuleChain(FailingModule.class, ManyPrivateModules.class, SecondFailingPrivateModule.class), "If it was in a PrivateModule, did you forget to expose the binding?", "at " + FailingModule.class.getName() + ".configure(");
        }
    }

    public void testParentBindingToPrivateLinkedJitBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ManyPrivateModules()});
        try {
            injector.getBinding(Key.get((Type)Types.providerOf(List.class)));
            PrivateModuleTest.fail();
        }
        catch (ConfigurationException expected) {
            PrivateModuleTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            Asserts.assertContains(expected.toString(), "Unable to create binding for com.google.inject.Provider<java.util.List>.", "It was already configured on one or more child injectors or private modules", "bound at " + FailingPrivateModule.class.getName() + ".configure(", Asserts.asModuleChain(ManyPrivateModules.class, FailingPrivateModule.class), "bound at " + SecondFailingPrivateModule.class.getName() + ".configure(", Asserts.asModuleChain(ManyPrivateModules.class, SecondFailingPrivateModule.class), "If it was in a PrivateModule, did you forget to expose the binding?", "while locating com.google.inject.Provider<java.util.List>");
        }
    }

    public void testParentBindingToPrivateJitBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ManyPrivateModules()});
        try {
            injector.getBinding(PrivateFoo.class);
            PrivateModuleTest.fail();
        }
        catch (ConfigurationException expected) {
            PrivateModuleTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            Asserts.assertContains(expected.toString(), "Unable to create binding for " + PrivateFoo.class.getName(), "It was already configured on one or more child injectors or private modules", "(bound by a just-in-time binding)", "If it was in a PrivateModule, did you forget to expose the binding?", "while locating " + PrivateFoo.class.getName());
        }
    }

    private static class PrivateFoo {
        @Inject
        List list;

        private PrivateFoo() {
        }
    }

    private static class SecondFailingPrivateModule
    extends PrivateModule {
        private SecondFailingPrivateModule() {
        }

        protected void configure() {
            this.bind(List.class).toInstance(new ArrayList());
            this.getProvider(Key.get((Type)Types.providerOf(List.class)));
            this.getProvider(PrivateFoo.class);
        }
    }

    private static class FailingPrivateModule
    extends PrivateModule {
        private FailingPrivateModule() {
        }

        protected void configure() {
            this.bind(List.class).toInstance(new ArrayList());
            this.getProvider(Key.get((Type)Types.providerOf(List.class)));
            this.getProvider(PrivateFoo.class);
        }
    }

    private static class ManyPrivateModules
    extends AbstractModule {
        private ManyPrivateModules() {
        }

        protected void configure() {
            this.install((Module)new FailingPrivateModule());
            this.install((Module)new FailingPrivateModule());
            this.install((Module)new SecondFailingPrivateModule());
        }
    }

    private static class FailingModule
    extends AbstractModule {
        private FailingModule() {
        }

        protected void configure() {
            this.bind(Collection.class).to(List.class);
            this.install((Module)new ManyPrivateModules());
        }
    }

    static interface C {
    }

    static class AB {
        @Inject
        @Named(value="a")
        String a;
        @Inject
        @Named(value="b")
        String b;

        AB() {
        }
    }
}

