/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import junit.framework.TestCase;

public class RequestInjectionTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        HasInjections.staticField = 0;
        HasInjections.staticMethod = null;
    }

    public void testInjectMembers() {
        final HasInjections hi = new HasInjections();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(ForMethod.class).to("test");
                this.bindConstant().annotatedWith(ForField.class).to(5);
                this.requestInjection(hi);
            }
        }});
        RequestInjectionTest.assertEquals((String)"test", (String)hi.instanceMethod);
        RequestInjectionTest.assertEquals((int)5, (int)hi.instanceField);
        RequestInjectionTest.assertNull((Object)HasInjections.staticMethod);
        RequestInjectionTest.assertEquals((int)0, (int)HasInjections.staticField);
    }

    public void testInjectStatics() throws CreationException {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(ForMethod.class).to("test");
                this.bindConstant().annotatedWith(ForField.class).to(5);
                this.requestStaticInjection(new Class[]{HasInjections.class});
            }
        }});
        RequestInjectionTest.assertEquals((String)"test", (String)HasInjections.staticMethod);
        RequestInjectionTest.assertEquals((int)5, (int)HasInjections.staticField);
    }

    public void testInjectMembersAndStatics() {
        final HasInjections hi = new HasInjections();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(ForMethod.class).to("test");
                this.bindConstant().annotatedWith(ForField.class).to(5);
                this.requestStaticInjection(new Class[]{HasInjections.class});
                this.requestInjection(hi);
            }
        }});
        RequestInjectionTest.assertEquals((String)"test", (String)hi.instanceMethod);
        RequestInjectionTest.assertEquals((int)5, (int)hi.instanceField);
        RequestInjectionTest.assertEquals((String)"test", (String)HasInjections.staticMethod);
        RequestInjectionTest.assertEquals((int)5, (int)HasInjections.staticField);
    }

    public void testValidationErrorOnInjectedMembers() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.requestInjection(new NeedsRunnable());
                }
            }});
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No implementation for java.lang.Runnable was bound", "at " + NeedsRunnable.class.getName(), ".runnable(RequestInjectionTest.java:");
        }
    }

    public void testInjectionErrorOnInjectedMembers() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(Runnable.class).toProvider((Provider)new Provider<Runnable>(){

                        public Runnable get() {
                            throw new UnsupportedOperationException();
                        }
                    });
                    this.requestInjection(new NeedsRunnable());
                }
            }});
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error in custom provider, java.lang.UnsupportedOperationException", "for field at " + NeedsRunnable.class.getName() + ".runnable(RequestInjectionTest.java:", "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testUserExceptionWhileInjectingInstance() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.requestInjection(new BlowsUpOnInject());
                }
            }});
            RequestInjectionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error injecting method, java.lang.UnsupportedOperationException: Pop", "at " + BlowsUpOnInject.class.getName() + ".injectInstance(RequestInjectionTest.java:");
        }
    }

    public void testUserExceptionWhileInjectingStatically() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.requestStaticInjection(new Class[]{BlowsUpOnInject.class});
                }
            }});
            RequestInjectionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error injecting method, java.lang.UnsupportedOperationException: Snap", "at " + BlowsUpOnInject.class.getName() + ".injectStatically(RequestInjectionTest.java:");
        }
    }

    public void testEarlyInjectableReferencesWithSameIdentity() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.any(), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                    }
                });
                String fail = new String("better not fail!");
                this.bind(Object.class).toInstance((Object)fail);
                this.bind(String.class).toInstance((Object)fail);
                this.requestInjection(new Object(){
                    @Inject
                    Object obj;
                    @Inject
                    String str;
                });
            }
        }});
    }

    static class BlowsUpOnInject {
        BlowsUpOnInject() {
        }

        @Inject
        void injectInstance() {
            throw new UnsupportedOperationException("Pop");
        }

        @Inject
        static void injectStatically() {
            throw new UnsupportedOperationException("Snap");
        }
    }

    static class HasInjections {
        @Inject
        @ForField
        static int staticField;
        @Inject
        @ForField
        int instanceField;
        static String staticMethod;
        String instanceMethod;

        HasInjections() {
        }

        @Inject
        static void setStaticMethod(@ForMethod String staticMethod) {
            HasInjections.staticMethod = staticMethod;
        }

        @Inject
        void setInstanceS(@ForMethod String instanceS) {
            this.instanceMethod = instanceS;
        }
    }

    static class NeedsRunnable {
        @Inject
        Runnable runnable;

        NeedsRunnable() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface ForMethod {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface ForField {
    }
}

