/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class SerializationTest
extends TestCase {
    public void testAbstractModuleIsSerializable() throws IOException {
        Asserts.reserialize(new MyAbstractModule());
    }

    public void testCreationExceptionIsSerializable() throws IOException {
        Asserts.assertSimilarWhenReserialized((Object)this.createCreationException());
    }

    private CreationException createCreationException() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(List.class);
                }
            }});
            throw new AssertionFailedError();
        }
        catch (CreationException e) {
            return e;
        }
    }

    static class B {
        B() {
        }
    }

    static class A {
        @Inject
        B b;

        A() {
        }
    }

    static class MyAbstractModule
    extends AbstractModule
    implements Serializable {
        MyAbstractModule() {
        }

        protected void configure() {
        }
    }
}

