/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.Message;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeConverterBinding;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class TypeConversionTest
extends TestCase {
    public void testOneConstantInjection() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(NumericValue.class).to("5");
                this.bind(Simple.class);
            }
        }});
        Simple simple = (Simple)injector.getInstance(Simple.class);
        TypeConversionTest.assertEquals((int)5, (int)simple.i);
    }

    public void testConstantInjection() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(NumericValue.class).to("5");
                this.bindConstant().annotatedWith(BooleanValue.class).to("true");
                this.bindConstant().annotatedWith(EnumValue.class).to("TEE");
                this.bindConstant().annotatedWith(ClassName.class).to(Foo.class.getName());
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        this.checkNumbers(foo.integerField, foo.primitiveIntField, foo.longField, foo.primitiveLongField, foo.byteField, foo.primitiveByteField, foo.shortField, foo.primitiveShortField, foo.floatField, Float.valueOf(foo.primitiveFloatField), foo.doubleField, foo.primitiveDoubleField);
        TypeConversionTest.assertEquals((Object)((Object)Bar.TEE), (Object)((Object)foo.enumField));
        TypeConversionTest.assertEquals(Foo.class, foo.classField);
    }

    public void testConstantInjectionWithExplicitBindingsRequired() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireExplicitBindings();
                this.bind(Foo.class);
                this.bindConstant().annotatedWith(NumericValue.class).to("5");
                this.bindConstant().annotatedWith(BooleanValue.class).to("true");
                this.bindConstant().annotatedWith(EnumValue.class).to("TEE");
                this.bindConstant().annotatedWith(ClassName.class).to(Foo.class.getName());
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        this.checkNumbers(foo.integerField, foo.primitiveIntField, foo.longField, foo.primitiveLongField, foo.byteField, foo.primitiveByteField, foo.shortField, foo.primitiveShortField, foo.floatField, Float.valueOf(foo.primitiveFloatField), foo.doubleField, foo.primitiveDoubleField);
        TypeConversionTest.assertEquals((Object)((Object)Bar.TEE), (Object)((Object)foo.enumField));
        TypeConversionTest.assertEquals(Foo.class, foo.classField);
    }

    void checkNumbers(Number ... ns) {
        for (Number n : ns) {
            TypeConversionTest.assertEquals((int)5, (int)n.intValue());
        }
    }

    public void testInvalidInteger() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new OuterErrorModule()});
        try {
            injector.getInstance(InvalidInteger.class);
            TypeConversionTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Error converting 'invalid' (bound at " + InnerErrorModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterErrorModule.class, InnerErrorModule.class), "using TypeConverter<Integer> which matches identicalTo(class java.lang.Integer) (bound at [unknown source]).", "Reason: java.lang.RuntimeException: For input string: \"invalid\"");
        }
    }

    public void testInvalidCharacter() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(NumericValue.class).to("invalid");
            }
        }});
        try {
            injector.getInstance(InvalidCharacter.class);
            TypeConversionTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Error converting 'invalid'");
            Asserts.assertContains(expected.getMessage(), "bound at " + ((Object)((Object)this)).getClass().getName());
            Asserts.assertContains(expected.getMessage(), "to java.lang.Character");
        }
    }

    public void testInvalidEnum() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(NumericValue.class).to("invalid");
            }
        }});
        try {
            injector.getInstance(InvalidEnum.class);
            TypeConversionTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Error converting 'invalid'");
            Asserts.assertContains(expected.getMessage(), "bound at " + ((Object)((Object)this)).getClass().getName());
            Asserts.assertContains(expected.getMessage(), "to " + Bar.class.getName());
        }
    }

    public void testToInstanceIsTreatedLikeConstant() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"5");
                this.bind(LongHolder.class);
            }
        }});
        TypeConversionTest.assertEquals((long)5L, (long)((LongHolder)injector.getInstance(LongHolder.class)).foo);
    }

    public void testCustomTypeConversion() throws CreationException {
        final Date result = new Date();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.convertToTypes(Matchers.only((Object)TypeLiteral.get(Date.class)), TypeConversionTest.this.mockTypeConverter(result));
                this.bindConstant().annotatedWith(NumericValue.class).to("Today");
                this.bind(DateHolder.class);
            }
        }});
        TypeConversionTest.assertSame((Object)result, (Object)((DateHolder)injector.getInstance(DateHolder.class)).date);
        Binding binding = injector.getBinding(Key.get(Date.class, NumericValue.class));
        TypeConversionTest.assertTrue((boolean)(binding instanceof ConvertedConstantBinding));
        TypeConverterBinding converterBinding = ((ConvertedConstantBinding)binding).getTypeConverterBinding();
        TypeConversionTest.assertEquals((String)"CustomConverter", (String)converterBinding.getTypeConverter().toString());
        TypeConversionTest.assertTrue((boolean)injector.getTypeConverterBindings().contains(converterBinding));
    }

    public void testInvalidCustomValue() throws CreationException {
        InvalidCustomValueModule module = new InvalidCustomValueModule();
        try {
            Guice.createInjector((Module[])new Module[]{module});
            TypeConversionTest.fail();
        }
        catch (CreationException expected) {
            Throwable cause = ((Message)Iterables.getOnlyElement((Iterable)expected.getErrorMessages())).getCause();
            TypeConversionTest.assertTrue((boolean)(cause instanceof UnsupportedOperationException));
            Asserts.assertContains(expected.getMessage(), "1) Error converting 'invalid' (bound at ", ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), "to java.util.Date", "using BrokenConverter which matches only(java.util.Date) ", "(bound at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), "Reason: java.lang.UnsupportedOperationException: Cannot convert", "at " + DateHolder.class.getName() + ".date(TypeConversionTest.java:");
        }
    }

    public void testNullCustomValue() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterModule((Module)new ConverterNullModule())});
            TypeConversionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Received null converting 'foo' (bound at ", ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterModule.class, InnerModule.class), "to java.util.Date", "using CustomConverter which matches only(java.util.Date) ", "(bound at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterModule.class, InnerModule.class, ConverterNullModule.class), "at " + DateHolder.class.getName() + ".date(TypeConversionTest.java:", Asserts.asModuleChain(OuterModule.class, InnerModule.class));
        }
    }

    public void testCustomValueTypeMismatch() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterModule((Module)new ConverterCustomModule())});
            TypeConversionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Type mismatch converting 'foo' (bound at ", ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterModule.class, InnerModule.class), "to java.util.Date", "using CustomConverter which matches only(java.util.Date) ", "(bound at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterModule.class, InnerModule.class, ConverterCustomModule.class), "Converter returned -1.", "at " + DateHolder.class.getName() + ".date(TypeConversionTest.java:", Asserts.asModuleChain(OuterModule.class, InnerModule.class));
        }
    }

    public void testStringIsConvertedOnlyOnce() {
        final TypeConverter converter = new TypeConverter(){
            boolean converted = false;

            public Object convert(String value, TypeLiteral<?> toType) {
                if (this.converted) {
                    throw new AssertionFailedError("converted multiple times!");
                }
                this.converted = true;
                return new Date();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.convertToTypes(Matchers.only((Object)TypeLiteral.get(Date.class)), converter);
                this.bindConstant().annotatedWith(NumericValue.class).to("unused");
            }
        }});
        Date first = (Date)injector.getInstance(Key.get(Date.class, NumericValue.class));
        Date second = (Date)injector.getInstance(Key.get(Date.class, NumericValue.class));
        TypeConversionTest.assertSame((Object)first, (Object)second);
    }

    public void testAmbiguousTypeConversion() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterAmbiguousModule()});
            TypeConversionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Multiple converters can convert 'foo' (bound at ", ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterAmbiguousModule.class, InnerAmbiguousModule.class), "to java.util.Date:", "CustomConverter which matches only(java.util.Date) (bound at " + Ambiguous1Module.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterAmbiguousModule.class, InnerAmbiguousModule.class, Ambiguous1Module.class), "and", "CustomConverter which matches only(java.util.Date) (bound at " + Ambiguous2Module.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterAmbiguousModule.class, InnerAmbiguousModule.class, Ambiguous2Module.class), "Please adjust your type converter configuration to avoid overlapping matches.", "at " + DateHolder.class.getName() + ".date(TypeConversionTest.java:");
        }
    }

    TypeConverter mockTypeConverter(final Object result) {
        return new TypeConverter(){

            public Object convert(String value, TypeLiteral<?> toType) {
                return result;
            }

            public String toString() {
                return "CustomConverter";
            }
        };
    }

    private static TypeConverter failingTypeConverter() {
        return new TypeConverter(){

            public Object convert(String value, TypeLiteral<?> toType) {
                throw new UnsupportedOperationException("Cannot convert");
            }

            public String toString() {
                return "BrokenConverter";
            }
        };
    }

    public void testCannotConvertUnannotatedBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"55");
            }
        }});
        try {
            injector.getInstance(Integer.class);
            TypeConversionTest.fail((String)"Converted an unannotated String to an Integer");
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Could not find a suitable constructor in java.lang.Integer.");
        }
    }

    static class DateHolder {
        @Inject
        @NumericValue
        Date date;

        DateHolder() {
        }
    }

    class Ambiguous2Module
    extends AbstractModule {
        Ambiguous2Module() {
        }

        protected void configure() {
            this.convertToTypes(Matchers.only((Object)TypeLiteral.get(Date.class)), TypeConversionTest.this.mockTypeConverter(new Date()));
        }
    }

    class Ambiguous1Module
    extends AbstractModule {
        Ambiguous1Module() {
        }

        protected void configure() {
            this.convertToTypes(Matchers.only((Object)TypeLiteral.get(Date.class)), TypeConversionTest.this.mockTypeConverter(new Date()));
        }
    }

    class InnerAmbiguousModule
    extends AbstractModule {
        InnerAmbiguousModule() {
        }

        protected void configure() {
            this.install((Module)new Ambiguous1Module());
            this.install((Module)new Ambiguous2Module());
            this.bindConstant().annotatedWith(NumericValue.class).to("foo");
            this.bind(DateHolder.class);
        }
    }

    class OuterAmbiguousModule
    extends AbstractModule {
        OuterAmbiguousModule() {
        }

        protected void configure() {
            this.install((Module)new InnerAmbiguousModule());
        }
    }

    class ConverterCustomModule
    extends AbstractModule {
        ConverterCustomModule() {
        }

        protected void configure() {
            this.convertToTypes(Matchers.only((Object)TypeLiteral.get(Date.class)), TypeConversionTest.this.mockTypeConverter(-1));
        }
    }

    class ConverterNullModule
    extends AbstractModule {
        ConverterNullModule() {
        }

        protected void configure() {
            this.convertToTypes(Matchers.only((Object)TypeLiteral.get(Date.class)), TypeConversionTest.this.mockTypeConverter(null));
        }
    }

    static class InnerModule
    extends AbstractModule {
        private final Module converterModule;

        InnerModule(Module converterModule) {
            this.converterModule = converterModule;
        }

        protected void configure() {
            this.install(this.converterModule);
            this.bindConstant().annotatedWith(NumericValue.class).to("foo");
            this.bind(DateHolder.class);
        }
    }

    static class OuterModule
    extends AbstractModule {
        private final Module converterModule;

        OuterModule(Module converterModule) {
            this.converterModule = converterModule;
        }

        protected void configure() {
            this.install((Module)new InnerModule(this.converterModule));
        }
    }

    static class InvalidCustomValueModule
    extends AbstractModule {
        InvalidCustomValueModule() {
        }

        protected void configure() {
            this.convertToTypes(Matchers.only((Object)TypeLiteral.get(Date.class)), TypeConversionTest.failingTypeConverter());
            this.bindConstant().annotatedWith(NumericValue.class).to("invalid");
            this.bind(DateHolder.class);
        }
    }

    static class LongHolder {
        @Inject
        Long foo;

        LongHolder() {
        }
    }

    public static class InvalidEnum {
        @Inject
        @NumericValue
        Bar foo;
    }

    public static class InvalidCharacter {
        @Inject
        @NumericValue
        char foo;
    }

    public static class InvalidInteger {
        @Inject
        @NumericValue
        Integer integerField;
    }

    static class InnerErrorModule
    extends AbstractModule {
        InnerErrorModule() {
        }

        protected void configure() {
            this.bindConstant().annotatedWith(NumericValue.class).to("invalid");
        }
    }

    static class OuterErrorModule
    extends AbstractModule {
        OuterErrorModule() {
        }

        protected void configure() {
            this.install((Module)new InnerErrorModule());
        }
    }

    static class Simple {
        @Inject
        @NumericValue
        int i;

        Simple() {
        }
    }

    public static enum Bar {
        TEE,
        BAZ,
        BOB;

    }

    public static class Foo {
        @Inject
        @BooleanValue
        Boolean booleanField;
        @Inject
        @BooleanValue
        boolean primitiveBooleanField;
        @Inject
        @NumericValue
        Byte byteField;
        @Inject
        @NumericValue
        byte primitiveByteField;
        @Inject
        @NumericValue
        Short shortField;
        @Inject
        @NumericValue
        short primitiveShortField;
        @Inject
        @NumericValue
        Integer integerField;
        @Inject
        @NumericValue
        int primitiveIntField;
        @Inject
        @NumericValue
        Long longField;
        @Inject
        @NumericValue
        long primitiveLongField;
        @Inject
        @NumericValue
        Float floatField;
        @Inject
        @NumericValue
        float primitiveFloatField;
        @Inject
        @NumericValue
        Double doubleField;
        @Inject
        @NumericValue
        double primitiveDoubleField;
        @Inject
        @EnumValue
        Bar enumField;
        @Inject
        @ClassName
        Class<?> classField;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface ClassName {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface EnumValue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface BooleanValue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface NumericValue {
    }
}

