/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.inject.Asserts;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import junit.framework.TestCase;

public class TypeLiteralTest
extends TestCase {
    public List<? extends CharSequence> wildcardExtends;

    public void testWithParameterizedType() {
        TypeLiteral<List<String>> a = new TypeLiteral<List<String>>(){};
        TypeLiteral<List<String>> b = new TypeLiteral<List<String>>((Type)Types.listOf(String.class)){};
        Asserts.assertEqualsBothWays(a, b);
    }

    public void testEquality() {
        TypeLiteral<List<String>> t1 = new TypeLiteral<List<String>>(){};
        TypeLiteral<List<String>> t2 = new TypeLiteral<List<String>>(){};
        TypeLiteral<List<Integer>> t3 = new TypeLiteral<List<Integer>>(){};
        TypeLiteral<String> t4 = new TypeLiteral<String>(){};
        Asserts.assertEqualsBothWays(t1, t2);
        TypeLiteralTest.assertFalse((boolean)t2.equals((Object)t3));
        TypeLiteralTest.assertFalse((boolean)t3.equals((Object)t2));
        TypeLiteralTest.assertFalse((boolean)t2.equals((Object)t4));
        TypeLiteralTest.assertFalse((boolean)t4.equals((Object)t2));
        TypeLiteral t5 = TypeLiteral.get(String.class);
        Asserts.assertEqualsBothWays(t4, t5);
    }

    public void testWithWildcardType() throws NoSuchFieldException, IOException {
        TypeLiteral a = TypeLiteral.get((Type)((Object)((Object)this)).getClass().getField("wildcardExtends").getGenericType());
        TypeLiteral b = TypeLiteral.get((Type)Types.listOf((Type)Types.subtypeOf(CharSequence.class)));
        TypeLiteral<List<? extends CharSequence>> c = new TypeLiteral<List<? extends CharSequence>>(){};
        Asserts.assertEqualsBothWays(a, b);
        Asserts.assertEqualsBothWays(b, c);
        TypeLiteralTest.assertEquals((String)"java.util.List<? extends java.lang.CharSequence>", (String)a.toString());
        TypeLiteralTest.assertEquals((String)"java.util.List<? extends java.lang.CharSequence>", (String)b.toString());
        TypeLiteralTest.assertEquals((String)"java.util.List<? extends java.lang.CharSequence>", (String)c.toString());
        Asserts.assertNotSerializable(a);
        Asserts.assertNotSerializable(b);
        Asserts.assertNotSerializable(c);
    }

    public void testMissingTypeParameter() {
        try {
            new TypeLiteral(){};
            TypeLiteralTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testTypesInvolvingArraysForEquality() {
        TypeLiteral<String[]> stringArray = new TypeLiteral<String[]>(){};
        TypeLiteralTest.assertEquals((Object)stringArray, (Object)new TypeLiteral<String[]>(){});
        TypeLiteral<List<String[]>> listOfStringArray = new TypeLiteral<List<String[]>>(){};
        TypeLiteralTest.assertEquals((Object)listOfStringArray, (Object)new TypeLiteral<List<String[]>>(){});
    }

    public void testEqualityOfGenericArrayAndClassArray() {
        TypeLiteral arrayAsClass = TypeLiteral.get(String[].class);
        TypeLiteral<String[]> arrayAsType = new TypeLiteral<String[]>(){};
        TypeLiteralTest.assertEquals((Object)arrayAsClass, (Object)arrayAsType);
    }

    public void testEqualityOfMultidimensionalGenericArrayAndClassArray() {
        TypeLiteral arrayAsClass = TypeLiteral.get(String[][][].class);
        TypeLiteral<String[][][]> arrayAsType = new TypeLiteral<String[][][]>(){};
        TypeLiteralTest.assertEquals((Object)arrayAsClass, (Object)arrayAsType);
    }

    public void testTypeLiteralsMustHaveRawTypes() {
        try {
            TypeLiteral.get((Type)Types.subtypeOf(Runnable.class));
            TypeLiteralTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "Expected a Class, ParameterizedType, or GenericArrayType, but <? extends java.lang.Runnable> is of type com.google.inject.internal.MoreTypes$WildcardTypeImpl");
        }
    }

    public void testDifferentiationBetweenWrappersAndPrimitives() {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Void.TYPE};
        Class[] wrappers = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Void.class};
        for (int t = 0; t < primitives.length; ++t) {
            TypeLiteral primitiveTl = TypeLiteral.get((Class)primitives[t]);
            TypeLiteral wrapperTl = TypeLiteral.get((Class)wrappers[t]);
            TypeLiteralTest.assertFalse((boolean)primitiveTl.equals((Object)wrapperTl));
            TypeLiteralTest.assertEquals((Object)primitives[t], (Object)primitiveTl.getType());
            TypeLiteralTest.assertEquals((Object)wrappers[t], (Object)wrapperTl.getType());
            TypeLiteralTest.assertEquals((Object)primitives[t], (Object)primitiveTl.getRawType());
            TypeLiteralTest.assertEquals((Object)wrappers[t], (Object)wrapperTl.getRawType());
        }
    }

    public void testSerialization() throws IOException {
        Asserts.assertNotSerializable(new TypeLiteral<List<String>>(){});
    }

    public void testTypeVariableWithNoBound() {
        TypeVariable<Class<T>>[] typeVariables = HasTypeParameters.class.getTypeParameters();
        TypeLiteral aTl = TypeLiteral.get(typeVariables[0]);
        TypeLiteralTest.assertEquals(Object.class, (Object)aTl.getRawType());
        TypeLiteralTest.assertEquals((String)"A", (String)aTl.toString());
        TypeVariable aTv = (TypeVariable)aTl.getType();
        TypeLiteralTest.assertEquals(HasTypeParameters.class, aTv.getGenericDeclaration());
        TypeLiteralTest.assertEquals((String)"A", (String)aTv.getName());
        TypeLiteralTest.assertEquals((Object)ImmutableList.of(Object.class), (Object)ImmutableList.copyOf((Object[])aTv.getBounds()));
        TypeLiteralTest.assertEquals((String)"A", (String)aTv.toString());
        Asserts.assertEqualsBothWays(aTl, TypeLiteral.get(HasTypeParameters.class.getTypeParameters()[0]));
    }

    public void testTypeVariablesWithSingleBound() {
        TypeVariable<Class<T>>[] typeVariables = HasTypeParameters.class.getTypeParameters();
        TypeLiteral cTl = TypeLiteral.get(typeVariables[2]);
        TypeLiteralTest.assertEquals(Object.class, (Object)cTl.getRawType());
        TypeLiteralTest.assertEquals((String)"C", (String)cTl.toString());
        TypeVariable cTv = (TypeVariable)cTl.getType();
        TypeLiteralTest.assertEquals(HasTypeParameters.class, cTv.getGenericDeclaration());
        TypeLiteralTest.assertEquals((String)"C", (String)cTv.getName());
        TypeLiteralTest.assertEquals((Object)ImmutableList.of(Runnable.class), (Object)ImmutableList.copyOf((Object[])cTv.getBounds()));
        TypeLiteralTest.assertEquals((String)"C", (String)cTv.toString());
        Asserts.assertEqualsBothWays(cTl, TypeLiteral.get(HasTypeParameters.class.getTypeParameters()[2]));
    }

    public void testTypeVariableWithMultipleBounds() {
        TypeVariable<Class<T>>[] typeVariables = HasTypeParameters.class.getTypeParameters();
        TypeLiteral bTl = TypeLiteral.get(typeVariables[1]);
        TypeLiteralTest.assertEquals(Object.class, (Object)bTl.getRawType());
        TypeLiteralTest.assertEquals((String)"B", (String)bTl.toString());
        TypeVariable bTv = (TypeVariable)bTl.getType();
        TypeLiteralTest.assertEquals(HasTypeParameters.class, bTv.getGenericDeclaration());
        TypeLiteralTest.assertEquals((String)"B", (String)bTv.getName());
        TypeLiteralTest.assertEquals((Object)ImmutableList.of((Object)Types.listOf(typeVariables[0]), Runnable.class), (Object)ImmutableList.copyOf((Object[])bTv.getBounds()));
        TypeLiteralTest.assertEquals((String)"B", (String)bTv.toString());
        Asserts.assertEqualsBothWays(bTl, TypeLiteral.get(HasTypeParameters.class.getTypeParameters()[1]));
    }

    class HasTypeParameters<A, B extends List<A> & Runnable, C extends Runnable> {
        A a;
        B b;
        C c;

        HasTypeParameters() {
        }
    }
}

