/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.inject.Asserts;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class TypeLiteralTypeResolutionTest
extends TestCase {
    Type arrayListOfString = Types.newParameterizedType(ArrayList.class, (Type[])new Type[]{String.class});
    Type hasGenericFieldsOfShort = Types.newParameterizedTypeWithOwner(((Object)((Object)this)).getClass(), HasGenericFields.class, (Type[])new Type[]{Short.class});
    Type hasGenericConstructorOfShort = Types.newParameterizedTypeWithOwner(((Object)((Object)this)).getClass(), GenericConstructor.class, (Type[])new Type[]{Short.class});
    Type throwerOfNpe = Types.newParameterizedTypeWithOwner(((Object)((Object)this)).getClass(), Thrower.class, (Type[])new Type[]{NullPointerException.class});
    Type hasArrayOfShort = Types.newParameterizedTypeWithOwner(((Object)((Object)this)).getClass(), HasArray.class, (Type[])new Type[]{Short.class});
    Type hasRelatedOfString = Types.newParameterizedTypeWithOwner(((Object)((Object)this)).getClass(), HasRelated.class, (Type[])new Type[]{String.class, String.class});
    Type mapK = Map.class.getTypeParameters()[0];
    Type hashMapK = HashMap.class.getTypeParameters()[0];
    Type setEntryKV;
    Type entryStringInteger = Types.setOf((Type)Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, (Type[])new Type[]{String.class, Integer.class}));
    Field list;
    Field instance;
    Constructor<GenericConstructor> newHasGenericConstructor;
    Constructor<Thrower> newThrower;
    Constructor newString;
    Method stringIndexOf;
    Method comparableCompareTo;
    Method getArray;
    Method getSetOfArray;
    Method echo;
    Method throwS;

    protected void setUp() throws Exception {
        super.setUp();
        this.list = HasGenericFields.class.getField("list");
        this.instance = HasGenericFields.class.getField("instance");
        this.newHasGenericConstructor = GenericConstructor.class.getConstructor(Object.class, Object.class);
        this.newThrower = Thrower.class.getConstructor(new Class[0]);
        this.stringIndexOf = String.class.getMethod("indexOf", String.class);
        this.newString = String.class.getConstructor(String.class);
        this.comparableCompareTo = Comparable.class.getMethod("compareTo", Object.class);
        this.getArray = HasArray.class.getMethod("getArray", new Class[0]);
        this.getSetOfArray = HasArray.class.getMethod("getSetOfArray", new Class[0]);
        this.echo = HasRelated.class.getMethod("echo", Object.class);
        this.throwS = Thrower.class.getMethod("throwS", new Class[0]);
        this.setEntryKV = HashMap.class.getMethod("entrySet", new Class[0]).getGenericReturnType();
    }

    public void testDirectInheritance() throws NoSuchMethodException {
        TypeLiteral resolver = TypeLiteral.get((Type)this.arrayListOfString);
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.listOf(String.class), (Object)resolver.getReturnType(List.class.getMethod("subList", Integer.TYPE, Integer.TYPE)).getType());
        TypeLiteralTypeResolutionTest.assertEquals((Object)ImmutableList.of((Object)TypeLiteral.get(String.class)), (Object)resolver.getParameterTypes((Member)Collection.class.getMethod("add", Object.class)));
    }

    public void testGenericSupertype() {
        TypeLiteral resolver = TypeLiteral.get((Type)this.arrayListOfString);
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.newParameterizedType(Collection.class, (Type[])new Type[]{String.class}), (Object)resolver.getSupertype(Collection.class).getType());
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class}), (Object)resolver.getSupertype(Iterable.class).getType());
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.newParameterizedType(AbstractList.class, (Type[])new Type[]{String.class}), (Object)resolver.getSupertype(AbstractList.class).getType());
        TypeLiteralTypeResolutionTest.assertEquals(Object.class, (Object)resolver.getSupertype(Object.class).getType());
    }

    public void testRecursiveTypeVariable() {
        TypeLiteral resolver = TypeLiteral.get(MyInteger.class);
        TypeLiteralTypeResolutionTest.assertEquals(MyInteger.class, (Object)((TypeLiteral)resolver.getParameterTypes((Member)this.comparableCompareTo).get(0)).getType());
    }

    public void testFields() {
        TypeLiteral resolver = TypeLiteral.get((Type)this.hasGenericFieldsOfShort);
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.listOf(Short.class), (Object)resolver.getFieldType(this.list).getType());
        TypeLiteralTypeResolutionTest.assertEquals(Short.class, (Object)resolver.getFieldType(this.instance).getType());
    }

    public void testGenericConstructor() throws NoSuchMethodException {
        TypeLiteral resolver = TypeLiteral.get((Type)this.hasGenericConstructorOfShort);
        TypeLiteralTypeResolutionTest.assertEquals(Short.class, (Object)((TypeLiteral)resolver.getParameterTypes(this.newHasGenericConstructor).get(0)).getType());
    }

    public void testThrowsExceptions() {
        TypeLiteral type = TypeLiteral.get((Type)this.throwerOfNpe);
        TypeLiteralTypeResolutionTest.assertEquals(NullPointerException.class, (Object)((TypeLiteral)type.getExceptionTypes(this.newThrower).get(0)).getType());
        TypeLiteralTypeResolutionTest.assertEquals(NullPointerException.class, (Object)((TypeLiteral)type.getExceptionTypes((Member)this.throwS).get(0)).getType());
    }

    public void testArrays() {
        TypeLiteral resolver = TypeLiteral.get((Type)this.hasArrayOfShort);
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.arrayOf(Short.class), (Object)resolver.getReturnType(this.getArray).getType());
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.setOf((Type)Types.arrayOf(Short.class)), (Object)resolver.getReturnType(this.getSetOfArray).getType());
    }

    public void testRelatedTypeVariables() {
        TypeLiteral resolver = TypeLiteral.get((Type)this.hasRelatedOfString);
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)((TypeLiteral)resolver.getParameterTypes((Member)this.echo).get(0)).getType());
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)resolver.getReturnType(this.echo).getType());
    }

    public void testCachingAndReindexing() throws NoSuchMethodException {
        TypeLiteral resolver = TypeLiteral.get((Type)Types.newParameterizedTypeWithOwner(((Object)((Object)this)).getClass(), HasLists.class, (Type[])new Type[]{String.class, Short.class}));
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.listOf(String.class), (Object)resolver.getReturnType(HasLists.class.getMethod("listS", new Class[0])).getType());
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.listOf(Short.class), (Object)resolver.getReturnType(HasLists.class.getMethod("listT", new Class[0])).getType());
    }

    public void testUnsupportedQueries() throws NoSuchMethodException {
        TypeLiteral resolver = TypeLiteral.get((Type)this.arrayListOfString);
        try {
            resolver.getExceptionTypes((Member)this.stringIndexOf);
            TypeLiteralTypeResolutionTest.fail();
        }
        catch (IllegalArgumentException e) {
            TypeLiteralTypeResolutionTest.assertEquals((String)"public int java.lang.String.indexOf(java.lang.String) is not defined by a supertype of java.util.ArrayList<java.lang.String>", (String)e.getMessage());
        }
        try {
            resolver.getParameterTypes((Member)this.stringIndexOf);
            TypeLiteralTypeResolutionTest.fail();
        }
        catch (Exception e) {
            TypeLiteralTypeResolutionTest.assertEquals((String)"public int java.lang.String.indexOf(java.lang.String) is not defined by a supertype of java.util.ArrayList<java.lang.String>", (String)e.getMessage());
        }
        try {
            resolver.getReturnType(this.stringIndexOf);
            TypeLiteralTypeResolutionTest.fail();
        }
        catch (Exception e) {
            TypeLiteralTypeResolutionTest.assertEquals((String)"public int java.lang.String.indexOf(java.lang.String) is not defined by a supertype of java.util.ArrayList<java.lang.String>", (String)e.getMessage());
        }
        try {
            resolver.getSupertype(String.class);
            TypeLiteralTypeResolutionTest.fail();
        }
        catch (Exception e) {
            TypeLiteralTypeResolutionTest.assertEquals((String)"class java.lang.String is not a supertype of java.util.ArrayList<java.lang.String>", (String)e.getMessage());
        }
        try {
            resolver.getExceptionTypes((Member)this.newString);
            TypeLiteralTypeResolutionTest.fail();
        }
        catch (Exception e) {
            TypeLiteralTypeResolutionTest.assertEquals((String)"public java.lang.String(java.lang.String) does not construct a supertype of java.util.ArrayList<java.lang.String>", (String)e.getMessage());
        }
        try {
            resolver.getParameterTypes((Member)this.newString);
            TypeLiteralTypeResolutionTest.fail();
        }
        catch (Exception e) {
            TypeLiteralTypeResolutionTest.assertEquals((String)"public java.lang.String(java.lang.String) does not construct a supertype of java.util.ArrayList<java.lang.String>", (String)e.getMessage());
        }
    }

    public void testResolve() {
        TypeLiteral typeResolver = TypeLiteral.get(StringIntegerMap.class);
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)typeResolver.resolveType(this.mapK));
        typeResolver = new TypeLiteral<Map<String, Integer>>(){};
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)typeResolver.resolveType(this.mapK));
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.mapOf(String.class, Integer.class), (Object)typeResolver.getSupertype(Map.class).getType());
        typeResolver = new TypeLiteral<BetterMap<String, Integer>>(){};
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)typeResolver.resolveType(this.mapK));
        typeResolver = new TypeLiteral<BestMap<String, Integer>>(){};
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)typeResolver.resolveType(this.mapK));
        typeResolver = TypeLiteral.get(StringIntegerHashMap.class);
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)typeResolver.resolveType(this.mapK));
        TypeLiteralTypeResolutionTest.assertEquals(String.class, (Object)typeResolver.resolveType(this.hashMapK));
        TypeLiteralTypeResolutionTest.assertEquals((Object)this.entryStringInteger, (Object)typeResolver.resolveType(this.setEntryKV));
        TypeLiteralTypeResolutionTest.assertEquals(Object.class, (Object)typeResolver.getSupertype(Object.class).getType());
    }

    public void testOnObject() {
        TypeLiteral typeResolver = TypeLiteral.get(Object.class);
        TypeLiteralTypeResolutionTest.assertEquals(Object.class, (Object)typeResolver.getSupertype(Object.class).getType());
        TypeLiteralTypeResolutionTest.assertEquals(Object.class, (Object)typeResolver.getRawType());
        typeResolver = TypeLiteral.get((Type)Types.setOf(Integer.class));
        TypeLiteralTypeResolutionTest.assertEquals(Object.class, (Object)typeResolver.getSupertype(Object.class).getType());
    }

    public void testGetSupertype() {
        TypeLiteral<AbstractList<String>> listOfString = new TypeLiteral<AbstractList<String>>(){};
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.newParameterizedType(AbstractCollection.class, (Type[])new Type[]{String.class}), (Object)listOfString.getSupertype(AbstractCollection.class).getType());
        TypeLiteral arrayListOfE = TypeLiteral.get((Type)Types.newParameterizedType(ArrayList.class, (Type[])ArrayList.class.getTypeParameters()));
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.newParameterizedType(AbstractCollection.class, (Type[])ArrayList.class.getTypeParameters()), (Object)arrayListOfE.getSupertype(AbstractCollection.class).getType());
    }

    public void testGetSupertypeForArraysAsList() {
        Class<?> arraysAsListClass = Arrays.asList(new Object[0]).getClass();
        TypeVariable<Class<?>> anotherE = arraysAsListClass.getTypeParameters()[0];
        TypeLiteral type = TypeLiteral.get((Type)Types.newParameterizedType(AbstractList.class, (Type[])new Type[]{anotherE}));
        TypeLiteralTypeResolutionTest.assertEquals((Object)Types.newParameterizedType(AbstractCollection.class, (Type[])new Type[]{anotherE}), (Object)type.getSupertype(AbstractCollection.class).getType());
    }

    public void testWildcards() throws NoSuchFieldException {
        TypeLiteral<Parameterized<String>> ofString = new TypeLiteral<Parameterized<String>>(){};
        TypeLiteralTypeResolutionTest.assertEquals((Object)new TypeLiteral<List<String>>(){}.getType(), (Object)ofString.getFieldType(Parameterized.class.getField("t")).getType());
        TypeLiteralTypeResolutionTest.assertEquals((Object)new TypeLiteral<List<? extends String>>(){}.getType(), (Object)ofString.getFieldType(Parameterized.class.getField("extendsT")).getType());
        TypeLiteralTypeResolutionTest.assertEquals((Object)new TypeLiteral<List<? super String>>(){}.getType(), (Object)ofString.getFieldType(Parameterized.class.getField("superT")).getType());
    }

    public void testEqualsAndHashCode() throws IOException {
        TypeLiteral a1 = TypeLiteral.get((Type)this.arrayListOfString);
        TypeLiteral a2 = TypeLiteral.get((Type)this.arrayListOfString);
        TypeLiteral b = TypeLiteral.get((Type)Types.listOf(String.class));
        Asserts.assertEqualsBothWays(a1, a2);
        Asserts.assertNotSerializable(a1);
        TypeLiteralTypeResolutionTest.assertFalse((boolean)a1.equals((Object)b));
    }

    static class Parameterized<T> {
        public List<T> t;
        public List<? extends T> extendsT;
        public List<? super T> superT;

        Parameterized() {
        }
    }

    static class StringIntegerHashMap
    extends HashMap<String, Integer> {
        StringIntegerHashMap() {
        }
    }

    static interface BestMap<K2, V2>
    extends BetterMap<K2, V2> {
    }

    static interface BetterMap<K1, V1>
    extends Map<K1, V1> {
    }

    static interface StringIntegerMap
    extends Map<String, Integer> {
    }

    static interface HasLists<S, T> {
        public List<S> listS();

        public List<T> listT();

        public List<Map.Entry<S, T>> listEntries();
    }

    static interface HasRelated<T, R extends T> {
        public T echo(R var1);
    }

    static interface HasArray<T extends Number> {
        public T[] getArray();

        public Set<T[]> getSetOfArray();
    }

    static class Thrower<S extends Exception> {
        public void throwS() throws S {
        }
    }

    static class GenericConstructor<S> {
        public <T> GenericConstructor(S s, T t) {
        }
    }

    static class HasGenericFields<T> {
        public List<T> list;
        public T instance;

        HasGenericFields() {
        }
    }

    static class MyInteger
    implements MyComparable<MyInteger> {
        int value;

        MyInteger() {
        }

        @Override
        public int compareTo(MyInteger o) {
            return this.value - o.value;
        }
    }

    static interface MyComparable<E extends MyComparable<E>>
    extends Comparable<E> {
    }
}

