/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.internal.CycleDetectingLock;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;

public class CycleDetectingLockTest
extends TestCase {
    static final long DEADLOCK_TIMEOUT_SECONDS = 1L;

    public void testSingletonThreadsRuntimeCircularDependency() throws Exception {
        final CyclicBarrier signal1 = new CyclicBarrier(2);
        final CyclicBarrier signal2 = new CyclicBarrier(2);
        final CyclicBarrier signal3 = new CyclicBarrier(2);
        CycleDetectingLock.CycleDetectingLockFactory lockFactory = new CycleDetectingLock.CycleDetectingLockFactory();
        CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock lockA = new CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock(lockFactory, (Object)"A", (Lock)new ReentrantLock(){

            @Override
            public void lock() {
                if (Thread.currentThread().getName().equals("T2")) {
                    try {
                        signal3.await(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    TestCase.assertEquals((String)"T1", (String)Thread.currentThread().getName());
                }
                super.lock();
            }
        });
        CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock lockB = new CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock(lockFactory, (Object)"B", (Lock)new ReentrantLock(){

            @Override
            public void lock() {
                if (Thread.currentThread().getName().equals("T1")) {
                    try {
                        signal2.await(1L, TimeUnit.SECONDS);
                        signal3.await(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    TestCase.assertEquals((String)"T2", (String)Thread.currentThread().getName());
                }
                super.lock();
            }
        });
        Future<Void> firstThreadResult = Executors.newSingleThreadExecutor().submit(new Callable<Void>((CycleDetectingLock)lockA, (CycleDetectingLock)lockB){
            final /* synthetic */ CycleDetectingLock val$lockA;
            final /* synthetic */ CycleDetectingLock val$lockB;
            {
                this.val$lockA = cycleDetectingLock;
                this.val$lockB = cycleDetectingLock2;
            }

            @Override
            public Void call() throws Exception {
                Thread.currentThread().setName("T1");
                signal1.await(1L, TimeUnit.SECONDS);
                TestCase.assertTrue((boolean)this.val$lockA.lockOrDetectPotentialLocksCycle().isEmpty());
                TestCase.assertTrue((boolean)this.val$lockB.lockOrDetectPotentialLocksCycle().isEmpty());
                this.val$lockB.unlock();
                this.val$lockA.unlock();
                return null;
            }
        });
        Future<Void> secondThreadResult = Executors.newSingleThreadExecutor().submit(new Callable<Void>((CycleDetectingLock)lockB, signal1, signal2, (CycleDetectingLock)lockA){
            final /* synthetic */ CycleDetectingLock val$lockB;
            final /* synthetic */ CyclicBarrier val$signal1;
            final /* synthetic */ CyclicBarrier val$signal2;
            final /* synthetic */ CycleDetectingLock val$lockA;
            {
                this.val$lockB = cycleDetectingLock;
                this.val$signal1 = cyclicBarrier;
                this.val$signal2 = cyclicBarrier2;
                this.val$lockA = cycleDetectingLock2;
            }

            @Override
            public Void call() throws Exception {
                Thread.currentThread().setName("T2");
                TestCase.assertTrue((boolean)this.val$lockB.lockOrDetectPotentialLocksCycle().isEmpty());
                this.val$signal1.await(1L, TimeUnit.SECONDS);
                this.val$signal2.await(1L, TimeUnit.SECONDS);
                this.val$lockB.unlock();
                TestCase.assertTrue((boolean)this.val$lockA.lockOrDetectPotentialLocksCycle().isEmpty());
                this.val$lockA.unlock();
                return null;
            }
        });
        firstThreadResult.get(3L, TimeUnit.SECONDS);
        secondThreadResult.get(3L, TimeUnit.SECONDS);
    }

    public void testCycleDetectingLockFactoriesDoNotDeadlock() throws Exception {
        CycleDetectingLock.CycleDetectingLockFactory factoryA = new CycleDetectingLock.CycleDetectingLockFactory();
        final CycleDetectingLock lockA = factoryA.create((Object)"A");
        CycleDetectingLock.CycleDetectingLockFactory factoryB = new CycleDetectingLock.CycleDetectingLockFactory();
        final CycleDetectingLock lockB = factoryB.create((Object)"B");
        final CyclicBarrier eachThreadAcquiredFirstLock = new CyclicBarrier(2);
        Future<Boolean> threadA = Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Thread.currentThread().setName("A");
                TestCase.assertTrue((boolean)lockA.lockOrDetectPotentialLocksCycle().isEmpty());
                eachThreadAcquiredFirstLock.await(1L, TimeUnit.SECONDS);
                boolean isEmpty = lockB.lockOrDetectPotentialLocksCycle().isEmpty();
                if (isEmpty) {
                    lockB.unlock();
                }
                lockA.unlock();
                return isEmpty;
            }
        });
        Future<Boolean> threadB = Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Thread.currentThread().setName("B");
                TestCase.assertTrue((boolean)lockB.lockOrDetectPotentialLocksCycle().isEmpty());
                eachThreadAcquiredFirstLock.await(1L, TimeUnit.SECONDS);
                boolean isEmpty = lockA.lockOrDetectPotentialLocksCycle().isEmpty();
                if (isEmpty) {
                    lockA.unlock();
                }
                lockB.unlock();
                return isEmpty;
            }
        });
        boolean deadlockADetected = threadA.get(2L, TimeUnit.SECONDS);
        boolean deadlockBDetected = threadB.get(2L, TimeUnit.SECONDS);
        CycleDetectingLockTest.assertTrue((String)"Deadlock should get detected", (deadlockADetected || deadlockBDetected ? 1 : 0) != 0);
        CycleDetectingLockTest.assertTrue((String)"One deadlock should get detected", (deadlockADetected != deadlockBDetected ? 1 : 0) != 0);
    }
}

