/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.Map;
import junit.framework.TestCase;

public class InjectorSpiTest
extends TestCase {
    public void testExistingBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class);
                this.bind(Baz.class);
            }
        }});
        for (Map.Entry entry : injector.getAllBindings().entrySet()) {
            InjectorSpiTest.assertSame(entry.getValue(), (Object)injector.getExistingBinding((Key)entry.getKey()));
        }
        Binding binding = injector.getExistingBinding(Key.get(Foo.class));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Foo.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertTrue((boolean)injector.getAllBindings().containsKey(Key.get((TypeLiteral)new TypeLiteral<Provider<Foo>>(){})));
        binding = injector.getExistingBinding(Key.get((TypeLiteral)new TypeLiteral<Provider<Foo>>(){}));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Provider.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertEquals(Foo.class, ((Provider)binding.getProvider().get()).get().getClass());
        binding = injector.getExistingBinding(Key.get(Baz.class));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Baz.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertFalse((boolean)injector.getAllBindings().containsKey(Key.get((TypeLiteral)new TypeLiteral<Provider<Baz>>(){})));
        binding = injector.getExistingBinding(Key.get((TypeLiteral)new TypeLiteral<Provider<Baz>>(){}));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Provider.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertEquals(Baz.class, ((Provider)binding.getProvider().get()).get().getClass());
        InjectorSpiTest.assertNull((Object)injector.getExistingBinding(Key.get(Bar.class)));
        InjectorSpiTest.assertNull((Object)injector.getExistingBinding(Key.get((TypeLiteral)new TypeLiteral<Provider<Bar>>(){})));
    }

    private static class Baz {
        @Inject
        Provider<Foo> fooP;

        private Baz() {
        }
    }

    private static class Bar {
        private Bar() {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }
}

