/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Exposed;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Member;
import java.util.Set;
import junit.framework.TestCase;

public class ModuleAnnotatedMethodScannerTest
extends TestCase {
    public void testScanning() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
            }

            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }

            @TestProvides
            @Named(value="foo2")
            String foo2() {
                return "foo2";
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module, NamedMunger.module()});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
        this.assertMungedBinding(injector, String.class, "foo2", "foo2");
        Binding fooBinding = injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"foo-munged")));
        Binding foo2Binding = injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"foo2-munged")));
        ModuleAnnotatedMethodScannerTest.assertEquals((String)this.methodName(TestProvides.class, "foo", module), (String)fooBinding.getProvider().toString());
        ModuleAnnotatedMethodScannerTest.assertEquals((String)this.methodName(TestProvides.class, "foo2", module), (String)foo2Binding.getProvider().toString());
    }

    public void testSkipSources() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new AbstractModule(){

                    protected void configure() {
                    }

                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module, NamedMunger.module()});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testWithSource() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.binder().withSource((Object)"source").install((Module)new AbstractModule(){

                    protected void configure() {
                    }

                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module, NamedMunger.module()});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testMoreThanOneClaimedAnnotationFails() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
            }

            @TestProvides
            @TestProvides2
            String foo() {
                return "foo";
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module, NamedMunger.module()});
            ModuleAnnotatedMethodScannerTest.fail();
        }
        catch (CreationException expected) {
            ModuleAnnotatedMethodScannerTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            Asserts.assertContains(expected.getMessage(), "More than one annotation claimed by NamedMunger on method " + module.getClass().getName() + ".foo(). Methods can only have " + "one annotation claimed per scanner.");
        }
    }

    private String methodName(Class<? extends Annotation> annotation, String method, Object container) throws Exception {
        return "@" + annotation.getName() + " " + StackTraceElements.forMember((Member)container.getClass().getDeclaredMethod(method, new Class[0]));
    }

    private void assertMungedBinding(Injector injector, Class<?> clazz, String originalName, Object expectedValue) {
        ModuleAnnotatedMethodScannerTest.assertNull((Object)injector.getExistingBinding(Key.get(clazz, (Annotation)Names.named((String)originalName))));
        Binding fooBinding = injector.getBinding(Key.get(clazz, (Annotation)Names.named((String)(originalName + "-munged"))));
        ModuleAnnotatedMethodScannerTest.assertEquals((Object)expectedValue, (Object)fooBinding.getProvider().get());
    }

    public void testFailingScanner() {
        try {
            Guice.createInjector((Module[])new Module[]{new SomeModule(), FailingScanner.module()});
            ModuleAnnotatedMethodScannerTest.fail();
        }
        catch (CreationException expected) {
            Message m = (Message)Iterables.getOnlyElement((Iterable)expected.getErrorMessages());
            ModuleAnnotatedMethodScannerTest.assertEquals((String)"An exception was caught and reported. Message: Failing in the scanner.", (String)m.getMessage());
            ModuleAnnotatedMethodScannerTest.assertEquals(IllegalStateException.class, m.getCause().getClass());
            ElementSource source = (ElementSource)Iterables.getOnlyElement((Iterable)m.getSources());
            ModuleAnnotatedMethodScannerTest.assertEquals((String)SomeModule.class.getName(), (String)((String)Iterables.getOnlyElement((Iterable)source.getModuleClassNames())));
            ModuleAnnotatedMethodScannerTest.assertEquals((String)(String.class.getName() + " " + SomeModule.class.getName() + ".aString()"), (String)source.toString());
        }
    }

    public void testChildInjectorInheritsScanner() {
        Injector parent = Guice.createInjector((Module[])new Module[]{NamedMunger.module()});
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
            }

            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }});
        this.assertMungedBinding(child, String.class, "foo", "foo");
    }

    public void testChildInjectorScannersDontImpactSiblings() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
            }

            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        };
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[]{NamedMunger.module(), module});
        this.assertMungedBinding(child, String.class, "foo", "foo");
        Injector sibling = parent.createChildInjector(new Module[]{module});
        ModuleAnnotatedMethodScannerTest.assertNull((Object)sibling.getExistingBinding(Key.get(String.class, (Annotation)Names.named((String)"foo"))));
        ModuleAnnotatedMethodScannerTest.assertNull((Object)sibling.getExistingBinding(Key.get(String.class, (Annotation)Names.named((String)"foo-munged"))));
    }

    public void testPrivateModuleInheritScanner_usingPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{NamedMunger.module(), new PrivateModule(){

            protected void configure() {
            }

            @Exposed
            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModule_skipSourcesWithinPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{NamedMunger.module(), new PrivateModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new AbstractModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModule_skipSourcesForPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{NamedMunger.module(), new AbstractModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new PrivateModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModuleInheritScanner_usingPrivateBinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{NamedMunger.module(), new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().install((Module)new AbstractModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModuleInheritScanner_skipSourcesFromPrivateBinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{NamedMunger.module(), new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new AbstractModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModuleInheritScanner_skipSourcesFromPrivateBinder2() {
        Injector injector = Guice.createInjector((Module[])new Module[]{NamedMunger.module(), new AbstractModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).newPrivateBinder().install((Module)new AbstractModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModuleScannersDontImpactSiblings_usingPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            protected void configure() {
                this.install(NamedMunger.module());
            }

            @Exposed
            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }, new PrivateModule(){

            protected void configure() {
            }

            @Exposed
            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModuleScannersDontImpactSiblings_usingPrivateBinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().install((Module)new AbstractModule(){

                    protected void configure() {
                        this.install(NamedMunger.module());
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }, new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().install((Module)new AbstractModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    public void testPrivateModuleWithinPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{NamedMunger.module(), new PrivateModule(){

            protected void configure() {
                this.expose(Key.get(String.class, (Annotation)Names.named((String)"foo-munged")));
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    static class SomeModule
    extends AbstractModule {
        SomeModule() {
        }

        @TestProvides
        String aString() {
            return "Foo";
        }

        protected void configure() {
        }
    }

    public static class FailingScanner
    extends ModuleAnnotatedMethodScanner {
        static Module module() {
            return new AbstractModule(){

                protected void configure() {
                    this.binder().scanModulesForAnnotatedMethods((ModuleAnnotatedMethodScanner)new FailingScanner());
                }
            };
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(TestProvides.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation rawAnnotation, Key<T> key, InjectionPoint injectionPoint) {
            throw new IllegalStateException("Failing in the scanner.");
        }
    }

    private static class NamedMunger
    extends ModuleAnnotatedMethodScanner {
        private NamedMunger() {
        }

        static Module module() {
            return new AbstractModule(){

                protected void configure() {
                    this.binder().scanModulesForAnnotatedMethods((ModuleAnnotatedMethodScanner)new NamedMunger());
                }
            };
        }

        public String toString() {
            return "NamedMunger";
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(TestProvides.class, TestProvides2.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            return Key.get((TypeLiteral)key.getTypeLiteral(), (Annotation)Names.named((String)(((Named)key.getAnnotation()).value() + "-munged")));
        }
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestProvides2 {
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestProvides {
    }
}

