/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.FailingBindingScopingVisitor;
import com.google.inject.spi.FailingElementVisitor;
import com.google.inject.spi.FailingTargetVisitor;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class SpiBindingsTest
extends TestCase {
    private final ImmutableSet<Key<?>> BUILT_IN_BINDINGS = ImmutableSet.of((Object)Key.get(Injector.class), (Object)Key.get(Stage.class), (Object)Key.get(Logger.class));
    private final Comparator<Binding<?>> orderByKey = new Comparator<Binding<?>>(){

        @Override
        public int compare(Binding<?> a, Binding<?> b) {
            return a.getKey().toString().compareTo(b.getKey().toString());
        }
    };

    public void testBindConstant() {
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"one")).to(1);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertTrue((boolean)(binding instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Integer.class, (Annotation)Names.named((String)"one")), (Object)binding.getKey());
                return null;
            }
        }});
    }

    public void testToInstanceBinding() {
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertTrue((boolean)(binding instanceof InstanceBinding));
                SpiBindingsTest.this.checkBindingSource(binding);
                TestCase.assertEquals((Object)Key.get(String.class), (Object)binding.getKey());
                binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(InstanceBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)"A", (Object)binding.getInstance());
                        return null;
                    }
                });
                binding.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(){

                    @Override
                    public Void visitEagerSingleton() {
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testToProviderBinding() {
        final StringProvider stringProvider = new StringProvider();
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider(stringProvider);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertTrue((boolean)(binding instanceof ProviderInstanceBinding));
                SpiBindingsTest.this.checkBindingSource(binding);
                TestCase.assertEquals((Object)Key.get(String.class), (Object)binding.getKey());
                binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ProviderInstanceBinding<? extends T> binding) {
                        TestCase.assertSame((Object)stringProvider, (Object)binding.getUserSuppliedProvider());
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testToProviderKeyBinding() {
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider(StringProvider.class);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertTrue((boolean)(binding instanceof ProviderKeyBinding));
                SpiBindingsTest.this.checkBindingSource(binding);
                TestCase.assertEquals((Object)Key.get(String.class), (Object)binding.getKey());
                binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ProviderKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)Key.get(StringProvider.class), (Object)binding.getProviderKey());
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testToKeyBinding() {
        final Key aKey = Key.get(String.class, (Annotation)Names.named((String)"a"));
        final Key bKey = Key.get(String.class, (Annotation)Names.named((String)"b"));
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bind(aKey).to(bKey);
                this.bind(bKey).toInstance((Object)"B");
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertTrue((boolean)(binding instanceof LinkedKeyBinding));
                SpiBindingsTest.this.checkBindingSource(binding);
                TestCase.assertEquals((Object)aKey, (Object)binding.getKey());
                binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(LinkedKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)bKey, (Object)binding.getLinkedKey());
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertEquals((Object)bKey, (Object)binding.getKey());
                return null;
            }
        }});
    }

    public void testToConstructorBinding() {
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bind(D.class);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertTrue((boolean)(binding instanceof ConstructorBinding));
                SpiBindingsTest.this.checkBindingSource(binding);
                TestCase.assertEquals((Object)Key.get(D.class), (Object)binding.getKey());
                binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ConstructorBinding<? extends T> binding) {
                        Constructor<?> expected = D.class.getDeclaredConstructors()[0];
                        TestCase.assertEquals(expected, (Object)binding.getConstructor().getMember());
                        TestCase.assertEquals((Object)ImmutableSet.of(), (Object)binding.getInjectableMembers());
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testConstantBinding() {
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"one")).to(1);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertTrue((boolean)(binding instanceof InstanceBinding));
                SpiBindingsTest.this.checkBindingSource(binding);
                TestCase.assertEquals((Object)Key.get(Integer.class, (Annotation)Names.named((String)"one")), (Object)binding.getKey());
                binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(InstanceBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)1, (Object)binding.getInstance());
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testConvertedConstantBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"one")).to("1");
            }
        }});
        Binding binding = injector.getBinding(Key.get(Integer.class, (Annotation)Names.named((String)"one")));
        SpiBindingsTest.assertEquals((Object)Key.get(Integer.class, (Annotation)Names.named((String)"one")), (Object)binding.getKey());
        this.checkBindingSource(binding);
        SpiBindingsTest.assertTrue((boolean)(binding instanceof ConvertedConstantBinding));
        binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<Integer>(){

            public Void visit(ConvertedConstantBinding<? extends Integer> binding) {
                TestCase.assertEquals((Object)1, (Object)binding.getValue());
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"one")), (Object)binding.getSourceKey());
                return null;
            }
        });
    }

    public void testProviderBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
            }
        }});
        Key<Provider<String>> providerOfStringKey = new Key<Provider<String>>(){};
        Binding binding = injector.getBinding((Key)providerOfStringKey);
        SpiBindingsTest.assertEquals((Object)providerOfStringKey, (Object)binding.getKey());
        this.checkBindingSource(binding);
        SpiBindingsTest.assertTrue((boolean)(binding instanceof ProviderBinding));
        binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<Provider<String>>(){

            public Void visit(ProviderBinding<? extends Provider<String>> binding) {
                TestCase.assertEquals((Object)Key.get(String.class), (Object)binding.getProvidedKey());
                return null;
            }
        });
    }

    public void testScopes() {
        this.checkInjector((Module)new AbstractModule(){

            protected void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"a")).toProvider(StringProvider.class).in(Singleton.class);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"b")).toProvider(StringProvider.class).in(Scopes.SINGLETON);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"c")).toProvider(StringProvider.class).asEagerSingleton();
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"d")).toProvider(StringProvider.class);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"a")), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(){

                    @Override
                    public Void visitScope(Scope scope) {
                        TestCase.assertSame((Object)Scopes.SINGLETON, (Object)scope);
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"b")), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(){

                    @Override
                    public Void visitScope(Scope scope) {
                        TestCase.assertSame((Object)Scopes.SINGLETON, (Object)scope);
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"c")), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(){

                    @Override
                    public Void visitEagerSingleton() {
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"d")), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(){

                    @Override
                    public Void visitNoScoping() {
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testExtensionSpi() {
        final AtomicBoolean visiting = new AtomicBoolean(false);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider((Provider)new ProviderWithExtensionVisitor<String>(){

                    public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
                        TestCase.assertSame((Object)this, (Object)binding.getUserSuppliedProvider());
                        if (visiting.get()) {
                            TestCase.assertTrue((String)("visitor: " + visitor), (boolean)(visitor instanceof FailingSpiTargetVisitor));
                            return (V)"visited";
                        }
                        return (V)visitor.visit(binding);
                    }

                    public String get() {
                        return "FooBar";
                    }
                });
            }
        }});
        visiting.set(true);
        Key<Provider<String>> providerOfStringKey = new Key<Provider<String>>(){};
        Binding providerBinding = injector.getBinding((Key)providerOfStringKey);
        SpiBindingsTest.assertEquals((Object)providerOfStringKey, (Object)providerBinding.getKey());
        this.checkBindingSource(providerBinding);
        SpiBindingsTest.assertTrue((String)("binding: " + providerBinding), (boolean)(providerBinding instanceof ProviderBinding));
        providerBinding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<Provider<String>>(){

            public Void visit(ProviderBinding<? extends Provider<String>> binding) {
                TestCase.assertEquals((Object)Key.get(String.class), (Object)binding.getProvidedKey());
                return null;
            }
        });
        Binding binding = injector.getBinding(String.class);
        SpiBindingsTest.assertEquals((Object)Key.get(String.class), (Object)binding.getKey());
        this.checkBindingSource(binding);
        SpiBindingsTest.assertTrue((boolean)(binding instanceof ProviderInstanceBinding));
        SpiBindingsTest.assertEquals((String)"visited", (String)((String)binding.acceptTargetVisitor(new FailingSpiTargetVisitor())));
    }

    public void checkBindingSource(Binding binding) {
        Asserts.assertContains(binding.getSource().toString(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        ElementSource source = (ElementSource)binding.getSource();
        SpiBindingsTest.assertFalse((boolean)source.getModuleClassNames().isEmpty());
        if (Asserts.isIncludeStackTraceComplete()) {
            SpiBindingsTest.assertTrue((source.getStackTrace().length > 0 ? 1 : 0) != 0);
        } else {
            SpiBindingsTest.assertEquals((int)0, (int)source.getStackTrace().length);
        }
    }

    public void checkInjector(Module module, ElementVisitor<?> ... visitors) {
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        ArrayList bindings = Lists.newArrayList(injector.getBindings().values());
        Iterator i = bindings.iterator();
        while (i.hasNext()) {
            if (!this.BUILT_IN_BINDINGS.contains((Object)((Binding)i.next()).getKey())) continue;
            i.remove();
        }
        Collections.sort(bindings, this.orderByKey);
        SpiBindingsTest.assertEquals((int)bindings.size(), (int)visitors.length);
        for (int i2 = 0; i2 < visitors.length; ++i2) {
            ElementVisitor<?> visitor = visitors[i2];
            Binding binding = (Binding)bindings.get(i2);
            binding.acceptVisitor(visitor);
        }
    }

    private static class D
    extends C {
        @Inject
        public D(Injector unused) {
        }
    }

    private static class C {
        private C() {
        }
    }

    private static class StringProvider
    implements Provider<String> {
        private StringProvider() {
        }

        public String get() {
            return "A";
        }
    }

    private static class FailingSpiTargetVisitor<T>
    extends DefaultBindingTargetVisitor<T, String> {
        private FailingSpiTargetVisitor() {
        }

        protected String visitOther(Binding<? extends T> binding) {
            throw new AssertionFailedError();
        }
    }
}

