/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.guice;

import aQute.bnd.main.bnd;
import com.googlecode.guice.bundle.OSGiTestActivator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.imageio.spi.ServiceRegistry;
import junit.framework.TestCase;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class OSGiContainerTest
extends TestCase {
    static final String VERSION = System.getProperty("version", "snapshot");
    static final String BUILD_DIR = System.getProperty("build.dir", "build");
    static final String BUILD_DIST_DIR = BUILD_DIR + "/dist";
    static final String BUILD_TEST_DIR = BUILD_DIR + "/test";
    static final String GUICE_JAR = BUILD_DIST_DIR + "/guice-" + VERSION + ".jar";
    static final String AOPALLIANCE_JAR = System.getProperty("aopalliance.jar", "lib/aopalliance.jar");
    static final String JAVAX_INJECT_JAR = System.getProperty("javax.inject.jar", "lib/javax.inject.jar");
    static final String GUAVA_JAR = System.getProperty("guava.jar", "lib/guava-19.0.jar");

    protected void setUp() throws Exception {
        OSGiContainerTest.assertTrue((String)this.failMsg(), (boolean)new File(BUILD_DIR).isDirectory());
        OSGiContainerTest.assertTrue((String)this.failMsg(), (boolean)new File(GUICE_JAR).isFile());
        OSGiContainerTest.assertTrue((String)this.failMsg(), (boolean)new File(AOPALLIANCE_JAR).isFile());
        OSGiContainerTest.assertTrue((String)this.failMsg(), (boolean)new File(JAVAX_INJECT_JAR).isFile());
        OSGiContainerTest.assertTrue((String)this.failMsg(), (boolean)new File(GUAVA_JAR).isFile());
        Properties instructions = new Properties();
        instructions.setProperty("Export-Package", "org.aopalliance.*");
        OSGiContainerTest.buildBundle("aopalliance", instructions, AOPALLIANCE_JAR);
        instructions.clear();
        instructions.setProperty("Export-Package", "javax.inject.*");
        OSGiContainerTest.buildBundle("javax.inject", instructions, JAVAX_INJECT_JAR);
        instructions.clear();
        instructions.setProperty("Export-Package", "com.google.common.*");
        instructions.setProperty("Import-Package", "*;resolution:=optional");
        OSGiContainerTest.buildBundle("guava", instructions, GUAVA_JAR);
        instructions.clear();
        instructions.setProperty("Import-Package", "org.osgi.framework,org.aopalliance.intercept,com.google.inject(|.binder|.matcher|.name)");
        instructions.setProperty("Bundle-Activator", OSGiTestActivator.class.getName());
        instructions.setProperty("Private-Package", OSGiTestActivator.class.getPackage().getName());
        OSGiContainerTest.buildBundle("osgitests", instructions, BUILD_TEST_DIR);
        instructions.clear();
    }

    private static void buildBundle(String name, Properties instructions, String classpath) throws IOException {
        String bndFileName = BUILD_TEST_DIR + '/' + name + ".bnd";
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(bndFileName));
        instructions.store(os, "BND instructions");
        ((OutputStream)os).close();
        bnd.main((String[])new String[]{"-failok", "build", "-classpath", classpath, bndFileName});
    }

    private String failMsg() {
        return "This test may fail if it is not run from ant, or if it is not run after ant has compiled & built jars. This is because the test is validating that the Guice jar is properly setup to load in an OSGi container";
    }

    public void testGuiceWorksInOSGiContainer() throws Throwable {
        Properties properties = new Properties();
        properties.setProperty("org.osgi.framework.storage", BUILD_TEST_DIR + "/bundle.cache");
        properties.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
        Iterator<FrameworkFactory> f = ServiceRegistry.lookupProviders(FrameworkFactory.class);
        while (f.hasNext()) {
            Framework framework = f.next().newFramework((Map)properties);
            framework.start();
            BundleContext systemContext = framework.getBundleContext();
            systemContext.installBundle("reference:file:" + BUILD_TEST_DIR + "/aopalliance.jar");
            systemContext.installBundle("reference:file:" + BUILD_TEST_DIR + "/javax.inject.jar");
            systemContext.installBundle("reference:file:" + BUILD_TEST_DIR + "/guava.jar");
            systemContext.installBundle("reference:file:" + GUICE_JAR);
            systemContext.installBundle("reference:file:" + BUILD_TEST_DIR + "/osgitests.jar").start();
            framework.stop();
        }
    }
}

