/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.testing.GcFinalization;
import com.google.inject.internal.InternalFlags;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.Assert;

public class Asserts {
    private Asserts() {
    }

    public static String asModuleChain(Class ... classes) {
        return Joiner.on((String)" -> ").appendTo(new StringBuilder(" (via modules: "), Iterables.transform((Iterable)ImmutableList.copyOf((Object[])classes), Class::getName)).append(")").toString();
    }

    public static String getDeclaringSourcePart(Class clazz) {
        if (InternalFlags.getIncludeStackTraceOption() == InternalFlags.IncludeStackTraceOption.OFF) {
            return ".configure(Unknown Source";
        }
        return ".configure(" + clazz.getSimpleName() + ".java:";
    }

    public static boolean isIncludeStackTraceOff() {
        return InternalFlags.getIncludeStackTraceOption() == InternalFlags.IncludeStackTraceOption.OFF;
    }

    public static boolean isIncludeStackTraceComplete() {
        return InternalFlags.getIncludeStackTraceOption() == InternalFlags.IncludeStackTraceOption.COMPLETE;
    }

    public static void assertEqualsBothWays(Object expected, Object actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)"expected.equals(actual)", (Object)actual, (Object)expected);
        Assert.assertEquals((String)"actual.equals(expected)", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"hashCode", (int)expected.hashCode(), (int)actual.hashCode());
    }

    public static void assertContains(String text, String ... substrings) {
        Asserts.assertContains(text, false, substrings);
    }

    public static void assertContains(String text, boolean allowDuplicates, String ... substrings) {
        int startingFrom = 0;
        for (String substring : substrings) {
            int index = text.indexOf(substring, startingFrom);
            Assert.assertTrue((String)String.format("Expected \"%s\" to contain substring \"%s\"", text, substring), (index >= startingFrom ? 1 : 0) != 0);
            startingFrom = index + substring.length();
        }
        if (!allowDuplicates) {
            String lastSubstring = substrings[substrings.length - 1];
            Assert.assertTrue((String)String.format("Expected \"%s\" to contain substring \"%s\" only once),", text, lastSubstring), (text.indexOf(lastSubstring, startingFrom) == -1 ? 1 : 0) != 0);
        }
    }

    public static void assertEqualWhenReserialized(Object object) throws IOException {
        Object reserialized = Asserts.reserialize(object);
        Assert.assertEquals((Object)object, (Object)reserialized);
        Assert.assertEquals((int)object.hashCode(), (int)reserialized.hashCode());
    }

    public static void assertSimilarWhenReserialized(Object object) throws IOException {
        Object reserialized = Asserts.reserialize(object);
        Assert.assertEquals((String)object.toString(), (String)reserialized.toString());
    }

    public static <E> E reserialize(E original) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new ObjectOutputStream(out).writeObject(original);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Object reserialized = new ObjectInputStream(in).readObject();
            return (E)reserialized;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertNotSerializable(Object object) throws IOException {
        try {
            Asserts.reserialize(object);
            Assert.fail();
        }
        catch (NotSerializableException notSerializableException) {
            // empty catch block
        }
    }

    public static void awaitFullGc() {
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<Object> ref = new WeakReference<Object>(new Object(), queue);
        GcFinalization.awaitFullGc();
        try {
            Assert.assertSame((String)"queue didn't return ref in time", ref, queue.remove(5000L));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void awaitClear(WeakReference<?> ref) {
        Object data = ref.get();
        ReferenceQueue queue = null;
        WeakReference extraRef = null;
        if (data != null) {
            queue = new ReferenceQueue();
            extraRef = new WeakReference(data, queue);
            data = null;
        }
        GcFinalization.awaitClear(ref);
        if (queue != null) {
            try {
                Assert.assertSame((String)"queue didn't return ref in time", extraRef, queue.remove(5000L));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static URL[] getClassPathUrls() {
        if (Asserts.class.getClassLoader() instanceof URLClassLoader) {
            return ((URLClassLoader)Asserts.class.getClassLoader()).getURLs();
        }
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add((Object)new File(entry).toURI().toURL());
                }
                catch (SecurityException e) {
                    urls.add((Object)new URL("file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                AssertionError error = new AssertionError((Object)("malformed class path entry: " + entry));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
        }
        return (URL[])urls.build().toArray((Object[])new URL[0]);
    }
}

