/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class BindingOrderTest
extends TestCase {
    public void testBindingOutOfOrder() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(BoundFirst.class);
                this.bind(BoundSecond.class).to(BoundSecondImpl.class);
            }
        }});
    }

    public void testBindingOrderAndScopes() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(A.class);
                this.bind(B.class).asEagerSingleton();
            }
        }});
        BindingOrderTest.assertSame((Object)((A)injector.getInstance(A.class)).b, (Object)((A)injector.getInstance(A.class)).b);
    }

    public void testBindingWithExtraThreads() throws InterruptedException {
        final CountDownLatch ready = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        final Object createsAThread = new Object(){

            @Inject
            void createAnotherThread(final Injector injector) {
                new Thread(){

                    @Override
                    public void run() {
                        ready.countDown();
                        A a = (A)injector.getInstance(A.class);
                        ref.set(a.b);
                        done.countDown();
                    }
                }.start();
                try {
                    ready.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.requestInjection(createsAThread);
                this.bind(A.class).toInstance((Object)new A());
            }
        }});
        done.await();
        BindingOrderTest.assertNotNull(ref.get());
    }

    static class B {
        B() {
        }
    }

    static class A {
        @Inject
        B b;

        A() {
        }
    }

    static class BoundSecondImpl
    implements BoundSecond {
        BoundSecondImpl() {
        }
    }

    static interface BoundSecond {
    }

    public static class BoundFirst {
        @Inject
        public BoundFirst(BoundSecond boundSecond) {
        }
    }
}

