/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import junit.framework.TestCase;

public class BoundProviderTest
extends TestCase {
    public void testFooProvider() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toProvider(FooProvider.class);
            }
        }});
        Foo a = (Foo)injector.getInstance(Foo.class);
        Foo b = (Foo)injector.getInstance(Foo.class);
        BoundProviderTest.assertEquals((int)0, (int)a.i);
        BoundProviderTest.assertEquals((int)0, (int)b.i);
        BoundProviderTest.assertNotNull((Object)a.bar);
        BoundProviderTest.assertNotNull((Object)b.bar);
        BoundProviderTest.assertNotSame((Object)a.bar, (Object)b.bar);
    }

    public void testSingletonFooProvider() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toProvider(SingletonFooProvider.class);
            }
        }});
        Foo a = (Foo)injector.getInstance(Foo.class);
        Foo b = (Foo)injector.getInstance(Foo.class);
        BoundProviderTest.assertEquals((int)0, (int)a.i);
        BoundProviderTest.assertEquals((int)1, (int)b.i);
        BoundProviderTest.assertNotNull((Object)a.bar);
        BoundProviderTest.assertNotNull((Object)b.bar);
        BoundProviderTest.assertSame((Object)a.bar, (Object)b.bar);
    }

    @Singleton
    static class SingletonFooProvider
    implements Provider<Foo> {
        final Bar bar;
        int count = 0;

        @Inject
        public SingletonFooProvider(Bar bar) {
            this.bar = bar;
        }

        public Foo get() {
            return new Foo(this.bar, this.count++);
        }
    }

    static class FooProvider
    implements Provider<Foo> {
        final Bar bar;
        int count = 0;

        @Inject
        public FooProvider(Bar bar) {
            this.bar = bar;
        }

        public Foo get() {
            return new Foo(this.bar, this.count++);
        }
    }

    static class Foo {
        final Bar bar;
        final int i;

        Foo(Bar bar, int i) {
            this.bar = bar;
            this.i = i;
        }
    }

    static class Bar {
        Bar() {
        }
    }
}

