/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class DuplicateBindingsTest
extends TestCase {
    private FooImpl foo = new FooImpl();
    private Provider<Foo> pFoo = Providers.of((Object)new FooImpl());
    private Class<? extends Provider<? extends Foo>> pclFoo = FooProvider.class;
    private Class<? extends Foo> clFoo = FooImpl.class;
    private Constructor<FooImpl> cFoo = FooImpl.access$000();

    public void testDuplicateBindingsAreIgnored() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
        ArrayList bindings = Lists.newArrayList(injector.getAllBindings().keySet());
        this.removeBasicBindings(bindings);
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(Foo.class, (Annotation)Names.named((String)"instance"))));
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(Foo.class, (Annotation)Names.named((String)"pInstance"))));
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(Foo.class, (Annotation)Names.named((String)"pKey"))));
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(Foo.class, (Annotation)Names.named((String)"linkedKey"))));
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(FooImpl.class)));
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(Foo.class, (Annotation)Names.named((String)"constructor"))));
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(FooProvider.class)));
        DuplicateBindingsTest.assertTrue((boolean)bindings.remove(Key.get(Foo.class, (Annotation)Names.named((String)"providerMethod"))));
        DuplicateBindingsTest.assertEquals((String)((Object)bindings).toString(), (int)0, (int)bindings.size());
    }

    public void testElementsDeduplicate() {
        List elements = Elements.getElements((Module[])new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
        DuplicateBindingsTest.assertEquals((int)14, (int)elements.size());
        DuplicateBindingsTest.assertEquals((int)7, (int)new LinkedHashSet(elements).size());
    }

    public void testProviderMethodsFailIfInstancesDiffer() {
        try {
            Guice.createInjector((Module[])new Module[]{new FailingProviderModule(), new FailingProviderModule()});
            DuplicateBindingsTest.fail((String)"should have failed");
        }
        catch (CreationException ce) {
            Asserts.assertContains(ce.getMessage(), "A binding to " + Foo.class.getName() + " was already configured at " + FailingProviderModule.class.getName(), "at " + FailingProviderModule.class.getName());
        }
    }

    public void testSameScopeInstanceIgnored() {
        Guice.createInjector((Module[])new Module[]{new ScopedModule(Scopes.SINGLETON, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new ScopedModule(Scopes.SINGLETON, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
        Guice.createInjector((Module[])new Module[]{new ScopedModule(Scopes.NO_SCOPE, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new ScopedModule(Scopes.NO_SCOPE, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
    }

    public void testSameScopeAnnotationIgnored() {
        Guice.createInjector((Module[])new Module[]{new AnnotatedScopeModule(Singleton.class, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new AnnotatedScopeModule(Singleton.class, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
    }

    public void testMixedAnnotationAndScopeForSingletonIgnored() {
        Guice.createInjector((Module[])new Module[]{new ScopedModule(Scopes.SINGLETON, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new AnnotatedScopeModule(Singleton.class, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
    }

    public void testMixedScopeAndUnscopedIgnored() {
        Guice.createInjector((Module[])new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new ScopedModule(Scopes.NO_SCOPE, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
    }

    public void testMixedScopeFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new ScopedModule(Scopes.SINGLETON, this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
            DuplicateBindingsTest.fail((String)"expected exception");
        }
        catch (CreationException ce) {
            String segment1 = "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"pInstance") + " was already configured at " + SimpleModule.class.getName();
            String segment2 = "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"pKey") + " was already configured at " + SimpleModule.class.getName();
            String segment3 = "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"constructor") + " was already configured at " + SimpleModule.class.getName();
            String segment4 = "A binding to " + FooImpl.class.getName() + " was already configured at " + SimpleModule.class.getName();
            String atSegment = "at " + ScopedModule.class.getName();
            if (Asserts.isIncludeStackTraceOff()) {
                Asserts.assertContains(ce.getMessage(), segment1, atSegment, segment2, atSegment, segment3, atSegment, segment4, atSegment);
            }
            Asserts.assertContains(ce.getMessage(), segment1, atSegment, segment2, atSegment, segment4, atSegment, segment3, atSegment);
        }
    }

    public void testMixedTargetsFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new SimpleModule(new FooImpl(), (Provider<Foo>)Providers.of((Object)new FooImpl()), BarProvider.class, Bar.class, Bar.cxtor())});
            DuplicateBindingsTest.fail((String)"expected exception");
        }
        catch (CreationException ce) {
            Asserts.assertContains(ce.getMessage(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"pInstance") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"pKey") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"linkedKey") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"constructor") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName());
        }
    }

    public void testExceptionInEqualsThrowsCreationException() {
        try {
            Guice.createInjector((Module[])new Module[]{new ThrowingModule(), new ThrowingModule()});
            DuplicateBindingsTest.fail((String)"expected exception");
        }
        catch (CreationException ce) {
            Asserts.assertContains(ce.getMessage(), "A binding to " + Foo.class.getName() + " was already configured at " + ThrowingModule.class.getName(), "and an error was thrown while checking duplicate bindings.  Error: java.lang.RuntimeException: Boo!", "at " + ThrowingModule.class.getName());
        }
    }

    public void testChildInjectorDuplicateParentFail() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
        try {
            injector.createChildInjector(new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
            DuplicateBindingsTest.fail((String)"expected exception");
        }
        catch (CreationException ce) {
            Asserts.assertContains(ce.getMessage(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"pInstance") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"pKey") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"linkedKey") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"constructor") + " was already configured at " + SimpleModule.class.getName(), "at " + SimpleModule.class.getName(), "A binding to " + Foo.class.getName() + " annotated with " + Names.named((String)"providerMethod") + " was already configured at " + SimpleProviderModule.class.getName(), "at " + SimpleProviderModule.class.getName());
        }
    }

    public void testDuplicatesSolelyInChildIgnored() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        injector.createChildInjector(new Module[]{new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo), new SimpleModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
    }

    public void testDifferentBindingTypesFail() {
        List elements = Elements.getElements((Module[])new Module[]{new FailedModule(this.foo, this.pFoo, this.pclFoo, this.clFoo, this.cFoo)});
        for (Element e1 : elements) {
            for (Element e2 : elements) {
                try {
                    Guice.createInjector((Module[])new Module[]{Elements.getModule(Arrays.asList(e1, e2))});
                    if (e1 == e2) continue;
                    DuplicateBindingsTest.fail((String)"must fail!");
                }
                catch (CreationException expected) {
                    if (e1 != e2) {
                        Asserts.assertContains(expected.getMessage(), "A binding to " + Foo.class.getName() + " was already configured at " + FailedModule.class.getName(), "at " + FailedModule.class.getName());
                        continue;
                    }
                    throw expected;
                }
            }
        }
    }

    public void testJitBindingsAreCheckedAfterConversions() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(A.class);
                this.bind(A.class).to(RealA.class);
            }
        }});
    }

    public void testEqualsNotCalledByDefaultOnInstance() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnEquals = true;
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class);
                this.bind(HashEqualsTester.class).toInstance((Object)a);
            }
        }});
    }

    public void testEqualsNotCalledByDefaultOnProvider() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnEquals = true;
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class);
                this.bind(Object.class).toProvider((Provider)a);
            }
        }});
    }

    public void testHashcodeNeverCalledOnInstance() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnHashcode = true;
        a.equality = "test";
        final HashEqualsTester b = new HashEqualsTester();
        b.throwOnHashcode = true;
        b.equality = "test";
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class);
                this.bind(HashEqualsTester.class).toInstance((Object)a);
                this.bind(HashEqualsTester.class).toInstance((Object)b);
            }
        }});
    }

    public void testHashcodeNeverCalledOnProviderInstance() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnHashcode = true;
        a.equality = "test";
        final HashEqualsTester b = new HashEqualsTester();
        b.throwOnHashcode = true;
        b.equality = "test";
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class);
                this.bind(Object.class).toProvider((Provider)a);
                this.bind(Object.class).toProvider((Provider)b);
            }
        }});
    }

    private void removeBasicBindings(Collection<Key<?>> bindings) {
        bindings.remove(Key.get(Injector.class));
        bindings.remove(Key.get(Logger.class));
        bindings.remove(Key.get(Stage.class));
    }

    private static class HashEqualsTester
    implements Provider<Object> {
        private String equality;
        private boolean throwOnEquals;
        private boolean throwOnHashcode;

        private HashEqualsTester() {
        }

        public boolean equals(Object obj) {
            if (this.throwOnEquals) {
                throw new RuntimeException();
            }
            if (obj instanceof HashEqualsTester) {
                HashEqualsTester o = (HashEqualsTester)obj;
                if (o.throwOnEquals) {
                    throw new RuntimeException();
                }
                if (this.equality == null && o.equality == null) {
                    return this == o;
                }
                return Objects.equal((Object)this.equality, (Object)o.equality);
            }
            return false;
        }

        public int hashCode() {
            if (this.throwOnHashcode) {
                throw new RuntimeException();
            }
            return super.hashCode();
        }

        public Object get() {
            return new Object();
        }
    }

    private static class BarProvider
    implements Provider<Foo> {
        private BarProvider() {
        }

        public Foo get() {
            return new Bar();
        }
    }

    private static class Bar
    implements Foo {
        @Inject
        public Bar() {
        }

        private static Constructor<Bar> cxtor() {
            try {
                return Bar.class.getConstructor(new Class[0]);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FooProvider
    implements Provider<Foo> {
        private FooProvider() {
        }

        public Foo get() {
            return new FooImpl();
        }
    }

    private static class FooImpl
    implements Foo {
        @Inject
        public FooImpl() {
        }

        private static Constructor<FooImpl> cxtor() {
            try {
                return FooImpl.class.getConstructor(new Class[0]);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        static /* synthetic */ Constructor access$000() {
            return FooImpl.cxtor();
        }
    }

    private static interface Foo {
    }

    private static class AnnotatedScopeModule
    extends FooModule {
        private final Class<? extends Annotation> scope;

        AnnotatedScopeModule(Class<? extends Annotation> scope, FooImpl foo, Provider<Foo> pFoo, Class<? extends Provider<? extends Foo>> pclFoo, Class<? extends Foo> clFoo, Constructor<FooImpl> cFoo) {
            super(foo, pFoo, pclFoo, clFoo, cFoo);
            this.scope = scope;
        }

        protected void configure() {
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"pInstance")).toProvider(this.pFoo).in(this.scope);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"pKey")).toProvider(this.pclFoo).in(this.scope);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"linkedKey")).to(this.clFoo).in(this.scope);
            this.bind(FooImpl.class).in(this.scope);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"constructor")).toConstructor(this.cFoo).in(this.scope);
        }
    }

    private static class ScopedModule
    extends FooModule {
        private final Scope scope;

        ScopedModule(Scope scope, FooImpl foo, Provider<Foo> pFoo, Class<? extends Provider<? extends Foo>> pclFoo, Class<? extends Foo> clFoo, Constructor<FooImpl> cFoo) {
            super(foo, pFoo, pclFoo, clFoo, cFoo);
            this.scope = scope;
        }

        protected void configure() {
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"pInstance")).toProvider(this.pFoo).in(this.scope);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"pKey")).toProvider(this.pclFoo).in(this.scope);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"linkedKey")).to(this.clFoo).in(this.scope);
            this.bind(FooImpl.class).in(this.scope);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"constructor")).toConstructor(this.cFoo).in(this.scope);
        }
    }

    private static class SimpleModule
    extends FooModule {
        SimpleModule(FooImpl foo, Provider<Foo> pFoo, Class<? extends Provider<? extends Foo>> pclFoo, Class<? extends Foo> clFoo, Constructor<FooImpl> cFoo) {
            super(foo, pFoo, pclFoo, clFoo, cFoo);
        }

        protected void configure() {
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"instance")).toInstance((Object)this.foo);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"pInstance")).toProvider(this.pFoo);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"pKey")).toProvider(this.pclFoo);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"linkedKey")).to(this.clFoo);
            this.bind(FooImpl.class);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"constructor")).toConstructor(this.cFoo);
            this.install(Elements.getModule((Iterable)Elements.getElements((Module[])new Module[]{new SimpleProviderModule()})));
        }
    }

    private static class SimpleProviderModule
    extends AbstractModule {
        private SimpleProviderModule() {
        }

        @Provides
        @Named(value="providerMethod")
        Foo foo() {
            return null;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    private static class FailingProviderModule
    extends AbstractModule {
        private FailingProviderModule() {
        }

        @Provides
        Foo foo() {
            return null;
        }
    }

    private static class FailedModule
    extends FooModule {
        FailedModule(FooImpl foo, Provider<Foo> pFoo, Class<? extends Provider<? extends Foo>> pclFoo, Class<? extends Foo> clFoo, Constructor<FooImpl> cFoo) {
            super(foo, pFoo, pclFoo, clFoo, cFoo);
        }

        protected void configure() {
            this.bind(Foo.class).toInstance((Object)this.foo);
            this.bind(Foo.class).toProvider(this.pFoo);
            this.bind(Foo.class).toProvider(this.pclFoo);
            this.bind(Foo.class).to(this.clFoo);
            this.bind(Foo.class).toConstructor(this.cFoo);
        }

        @Provides
        Foo foo() {
            return null;
        }
    }

    private static abstract class FooModule
    extends AbstractModule {
        protected final FooImpl foo;
        protected final Provider<Foo> pFoo;
        protected final Class<? extends Provider<? extends Foo>> pclFoo;
        protected final Class<? extends Foo> clFoo;
        protected final Constructor<FooImpl> cFoo;

        FooModule(FooImpl foo, Provider<Foo> pFoo, Class<? extends Provider<? extends Foo>> pclFoo, Class<? extends Foo> clFoo, Constructor<FooImpl> cFoo) {
            this.foo = foo;
            this.pFoo = pFoo;
            this.pclFoo = pclFoo;
            this.clFoo = clFoo;
            this.cFoo = cFoo;
        }
    }

    private static class ThrowingModule
    extends AbstractModule {
        private ThrowingModule() {
        }

        protected void configure() {
            this.bind(Foo.class).toInstance((Object)new Foo(){

                public boolean equals(Object obj) {
                    throw new RuntimeException("Boo!");
                }

                public int hashCode() {
                    throw new RuntimeException("Boo!");
                }
            });
        }
    }

    @ImplementedBy(value=RealA.class)
    private static class A {
        private A() {
        }
    }

    private static class RealA
    extends A {
        private RealA() {
        }
    }
}

