/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;

public class ErrorHandlingTest {
    @Inject
    @Named(value="missing")
    static List<String> missing = null;

    public static void main(String[] args) throws CreationException {
        try {
            Guice.createInjector((Module[])new Module[]{new MyModule()});
        }
        catch (CreationException e) {
            e.printStackTrace();
            System.err.println("--");
        }
        Injector bad = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider((Provider)new Provider<String>(){

                    public String get() {
                        return null;
                    }
                });
            }
        }});
        try {
            bad.getInstance(String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("--");
        }
        try {
            bad.getInstance(NeedsString.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("--");
        }
    }

    static class MyModule
    extends AbstractModule {
        MyModule() {
        }

        protected void configure() {
            this.bind(Runnable.class);
            this.bind(Foo.class);
            this.bind(Bar.class);
            this.bind(Tee.class);
            this.bind((TypeLiteral)new TypeLiteral<List<String>>(){});
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"foo")).in(Named.class);
            this.bind(Key.get(Runnable.class)).to(Key.get(Runnable.class));
            this.bind(TooManyScopes.class);
            this.bindScope(BadScope.class, Scopes.SINGLETON);
            this.bind(Object.class).toInstance(new Object(){

                @Inject
                void foo() {
                    throw new RuntimeException();
                }
            });
            this.requestStaticInjection(new Class[]{ErrorHandlingTest.class});
            this.addError("I don't like %s", new Object[]{"you"});
            String o = "2";
            try {
                Integer n = (Integer)((Object)o);
            }
            catch (Exception e) {
                this.addError(e);
            }
            this.bind(Module.class).toInstance((Object)this);
            this.bind(I.class);
        }
    }

    @ImplementedBy(value=String.class)
    static interface I {
    }

    static @interface BadScope {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ScopeAnnotation
    static @interface GoodScope {
    }

    @Singleton
    @GoodScope
    static class TooManyScopes {
        TooManyScopes() {
        }
    }

    static class Invalid {
        Invalid(String s) {
        }
    }

    static class Tee {
        @Inject
        String s;
        @Inject
        Invalid invalid;

        Tee() {
        }

        @Inject
        void tee(String s, int i) {
        }
    }

    static class Bar {
        Bar(String s) {
        }

        @Inject
        void setNumbers(@Named(value="numbers") List<Integer> numbers) {
        }

        @Inject
        void bar(@Named(value="foo") String s) {
        }
    }

    static class Foo {
        @Inject
        public Foo(Runnable r) {
        }

        @Inject
        void setNames(List<String> names) {
        }
    }

    static class NeedsString {
        @Inject
        String mofo;

        NeedsString() {
        }
    }
}

